/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.entities.entity;

import com.deriys.divinerelics.capabilities.thor.FightsThorProvider;
import com.deriys.divinerelics.config.DivineRelicsCommonConfig;
import com.deriys.divinerelics.core.networking.DRMessages;
import com.deriys.divinerelics.core.networking.packets.ThorPlayMusicS2CPacket;
import com.deriys.divinerelics.core.networking.packets.ThorStopMusicS2CPacket;
import com.deriys.divinerelics.entities.ai.thor.FireIgnoringPathNavigation;
import com.deriys.divinerelics.entities.ai.thor.ThorAttackGoal;
import com.deriys.divinerelics.entities.ai.thor.ThorAttackState;
import com.deriys.divinerelics.entities.entity.DraugrEntity;
import com.deriys.divinerelics.entities.entity.ThrownMjolnir;
import com.deriys.divinerelics.init.DRItems;
import com.deriys.divinerelics.init.DRSounds;
import com.deriys.divinerelics.items.DraupnirSpear;
import com.deriys.divinerelics.items.Motosignir;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class ThorEntity
extends Monster
implements IAnimatable {
    public static final int INTRO_MUSIC_DURATION = 549;
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final AttributeModifier SLOW_SPEED_MODIFIER = new AttributeModifier("SlowSpeed", 0.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AttributeModifier FAST_SPEED_MODIFIER = new AttributeModifier("FastSpeed", ((Double)DivineRelicsCommonConfig.THOR_SPEED_MODIFIER.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(ThorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> ATTACK_STATE = SynchedEntityData.m_135353_(ThorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> HAS_MJOLNIR_IN_HANDS = SynchedEntityData.m_135353_(ThorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WAITS_FOR_MJOLNIR = SynchedEntityData.m_135353_(ThorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACKING_TICKS = SynchedEntityData.m_135353_(ThorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SUMMONING_COMPLETE = SynchedEntityData.m_135353_(ThorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.m_237113_((String)"Thor").m_130940_(ChatFormatting.BOLD), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
    public static final int INVULNERABLE_TICKS = 549;
    public static final int[] LIGHTNING_TICKS = new int[]{149, 223, 323, 394, 462, 481, 516};
    public DamageSource thorDamageSource = DamageSource.m_19370_((LivingEntity)this);
    public UUID thrownMjolnirUUID = null;
    private List<ServerPlayer> trackingPlayers = new ArrayList<ServerPlayer>();
    public short ambientSoundCount = (short)-1;
    public int ambientSoundInterval = this.m_8100_();
    public static final SoundEvent[] AMBIENT_SOUNDS = new SoundEvent[]{(SoundEvent)DRSounds.THOR_AMBIENT_1.get(), (SoundEvent)DRSounds.THOR_AMBIENT_2.get(), (SoundEvent)DRSounds.THOR_AMBIENT_3.get(), (SoundEvent)DRSounds.THOR_AMBIENT_7.get(), (SoundEvent)DRSounds.THOR_AMBIENT_4.get(), (SoundEvent)DRSounds.THOR_AMBIENT_5.get(), (SoundEvent)DRSounds.THOR_AMBIENT_6.get(), (SoundEvent)DRSounds.THOR_AMBIENT_8.get(), (SoundEvent)DRSounds.THOR_AMBIENT_9.get()};
    private List<UUID> needMusicReplay = new ArrayList<UUID>();
    private List<UUID> initialPlayersNearby = new ArrayList<UUID>();

    public ThorEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_21530_();
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setAttackState(ThorAttackState state) {
        if (state != ThorAttackState.NONE) {
            this.setHasMjolnirInHands(state != ThorAttackState.CLAP_ATTACK && state != ThorAttackState.GROUND_ATTACK && state != ThorAttackState.LEG_ATTACK);
        }
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)((byte)state.ordinal()));
    }

    public ThorAttackState getAttackState() {
        return ThorAttackState.getState((Byte)this.f_19804_.m_135370_(ATTACK_STATE));
    }

    public void setHasMjolnirInHands(boolean hasMjolnir) {
        this.f_19804_.m_135381_(HAS_MJOLNIR_IN_HANDS, (Object)hasMjolnir);
    }

    public boolean hasMjolnirInHands() {
        return (Boolean)this.f_19804_.m_135370_(HAS_MJOLNIR_IN_HANDS);
    }

    public boolean waitsForMjolnir() {
        return (Boolean)this.f_19804_.m_135370_(WAITS_FOR_MJOLNIR);
    }

    public void setWaitsForMjolnir(boolean waitsForMjolnir) {
        this.f_19804_.m_135381_(WAITS_FOR_MJOLNIR, (Object)waitsForMjolnir);
    }

    public void setAttackingTicks(int ticks) {
        this.f_19804_.m_135381_(ATTACKING_TICKS, (Object)ticks);
    }

    public int getAttackingTicks() {
        return (Integer)this.f_19804_.m_135370_(ATTACKING_TICKS);
    }

    public void setSummoningComplete(boolean summoningComplete) {
        this.f_19804_.m_135381_(SUMMONING_COMPLETE, (Object)summoningComplete);
    }

    public boolean isSummoningComplete() {
        return (Boolean)this.f_19804_.m_135370_(SUMMONING_COMPLETE);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(1, (Goal)new ThorAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, ((Double)DivineRelicsCommonConfig.THOR_HP.get()).doubleValue()).m_22268_(Attributes.f_22277_, ((Double)DivineRelicsCommonConfig.THOR_FOLLOW_RANGE.get()).doubleValue()).m_22268_(Attributes.f_22278_, ((Double)DivineRelicsCommonConfig.THOR_KB_RESISTANCE.get()).doubleValue()).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, ((Double)DivineRelicsCommonConfig.THOR_DAMAGE.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)DivineRelicsCommonConfig.THOR_ARMOR.get()).doubleValue()).m_22266_(Attributes.f_22287_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
        this.f_19804_.m_135372_(HAS_MJOLNIR_IN_HANDS, (Object)true);
        this.f_19804_.m_135372_(WAITS_FOR_MJOLNIR, (Object)false);
        this.f_19804_.m_135372_(ATTACKING_TICKS, (Object)0);
        this.f_19804_.m_135372_(SUMMONING_COMPLETE, (Object)false);
    }

    public void m_8119_() {
        LivingEntity target;
        ServerLevel serverLevel;
        Object copyList;
        float bossBarProgress = this.m_21223_() / this.m_21233_();
        if (this.bossEvent.m_142717_() != bossBarProgress) {
            this.bossEvent.m_142711_(bossBarProgress);
        }
        boolean summoningComplete = this.isSummoningComplete();
        if (!this.f_19853_.f_46443_ && summoningComplete) {
            if (!this.trackingPlayers.isEmpty()) {
                for (ServerPlayer trackingPlayer : this.trackingPlayers) {
                    if (!(trackingPlayer.m_20182_().m_82557_(this.m_20182_()) < 2500.0)) continue;
                    this.bossEvent.m_6543_(trackingPlayer);
                }
                this.trackingPlayers = new ArrayList<ServerPlayer>();
            }
            LivingEntity target2 = this.m_5448_();
            if (this.m_5912_() && !(target2 instanceof Mob) && this.m_6084_() && this.f_19796_.m_188503_(1000) < this.ambientSoundInterval++) {
                this.resetAmbientInterval();
                this.ambientSoundCount = (short)(this.ambientSoundCount + 1);
                this.m_5496_(AMBIENT_SOUNDS[this.ambientSoundCount % 9], this.m_6121_(), this.m_6100_());
            }
            if (this.f_19797_ >= 549 && !this.needMusicReplay.isEmpty()) {
                ServerLevel serverLevel2 = (ServerLevel)this.f_19853_;
                copyList = List.copyOf(this.needMusicReplay);
                Iterator iterator = copyList.iterator();
                while (iterator.hasNext()) {
                    UUID playerUUID = (UUID)iterator.next();
                    Entity entity = serverLevel2.m_8791_(playerUUID);
                    if (!(entity instanceof ServerPlayer)) continue;
                    ServerPlayer player = (ServerPlayer)entity;
                    ThorEntity.stopSoundForPlayer(player, (SoundEvent)DRSounds.THOR_FIGHT_MUSIC.get(), SoundSource.RECORDS);
                    ThorEntity.stopSoundForPlayer(player, (SoundEvent)DRSounds.THOR_FIGHT_MUSIC_LOOP.get(), SoundSource.RECORDS);
                    ThorEntity.playSoundForPlayer(player, (SoundEvent)DRSounds.THOR_FIGHT_MUSIC_LOOP.get(), this.m_20097_());
                    if (!this.initialPlayersNearby.contains(playerUUID)) {
                        this.addInitialPlayersNearby((Player)player);
                    }
                    this.needMusicReplay.remove(playerUUID);
                }
            }
        }
        if (!this.f_19853_.f_46443_ && this.waitsForMjolnir() && (copyList = (serverLevel = (ServerLevel)this.f_19853_).m_8791_(this.thrownMjolnirUUID)) instanceof ThrownMjolnir) {
            ThrownMjolnir thrownMjolnir = (ThrownMjolnir)((Object)copyList);
            if (thrownMjolnir.m_20096_() || thrownMjolnir.hasHit()) {
                thrownMjolnir.setReturning(true);
            }
            if (thrownMjolnir.isReturning() && this.m_20182_().m_82557_(thrownMjolnir.m_20182_()) < 15.0) {
                ThorAttackState attackState = this.getAttackState();
                if (attackState != ThorAttackState.CLAP_ATTACK && attackState != ThorAttackState.GROUND_ATTACK) {
                    this.setHasMjolnirInHands(true);
                }
                thrownMjolnir.m_146870_();
                this.setWaitsForMjolnir(false);
                this.thrownMjolnirUUID = null;
            }
        }
        BlockPos onPos = this.m_20097_();
        if (!summoningComplete && !this.f_19853_.f_46443_) {
            if (this.f_19797_ < 549) {
                if (ThorEntity.contains(LIGHTNING_TICKS, this.f_19797_)) {
                    ThrownMjolnir.spawnLightning(this.f_19853_, ThrownMjolnir.getRandBlockPos(onPos.m_7918_(0, -10, 0), 100, 100, 50), (Entity)this);
                }
            } else if (this.f_19797_ == 549) {
                this.m_6021_(this.m_20185_(), this.m_20186_() - 10.0, this.m_20189_());
                ThrownMjolnir.spawnLightning(this.f_19853_, onPos, (Entity)this);
                ThrownMjolnir.onHitLighnting(this.f_19853_, (Entity)this, onPos, (LivingEntity)this, this.thorDamageSource, 10.0, 2.0, 12.0);
                this.setSummoningComplete(true);
                this.m_21557_(false);
            }
        }
        DraugrEntity.setChasing((LivingEntity)this, FAST_SPEED_MODIFIER, SLOW_SPEED_MODIFIER, (target = this.m_5448_()) != null && target.m_6084_());
        int attackingTicks = this.getAttackingTicks();
        if (attackingTicks > 0) {
            this.setAttackingTicks(attackingTicks - 1);
        }
        super.m_8119_();
    }

    public boolean canSeeTarget(LivingEntity target) {
        Vec3 endPos;
        Level level = this.f_19853_;
        Vec3 startPos = this.m_20182_().m_82520_(0.0, (double)this.m_20192_(), 0.0);
        ClipContext context = new ClipContext(startPos, endPos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this);
        BlockHitResult result = level.m_45547_(context);
        return result.m_6662_() == HitResult.Type.MISS;
    }

    public static boolean contains(int[] arr, int value) {
        return Arrays.stream(arr).anyMatch(x -> x == value);
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19797_ = compoundTag.m_128451_("TickCount");
        this.ambientSoundCount = compoundTag.m_128448_("AmbientSoundCount");
        this.setSummoningComplete(compoundTag.m_128471_("SummoningComplete"));
        this.setAttacking(compoundTag.m_128471_("Attacking"));
        this.setAttackState(ThorAttackState.getState(compoundTag.m_128445_("AttackState")));
        this.setHasMjolnirInHands(compoundTag.m_128471_("HasMjolnirInHands"));
        this.setAttackingTicks(compoundTag.m_128451_("AttackingTicks"));
        if (compoundTag.m_128403_("ThrownMjolnirUUID")) {
            this.thrownMjolnirUUID = compoundTag.m_128342_("ThrownMjolnirUUID");
        }
        this.setWaitsForMjolnir(compoundTag.m_128471_("WaitsForMjolnir"));
        ListTag needMusicReplayList = compoundTag.m_128437_("NeedMusicReplay", 8);
        this.needMusicReplay = new ArrayList<UUID>();
        for (int i = 0; i < needMusicReplayList.size(); ++i) {
            this.needMusicReplay.add(UUID.fromString(needMusicReplayList.m_128778_(i)));
        }
        ListTag initialPlayerNearbyList = compoundTag.m_128437_("initialPlayersNearby", 8);
        this.initialPlayersNearby = new ArrayList<UUID>();
        for (int i = 0; i < initialPlayerNearbyList.size(); ++i) {
            this.initialPlayersNearby.add(UUID.fromString(initialPlayerNearbyList.m_128778_(i)));
        }
    }

    public void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("SummoningComplete", this.isSummoningComplete());
        compoundTag.m_128379_("Attacking", this.isAttacking());
        compoundTag.m_128379_("HasMjolnirInHands", ((Boolean)this.f_19804_.m_135370_(HAS_MJOLNIR_IN_HANDS)).booleanValue());
        compoundTag.m_128379_("WaitsForMjolnir", this.waitsForMjolnir());
        compoundTag.m_128405_("AttackingTicks", this.getAttackingTicks());
        compoundTag.m_128405_("TickCount", this.f_19797_);
        compoundTag.m_128376_("AmbientSoundCount", this.ambientSoundCount);
        compoundTag.m_128344_("AttackState", ((Byte)this.f_19804_.m_135370_(ATTACK_STATE)).byteValue());
        if (this.thrownMjolnirUUID != null) {
            compoundTag.m_128362_("ThrownMjolnirUUID", this.thrownMjolnirUUID);
        }
        ListTag needMusicReplayList = new ListTag();
        for (UUID uuid : this.needMusicReplay) {
            needMusicReplayList.add((Object)StringTag.m_129297_((String)uuid.toString()));
        }
        compoundTag.m_128365_("NeedMusicReplay", (Tag)needMusicReplayList);
        ListTag initialPlayersNearbyList = new ListTag();
        for (UUID uuid : this.initialPlayersNearby) {
            initialPlayersNearbyList.add((Object)StringTag.m_129297_((String)uuid.toString()));
        }
        compoundTag.m_128365_("initialPlayersNearby", (Tag)initialPlayersNearbyList);
    }

    public void m_6043_() {
    }

    public void m_6457_(@NotNull ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (!this.isSummoningComplete()) {
            this.trackingPlayers.add(serverPlayer);
        } else {
            this.bossEvent.m_6543_(serverPlayer);
        }
        UUID playerUUID = serverPlayer.m_20148_();
        boolean containsInInitialList = this.initialPlayersNearby.contains(playerUUID);
        if (!containsInInitialList && !this.needMusicReplay.contains(playerUUID)) {
            this.needMusicReplay.add(playerUUID);
        } else if (containsInInitialList && !this.needMusicReplay.contains(playerUUID)) {
            serverPlayer.getCapability(FightsThorProvider.FIGHTS_THOR).ifPresent(fightsThor -> {
                List<String> thorList = fightsThor.getThorList();
                if (!thorList.isEmpty()) {
                    for (String thorStringUUID : thorList) {
                        if (!UUID.fromString(thorStringUUID).equals(this.m_20148_()) || !fightsThor.hasLoggedOut()) continue;
                        this.needMusicReplay.add(playerUUID);
                        fightsThor.setHasLoggedOut(false);
                    }
                }
            });
        }
    }

    public void m_6452_(@NotNull ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    public void startPlayingBossMusic() {
        List<Player> playersNearby = Motosignir.getEntitiesInAreaOfClass(Player.class, this.f_19853_, (Entity)this, 50.0);
        if (!playersNearby.isEmpty()) {
            for (Player player : playersNearby) {
                this.addInitialPlayersNearby(player);
            }
        }
        ItemStack musicDisc = new ItemStack((ItemLike)DRItems.THOR_FIGHT_MUSIC_DISC.get());
        BlockPos onPos = this.m_20097_();
        this.f_19853_.m_5898_(null, 1010, onPos, Item.m_41393_((Item)musicDisc.m_41720_()));
    }

    private void addInitialPlayersNearby(Player player) {
        player.getCapability(FightsThorProvider.FIGHTS_THOR).ifPresent(fightsThor -> fightsThor.addThor(this.m_20149_()));
        this.initialPlayersNearby.add(player.m_20148_());
    }

    public void stopPlayingBossMusic() {
        if (!this.initialPlayersNearby.isEmpty()) {
            ServerLevel serverLevel = (ServerLevel)this.f_19853_;
            for (UUID playerUUID : this.initialPlayersNearby) {
                Entity entity = serverLevel.m_8791_(playerUUID);
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ThorEntity.stopSoundForPlayer(serverPlayer, (SoundEvent)DRSounds.THOR_FIGHT_MUSIC.get(), SoundSource.RECORDS);
                ThorEntity.stopSoundForPlayer(serverPlayer, (SoundEvent)DRSounds.THOR_FIGHT_MUSIC_LOOP.get(), SoundSource.RECORDS);
            }
        }
    }

    public static void playSoundForPlayer(ServerPlayer player, SoundEvent soundEvent, BlockPos blockPos) {
        DRMessages.sendToPlayer(new ThorPlayMusicS2CPacket(soundEvent.m_11660_(), blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), player);
    }

    public static void stopSoundForPlayer(ServerPlayer player, SoundEvent soundEvent, SoundSource soundSource) {
        DRMessages.sendToPlayer(new ThorStopMusicS2CPacket(soundEvent.m_11660_(), soundSource), player);
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        if (damageSource.m_7639_() instanceof Player) {
            this.m_19983_(new ItemStack((ItemLike)DRItems.PERFECT_ASGARDIAN_STEEL_INGOT.get(), 4));
            if ((double)DraupnirSpear.RAND.nextFloat() < 0.1) {
                this.m_19983_(new ItemStack((ItemLike)DRItems.ASGARDIAN_STEEL_NUGGET.get(), DraupnirSpear.RAND.nextInt(3, 7)));
            }
            if ((double)DraupnirSpear.RAND.nextFloat() < 0.02) {
                this.m_19983_(new ItemStack((ItemLike)DRItems.THOR_FIGHT_MUSIC_DISC.get()));
            }
        }
        super.m_6667_(damageSource);
        this.bossEvent.m_8321_(false);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.removeThorFromPlayerCapability(serverLevel);
            serverLevel.m_8606_(0, 0, false, false);
            this.stopPlayingBossMusic();
            this.f_19853_.m_5594_(null, this.m_20097_(), (SoundEvent)DRSounds.THOR_DEATH_SOUND.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
        }
    }

    private void removeThorFromPlayerCapability(ServerLevel serverLevel) {
        if (!this.initialPlayersNearby.isEmpty()) {
            for (UUID playerUUID : this.initialPlayersNearby) {
                Entity entity = serverLevel.m_8791_(playerUUID);
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                player.getCapability(FightsThorProvider.FIGHTS_THOR).ifPresent(fightsThor -> fightsThor.removeThor(this.m_20149_()));
            }
        }
    }

    public int m_213860_() {
        return (Integer)DivineRelicsCommonConfig.THOR_XP_AMOUNT.get();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isAttacking() && this.getAttackingTicks() == 0) {
            event.getController().markNeedsReload();
            switch (this.getAttackState()) {
                case MELEE_ATTACK: {
                    this.setAttackAnimation(event, "animation.thor.melee_attack", 24);
                    break;
                }
                case LEG_ATTACK: {
                    this.setAttackAnimation(event, "animation.thor.leg_attack", 30);
                    break;
                }
                case CLAP_ATTACK: {
                    this.setAttackAnimation(event, "animation.thor.clap_attack", 48);
                    break;
                }
                case GROUND_ATTACK: {
                    this.setAttackAnimation(event, "animation.thor.ground_attack", 50);
                    break;
                }
                case MJOLNIR_THROW: {
                    this.setAttackAnimation(event, "animation.thor.mjolnir_throw_attack", 30);
                }
            }
            return PlayState.CONTINUE;
        }
        if (this.getAttackingTicks() == 0) {
            if (event.isMoving()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.thor.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.thor.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> void setAttackAnimation(AnimationEvent<E> event, String animationName, int ticks) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation(animationName, (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        this.setAttackingTicks(ticks);
    }

    public void playAttackSound(ThorAttackState attackState) {
        SoundEvent soundEvent = null;
        switch (attackState) {
            case MELEE_ATTACK: {
                soundEvent = (SoundEvent)DRSounds.THOR_MELEE_ATTACK.get();
                break;
            }
            case LEG_ATTACK: {
                soundEvent = (SoundEvent)DRSounds.THOR_LEG_ATTACK.get();
                break;
            }
            case CLAP_ATTACK: {
                soundEvent = (SoundEvent)DRSounds.THOR_CLAP_ATTACK.get();
                break;
            }
            case GROUND_ATTACK: {
                soundEvent = (SoundEvent)DRSounds.THOR_GROUND_ATTACK.get();
                break;
            }
            case MJOLNIR_THROW: {
                soundEvent = (SoundEvent)DRSounds.THOR_MJOLNIR_THROW_ATTACK.get();
            }
        }
        if (soundEvent != null) {
            this.f_19853_.m_5594_(null, this.m_20097_(), soundEvent, SoundSource.HOSTILE, 1.0f, DraupnirSpear.RAND.nextFloat() * 0.1f + 0.95f);
        }
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected PathNavigation m_6037_(Level p_21480_) {
        return new FireIgnoringPathNavigation((Mob)this, this.f_19853_);
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_20145_() {
        if (!this.isSummoningComplete()) {
            return true;
        }
        return super.m_20145_();
    }

    public boolean m_20147_() {
        if (!this.isSummoningComplete()) {
            return true;
        }
        return super.m_20147_();
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (!this.isSummoningComplete()) {
            return false;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    public boolean m_5825_() {
        return true;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return null;
    }

    private void resetAmbientInterval() {
        this.ambientSoundInterval = -this.m_8100_();
    }

    public int m_8100_() {
        return 200;
    }

    public void m_6710_(@Nullable LivingEntity newTarget) {
        block3: {
            block2: {
                LivingEntity livingEntity = this.m_5448_();
                if (!(livingEntity instanceof Player)) break block2;
                Player player = (Player)livingEntity;
                if (newTarget == null && player.m_6084_() && !player.m_150110_().f_35937_) break block3;
            }
            super.m_6710_(newTarget);
        }
    }

    public float m_6100_() {
        return 1.0f;
    }
}

