/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.entities.entity;

import com.deriys.divinerelics.capabilities.mjolnir.MjolnirBindingProvider;
import com.deriys.divinerelics.capabilities.teammates.TeammatesProvider;
import com.deriys.divinerelics.config.DivineRelicsCommonConfig;
import com.deriys.divinerelics.entities.entity.ThorEntity;
import com.deriys.divinerelics.init.DREntitiyTypes;
import com.deriys.divinerelics.init.DRItems;
import com.deriys.divinerelics.init.DRSounds;
import com.deriys.divinerelics.items.HeimdallGauntlet;
import com.deriys.divinerelics.items.Motosignir;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownMjolnir
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> ID_FOIL;
    private static final EntityDataAccessor<Boolean> SHOULD_RETURN;
    private ItemStack mjolnirItem;
    private boolean dealtDamage;
    private boolean hit;
    public static final double STRIKE_DAMAGE;
    private static final int COOLDOWN;
    public static double STRIKE_RADIUS;
    public static double STRIKE_FORCE;
    public static double RETURNING_SPEED;
    public int clientSideReturnTridentTickCount;
    public boolean shouldReturn = false;
    public boolean relaxed = false;
    public DamageSource damageSource = DamageSource.m_19337_((Entity)this, (Entity)(this.m_37282_() == null ? this : this.m_37282_()));

    public ThrownMjolnir(EntityType<? extends ThrownMjolnir> entityType, Level level) {
        super(entityType, level);
        this.mjolnirItem = new ItemStack((ItemLike)DRItems.MJOLNIR.get());
    }

    public ThrownMjolnir(Level p_37569_, LivingEntity p_37570_, ItemStack p_37571_) {
        super((EntityType)DREntitiyTypes.THROWN_MJOLNIR.get(), p_37570_, p_37569_);
        this.mjolnirItem = new ItemStack((ItemLike)DRItems.MJOLNIR.get());
        this.mjolnirItem = p_37571_.m_41777_();
        this.f_19804_.m_135381_(ID_FOIL, (Object)p_37571_.m_41790_());
        this.f_19804_.m_135381_(SHOULD_RETURN, (Object)this.shouldReturn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
        this.f_19804_.m_135372_(SHOULD_RETURN, (Object)false);
    }

    public void m_8119_() {
        ThorEntity thor;
        Entity entity;
        if (!this.f_19853_.f_46443_ && (entity = this.m_37282_()) instanceof ThorEntity && !(thor = (ThorEntity)entity).m_6084_()) {
            this.m_146870_();
        }
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        if (!this.f_19853_.f_46443_ && this.isAcceptibleReturnOwner() && !this.isReturning() && this.m_20182_().m_82557_(this.m_37282_().m_20182_()) > 10000.0) {
            this.setReturning(true);
            this.relaxed = false;
        }
        if ((entity = this.m_37282_()) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            if (!(this.isAcceptibleReturnOwner() || this.f_19853_.f_46443_ || this.relaxed || this.f_36705_ != AbstractArrow.Pickup.ALLOWED)) {
                this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                this.relax();
            } else if (!this.f_19853_.f_46443_ && owner.m_6084_() && this.f_36705_ == AbstractArrow.Pickup.DISALLOWED) {
                this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            } else if (this.isReturning()) {
                this.relaxed = false;
                this.m_36790_(true);
                Vec3 vectorPM = owner.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vectorPM.f_82480_ * 0.015 * 4.0, this.m_20189_());
                if (this.f_19853_.f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double fact = 0.05 * RETURNING_SPEED;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vectorPM.m_82541_().m_82490_(fact)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.m_5496_((SoundEvent)DRSounds.MJOLNIR_RETURN.get(), 15.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.m_8119_();
    }

    public boolean isReturning() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_RETURN);
    }

    public void setReturning(boolean returning) {
        this.f_19804_.m_135381_(SHOULD_RETURN, (Object)returning);
    }

    private boolean isAcceptibleReturnOwner() {
        Entity $$0 = this.m_37282_();
        if ($$0 != null && $$0.m_6084_()) {
            return !($$0 instanceof ServerPlayer) || !$$0.m_5833_();
        }
        return false;
    }

    private void relax() {
        this.m_20242_(false);
        this.m_36790_(false);
        this.m_20256_(this.m_20184_().m_82542_(0.001, 0.01, 0.001));
        this.setReturning(false);
        this.hit = true;
        this.relaxed = true;
        this.clientSideReturnTridentTickCount = 0;
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    protected ItemStack m_7941_() {
        return this.mjolnirItem.m_41777_();
    }

    public boolean isFoil() {
        return false;
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 p_37575_, Vec3 p_37576_) {
        return super.m_6351_(p_37575_, p_37576_);
    }

    protected void m_5790_(EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        double damage = (Double)DivineRelicsCommonConfig.THROWN_MJOLNIR_DAMAGE.get();
        if (entity instanceof LivingEntity) {
            LivingEntity hitEntity = (LivingEntity)entity;
            damage += (double)EnchantmentHelper.m_44833_((ItemStack)this.mjolnirItem, (MobType)hitEntity.m_6336_());
        }
        Entity owner = this.m_37282_();
        float volume = 1.0f;
        this.dealtDamage = true;
        SoundEvent soundEvent = (SoundEvent)DRSounds.MJOLNIR_IMPACT.get();
        if (entity.m_6469_(this.damageSource, (float)damage)) {
            this.hit = true;
            Level level = this.f_19853_;
            BlockPos blockPos = entity.m_20183_();
            if (!level.f_46443_ && owner instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)owner;
                this.mjolnirHit(livingEntity, level, blockPos);
            }
            soundEvent = (SoundEvent)DRSounds.MJOLNIR_THUNDER.get();
            volume = 5.0f;
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntityHit = (LivingEntity)entity;
                if (owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntityHit, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingEntityHit);
                }
                this.m_7761_(livingEntityHit);
            }
        }
        this.m_5496_(soundEvent, volume, 1.0f);
    }

    public int m_150123_() {
        return 3;
    }

    public static BlockPos getRandBlockPos(BlockPos blockPos) {
        return new BlockPos((double)((float)blockPos.m_123341_() + HeimdallGauntlet.RAND.nextFloat() * 10.0f - 5.0f), (double)blockPos.m_123342_(), (double)((float)blockPos.m_123343_() + HeimdallGauntlet.RAND.nextFloat() * 10.0f - 5.0f));
    }

    public static BlockPos getRandBlockPos(BlockPos blockPos, int x, int z, int origin) {
        return new BlockPos(blockPos.m_123341_() + ThrownMjolnir.genRandSign(origin, x), blockPos.m_123342_(), blockPos.m_123343_() + ThrownMjolnir.genRandSign(origin, z));
    }

    public static int genRandSign(int origin, int bound) {
        if (HeimdallGauntlet.RAND.nextBoolean()) {
            return HeimdallGauntlet.RAND.nextInt(origin, bound);
        }
        return -HeimdallGauntlet.RAND.nextInt(origin, bound);
    }

    public static void spawnLightning(Level level, BlockPos blockPos, Entity owner) {
        LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
        lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)blockPos));
        lightningBolt.m_20879_(owner instanceof ServerPlayer ? (ServerPlayer)owner : null);
        level.m_7967_((Entity)lightningBolt);
    }

    public static void onHitLighnting(Level level, Entity hammer, BlockPos blockPos, LivingEntity owner, DamageSource damageSource, double damage, double force, double strikeRadius) {
        double hammerX = hammer.m_20185_();
        double hammerY = hammer.m_20186_();
        double hammerZ = hammer.m_20189_();
        List<LivingEntity> entitiesInArea = Motosignir.getEntitiesInArea(level, hammerX, hammerY, hammerZ, strikeRadius);
        Motosignir.hurtAndKnockbackEntites(entitiesInArea, owner, hammer, damageSource, damage, force);
        int lightningCount = 0;
        for (LivingEntity hitEntity : entitiesInArea) {
            if (hitEntity == owner || TeammatesProvider.hasTeammate(owner, hitEntity)) continue;
            ThrownMjolnir.spawnLightning(level, hitEntity.m_20097_(), (Entity)owner);
            ++lightningCount;
        }
        int maxLightnings = (Integer)DivineRelicsCommonConfig.THROWN_MJOLNIR_LIGHNTING_COUNT.get();
        if (lightningCount < maxLightnings) {
            for (int i = lightningCount; i < 4; ++i) {
                ThrownMjolnir.spawnLightning(level, ThrownMjolnir.getRandBlockPos(blockPos), (Entity)owner);
            }
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        BlockPos blockPos = blockHitResult.m_82425_();
        Vec3 prevMovement = this.m_20184_();
        Vec3 position = new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        Level level = this.f_19853_;
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)DRSounds.MJOLNIR_IMPACT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!level.f_46443_) {
            boolean isBedrock = level.m_8055_(blockPos).m_60734_() == Blocks.f_50752_;
            boolean isObsidian = level.m_8055_(blockPos).m_60734_() == Blocks.f_50080_;
            Entity owner = this.m_37282_();
            if (owner instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)owner;
                if (!this.hit && !isBedrock) {
                    if (isObsidian) {
                        level.m_46961_(blockPos, false);
                    }
                    this.mjolnirHit(livingEntity, level, blockPos);
                    level.m_7703_(null, this.damageSource, null, position.f_82479_, position.f_82480_, position.f_82481_, 2.0f, false, Explosion.BlockInteraction.DESTROY);
                    this.m_20256_(prevMovement.m_82490_((double)0.8f));
                } else {
                    this.m_20242_(false);
                    super.m_8060_(blockHitResult);
                    if (!this.hit) {
                        this.mjolnirHit(livingEntity, level, blockPos);
                    }
                }
            }
            this.hit = true;
        }
        this.m_36740_((SoundEvent)DRSounds.MJOLNIR_IMPACT.get());
    }

    private void mjolnirHit(LivingEntity owner, Level level, BlockPos blockPos) {
        ThrownMjolnir.spawnLightning(level, blockPos, (Entity)owner);
        ThrownMjolnir.onHitLighnting(level, (Entity)this, blockPos, owner, this.damageSource, STRIKE_DAMAGE, STRIKE_FORCE, STRIKE_RADIUS);
        if (owner instanceof Player) {
            Player player = (Player)owner;
            player.m_36335_().m_41524_(this.mjolnirItem.m_41720_(), COOLDOWN);
        }
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean isChanneling() {
        return EnchantmentHelper.m_44936_((ItemStack)this.mjolnirItem);
    }

    protected boolean m_142470_(Player player) {
        if (super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_())) {
            player.getCapability(MjolnirBindingProvider.MJOLNIR_BINDING).ifPresent(binding -> binding.removeMjolnir(this.m_20148_().toString()));
            return true;
        }
        return false;
    }

    public void shootMjolnirAtTarget(LivingEntity shooter, LivingEntity target) {
        Vec3 startPos = shooter.m_20182_().m_82520_(0.0, (double)(shooter.m_20192_() / 1.5f), 0.0);
        Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)(target.m_20192_() / 1.5f), 0.0);
        Vec3 direction = targetPos.m_82546_(startPos).m_82541_();
        this.m_6034_(startPos.f_82479_, startPos.f_82480_, startPos.f_82481_);
        this.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 3.8f, 0.0f);
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)DRSounds.MJOLNIR_IMPACT.get();
    }

    public void m_6123_(Player p_37580_) {
        if (this.m_150171_((Entity)p_37580_) || this.m_37282_() == null) {
            super.m_6123_(p_37580_);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Mjolnir", 10)) {
            this.mjolnirItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Mjolnir"));
        }
        this.dealtDamage = tag.m_128471_("DealtDamage");
        this.hit = tag.m_128471_("thisHit");
        this.setReturning(tag.m_128471_("Returning"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Mjolnir", (Tag)this.mjolnirItem.m_41739_(new CompoundTag()));
        tag.m_128379_("DealtDamage", this.dealtDamage);
        tag.m_128379_("thisHit", this.hit);
        tag.m_128379_("Returning", this.isReturning());
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }

    public static ThrownMjolnir create(EntityType<? extends ThrownMjolnir> type, Level level) {
        return new ThrownMjolnir(type, level);
    }

    public boolean hasHit() {
        return this.hit;
    }

    static {
        STRIKE_DAMAGE = (Double)DivineRelicsCommonConfig.THROWN_MJOLNIR_STRIKE_DAMAGE.get();
        COOLDOWN = (Integer)DivineRelicsCommonConfig.MJOLNIR_THROW_COOLDOWN.get();
        STRIKE_RADIUS = (Double)DivineRelicsCommonConfig.THROWN_MJOLNIR_STRIKE_RADIUS.get();
        STRIKE_FORCE = (Double)DivineRelicsCommonConfig.THROWN_MJOLNIR_STRIKE_FORCE.get();
        RETURNING_SPEED = (Double)DivineRelicsCommonConfig.THROWN_MJOLNIR_RETURNING_SPEED.get();
        ID_FOIL = SynchedEntityData.m_135353_(ThrownMjolnir.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        SHOULD_RETURN = SynchedEntityData.m_135353_(ThrownMjolnir.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }
}

