/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.event;

import com.deriys.divinerelics.capabilities.leviathan.LeviathanBinding;
import com.deriys.divinerelics.capabilities.leviathan.LeviathanBindingProvider;
import com.deriys.divinerelics.capabilities.mjolnir.MjolnirBinding;
import com.deriys.divinerelics.capabilities.mjolnir.MjolnirBindingProvider;
import com.deriys.divinerelics.capabilities.stuck_spears.StuckSpears;
import com.deriys.divinerelics.capabilities.stuck_spears.StuckSpearsProvider;
import com.deriys.divinerelics.capabilities.teammates.Teammates;
import com.deriys.divinerelics.capabilities.teammates.TeammatesProvider;
import com.deriys.divinerelics.capabilities.thor.FightsThor;
import com.deriys.divinerelics.capabilities.thor.FightsThorProvider;
import com.deriys.divinerelics.config.DivineRelicsCommonConfig;
import com.deriys.divinerelics.effects.BifrostProtection;
import com.deriys.divinerelics.entities.entity.BrokEntity;
import com.deriys.divinerelics.entities.entity.SindriEntity;
import com.deriys.divinerelics.entities.entity.ThorEntity;
import com.deriys.divinerelics.entities.entity.ThrownDraupnirSpear;
import com.deriys.divinerelics.entities.entity.ThrownLeviathanAxe;
import com.deriys.divinerelics.entities.entity.ThrownMjolnir;
import com.deriys.divinerelics.init.DRDwarfs;
import com.deriys.divinerelics.init.DREffects;
import com.deriys.divinerelics.init.DRItems;
import com.deriys.divinerelics.init.DRSounds;
import com.deriys.divinerelics.init.DRTags;
import com.deriys.divinerelics.items.DraupnirSpear;
import com.deriys.divinerelics.items.LeviathanAxe;
import com.deriys.divinerelics.items.Mjolnir;
import com.deriys.divinerelics.items.Motosignir;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class DREvents {

    @Mod.EventBusSubscriber(modid="divinerelics")
    public static class ForgeEvents {
        @SubscribeEvent
        public static void LivingAttackEvent(LivingAttackEvent event) {
            ItemStack itemStack;
            Item item;
            Player player;
            Entity directAttacker;
            Entity attacker;
            LivingEntity hurtEntity;
            block16: {
                Level level;
                LivingEntity livingEntity;
                block17: {
                    hurtEntity = event.getEntity();
                    DamageSource damageSource = event.getSource();
                    attacker = damageSource.m_7639_();
                    directAttacker = damageSource.m_7640_();
                    if (!(hurtEntity instanceof LivingEntity)) break block16;
                    livingEntity = hurtEntity;
                    level = livingEntity.m_9236_();
                    if (!livingEntity.m_21023_((MobEffect)DREffects.BIFROST_PROTECTION.get())) break block16;
                    if (!(livingEntity instanceof Player)) break block17;
                    Player player2 = (Player)livingEntity;
                    if (player2.m_150110_().f_35937_) break block16;
                }
                if (attacker != null && ForgeEvents.isValidAttacker(attacker, directAttacker) && !level.f_46443_) {
                    Vec3 entityPos = livingEntity.m_20182_();
                    Vec3 attackerPos = attacker.m_20182_();
                    Vec2 attackVector = new Vec2((float)(entityPos.f_82479_ - attackerPos.f_82479_), (float)(entityPos.f_82481_ - attackerPos.f_82481_));
                    ForgeEvents.dodgeAttack(level, livingEntity, attackVector);
                    if (!(attacker instanceof Player)) {
                        level.m_5594_(null, new BlockPos(entityPos), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    hurtEntity.m_7618_(EntityAnchorArgument.Anchor.EYES, attacker.m_146892_());
                    event.setCanceled(true);
                }
            }
            if (hurtEntity instanceof Player) {
                player = (Player)hurtEntity;
                if (attacker instanceof LivingEntity) {
                    int ticksInUse;
                    LivingEntity livingAttacker = (LivingEntity)attacker;
                    if (player.m_21254_() && player.m_21206_().m_41720_() == DRItems.GUARDIAN_SHIELD.get() && (ticksInUse = player.m_21252_()) <= (Integer)DivineRelicsCommonConfig.GUARDIAN_SHIELD_PARRY_WINDOW.get()) {
                        float amount = event.getAmount();
                        float damage = amount < 3.0f ? 2.0f : amount * 0.8f;
                        player.m_9236_().m_5594_(null, player.m_20097_(), (SoundEvent)DRSounds.GUARDIAN_SHIELD_PARRY.get(), SoundSource.PLAYERS, 1.0f, DraupnirSpear.RAND.nextFloat() * 0.1f + 0.95f);
                        Motosignir.hurtAndKnockbackEntites(List.of(livingAttacker), player, Motosignir.STUN_EFFECTS, damage, Math.min(Math.log10(damage) / 2.5, 1.5), 1, 100);
                    }
                }
            }
            if (hurtEntity != null && attacker instanceof Player && (item = (itemStack = (player = (Player)attacker).m_21205_()).m_41720_()) instanceof Mjolnir) {
                Mjolnir mjolnir = (Mjolnir)item;
                if (!player.m_9236_().f_46443_ && mjolnir.isRiptideFlying(itemStack)) {
                    if (!TeammatesProvider.hasTeammate((LivingEntity)player, hurtEntity)) {
                        player.m_36335_().m_41524_((Item)mjolnir, 40);
                    } else {
                        event.setCanceled(true);
                    }
                }
            }
            if (hurtEntity instanceof LivingEntity) {
                LivingEntity owner;
                ThrownMjolnir thrownMjolnir;
                LivingEntity livingEntityHurt = hurtEntity;
                if (directAttacker instanceof ThrownMjolnir && (item = (thrownMjolnir = (ThrownMjolnir)directAttacker).m_37282_()) instanceof LivingEntity && (owner = (LivingEntity)item) == livingEntityHurt) {
                    event.setCanceled(true);
                }
            }
            if (hurtEntity instanceof LivingEntity) {
                Player attackerPlayer;
                LivingEntity hurtPlayer = hurtEntity;
                if (attacker instanceof Player && TeammatesProvider.hasTeammate((LivingEntity)(attackerPlayer = (Player)attacker), hurtPlayer) && ForgeEvents.isDRWeapon(directAttacker)) {
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onShieldBlock(ShieldBlockEvent event) {
            LivingEntity entity = event.getEntity();
            Entity attacker = event.getDamageSource().m_7640_();
            if ((attacker instanceof ThrownMjolnir || attacker instanceof ThrownDraupnirSpear) && entity.m_21206_().m_41720_() != DRItems.GUARDIAN_SHIELD.get()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onPlayerFall(LivingFallEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                ItemStack itemStack = player.m_21205_();
                Level level = player.m_9236_();
                if (!level.f_46443_) {
                    Item item = itemStack.m_41720_();
                    if (item instanceof Mjolnir) {
                        Mjolnir mjolnir = (Mjolnir)item;
                        if (mjolnir.isRiptideFlying(itemStack)) {
                            ForgeEvents.handleMjolnirAction(player, mjolnir, itemStack, event);
                        }
                        mjolnir.setRiptideFlying(itemStack, false);
                    } else if (player.m_21211_().m_150930_((Item)DRItems.GUARDIAN_SHIELD.get()) && player.m_20154_().f_82480_ < -0.85) {
                        ForgeEvents.handleGuardianShieldAction(player, event);
                    }
                }
            }
        }

        private static void handleGuardianShieldAction(Player player, LivingFallEvent event) {
            if (player.m_21209_()) {
                player.m_204079_(1);
            }
            event.setCanceled(true);
        }

        private static void handleMjolnirAction(Player player, Mjolnir mjolnir, ItemStack itemStack, LivingFallEvent event) {
            if (event.getDistance() > 20.0f) {
                ForgeEvents.applyMjolnirEffects(player, mjolnir, itemStack, event);
            }
            if (player.m_21209_()) {
                player.m_204079_(1);
            }
            event.setCanceled(true);
        }

        private static void applyMjolnirEffects(Player player, Mjolnir mjolnir, ItemStack itemStack, LivingFallEvent event) {
            double velocity = ForgeEvents.getVelocity(player);
            float damage = (float)Math.min(Math.max(10.0, 5.0 * velocity), 40.0);
            float force = (float)(1.0 + velocity / (velocity + 0.5));
            DamageSource damageSource = DamageSource.m_19337_((Entity)new ThrownMjolnir(player.m_9236_(), (LivingEntity)player, itemStack), (Entity)player);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 80, 2));
            ThrownMjolnir.onHitLighnting(event.getEntity().m_9236_(), (Entity)player, player.m_20097_(), (LivingEntity)player, damageSource, damage, force, 5.0);
            player.m_36335_().m_41524_((Item)mjolnir, 70);
        }

        @SubscribeEvent
        public static void onLightningStrike(EntityStruckByLightningEvent event) {
            ItemEntity itemEntity;
            ServerPlayer cause = event.getLightning().m_147158_();
            Entity entity = event.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity hitEntity = (LivingEntity)entity;
                if (cause != null && (cause == hitEntity || TeammatesProvider.hasTeammate((LivingEntity)cause, hitEntity)) || entity instanceof ThorEntity || hitEntity.m_21254_()) {
                    event.setCanceled(true);
                }
            }
            if (entity instanceof ItemEntity && (itemEntity = (ItemEntity)entity).m_32055_().m_204117_(DRTags.Items.CANT_BE_DESTROYED_BY_LIGHTNING)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            LivingEntity livingEntity;
            Object object = event.getObject();
            if (object instanceof LivingEntity && !(livingEntity = (LivingEntity)object).getCapability(StuckSpearsProvider.STUCK_SPEARS).isPresent()) {
                event.addCapability(new ResourceLocation("divinerelics", "stuck_spears"), (ICapabilityProvider)new StuckSpearsProvider());
            }
            if ((object = event.getObject()) instanceof Player) {
                Player player = (Player)object;
                if (!player.getCapability(MjolnirBindingProvider.MJOLNIR_BINDING).isPresent()) {
                    event.addCapability(new ResourceLocation("divinerelics", "mjolnirbinding"), (ICapabilityProvider)new MjolnirBindingProvider());
                }
                if (!player.getCapability(TeammatesProvider.TEAMMATES).isPresent()) {
                    event.addCapability(new ResourceLocation("divinerelics", "drteammates"), (ICapabilityProvider)new TeammatesProvider());
                }
                if (!player.getCapability(LeviathanBindingProvider.LEVIATHAN_BINDING).isPresent()) {
                    event.addCapability(new ResourceLocation("divinerelics", "leviathanbinding"), (ICapabilityProvider)new LeviathanBindingProvider());
                }
                if (!player.getCapability(FightsThorProvider.FIGHTS_THOR).isPresent()) {
                    event.addCapability(new ResourceLocation("divinerelics", "fightsthor"), (ICapabilityProvider)new FightsThorProvider());
                }
            }
        }

        @SubscribeEvent
        public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
            event.register(MjolnirBinding.class);
            event.register(Teammates.class);
            event.register(LeviathanBinding.class);
            event.register(StuckSpears.class);
            event.register(FightsThor.class);
        }

        @SubscribeEvent
        public static void onPlayerCloned(PlayerEvent.Clone event) {
            Player original = event.getOriginal();
            Player player = event.getEntity();
            if (event.isWasDeath()) {
                original.revive();
                original.getCapability(MjolnirBindingProvider.MJOLNIR_BINDING).ifPresent(oldStore -> event.getEntity().getCapability(MjolnirBindingProvider.MJOLNIR_BINDING).ifPresent(newStore -> newStore.copyFrom((MjolnirBinding)oldStore)));
                original.getCapability(TeammatesProvider.TEAMMATES).ifPresent(oldStore -> event.getEntity().getCapability(TeammatesProvider.TEAMMATES).ifPresent(newStore -> newStore.copyFrom((Teammates)oldStore)));
                original.getCapability(LeviathanBindingProvider.LEVIATHAN_BINDING).ifPresent(oldStore -> event.getEntity().getCapability(LeviathanBindingProvider.LEVIATHAN_BINDING).ifPresent(newStore -> newStore.copyFrom((LeviathanBinding)oldStore)));
                original.getCapability(FightsThorProvider.FIGHTS_THOR).ifPresent(oldStore -> event.getEntity().getCapability(FightsThorProvider.FIGHTS_THOR).ifPresent(newStore -> newStore.copyFrom((FightsThor)oldStore)));
            }
            Objects.requireNonNull(player.m_20194_()).execute(() -> {
                CompoundTag deathPositionTag = original.getPersistentData().m_128469_("DRdeathPosition");
                double deathX = deathPositionTag.m_128459_("x");
                double deathY = deathPositionTag.m_128459_("y");
                double deathZ = deathPositionTag.m_128459_("z");
                BlockPos deathPos = new BlockPos(deathX, deathY, deathZ);
                double distanceSqr = player.m_20182_().m_82531_((double)deathPos.m_123341_(), (double)deathPos.m_123342_(), (double)deathPos.m_123343_());
                if (distanceSqr > 70000.0) {
                    ThorEntity.stopSoundForPlayer((ServerPlayer)player, (SoundEvent)DRSounds.THOR_FIGHT_MUSIC.get(), SoundSource.RECORDS);
                    ThorEntity.stopSoundForPlayer((ServerPlayer)player, (SoundEvent)DRSounds.THOR_FIGHT_MUSIC_LOOP.get(), SoundSource.RECORDS);
                    ForgeEvents.setLoggedOutCap(player);
                }
            });
        }

        @SubscribeEvent
        public static void onPlayerDeath(LivingDeathEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                CompoundTag deathPositionTag = new CompoundTag();
                deathPositionTag.m_128347_("x", player.m_20185_());
                deathPositionTag.m_128347_("y", player.m_20186_());
                deathPositionTag.m_128347_("z", player.m_20189_());
                player.getPersistentData().m_128365_("DRdeathPosition", (Tag)deathPositionTag);
            }
        }

        @SubscribeEvent
        public static void onItemPickup(EntityItemPickupEvent event) {
            ItemStack itemStack = event.getItem().m_32055_();
            Item item = itemStack.m_41720_();
            String owner = ForgeEvents.getOwner(itemStack);
            Player player = event.getEntity();
            if (ForgeEvents.isValidBindingItem(item) && owner.isEmpty()) {
                ForgeEvents.bindItemToEntity((Entity)player, itemStack);
            } else if (!owner.isEmpty() && !owner.equals(player.m_20148_().toString())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof ThorEntity) {
                ThorEntity thor = (ThorEntity)entity;
                if (!thor.f_19853_.f_46443_ && !thor.isSummoningComplete()) {
                    thor.m_21557_(true);
                    Level level = thor.f_19853_;
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8606_(0, 60000, true, true);
                    thor.startPlayingBossMusic();
                }
            }
            if (entity instanceof ZombieVillager) {
                ZombieVillager zombieVillager = (ZombieVillager)entity;
                ForgeEvents.stopSpawningEvent(zombieVillager.m_7141_(), event);
            } else if (!(entity instanceof BrokEntity) && !(entity instanceof SindriEntity) && entity instanceof Villager) {
                Villager villager = (Villager)entity;
                ForgeEvents.stopSpawningEvent(villager.m_7141_(), event);
            }
        }

        private static void stopSpawningEvent(VillagerData villagerData, EntityJoinLevelEvent event) {
            VillagerProfession profession = villagerData.m_35571_();
            if (profession == DRDwarfs.BROK.get() || profession == DRDwarfs.SINDRI.get()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
            Player player = event.getEntity();
            Level level = player.m_9236_();
            if (!level.f_46443_) {
                ForgeEvents.setLoggedOutCap(player);
            }
        }

        private static void setLoggedOutCap(Player player) {
            player.getCapability(FightsThorProvider.FIGHTS_THOR).ifPresent(fightsThorCap -> {
                if (!fightsThorCap.getThorList().isEmpty()) {
                    fightsThorCap.setHasLoggedOut(true);
                }
            });
        }

        public static boolean isValidBindingItem(Item item) {
            return item instanceof Mjolnir || item instanceof DraupnirSpear || item instanceof LeviathanAxe;
        }

        public static void bindItemToEntity(Entity entity, ItemStack itemStack) {
            CompoundTag nbt = itemStack.m_41784_();
            nbt.m_128359_("OwnerUUID", entity.m_20148_().toString());
            nbt.m_128359_("OwnerNickname", entity.m_5446_().getString());
        }

        public static String getOwner(ItemStack itemStack) {
            if (itemStack != null) {
                CompoundTag nbt = itemStack.m_41784_();
                return nbt.m_128461_("OwnerUUID");
            }
            return "";
        }

        public static double getVelocity(Player player) {
            double deltaX = player.m_20185_() - player.f_19790_;
            double deltaY = player.m_20186_() - player.f_19791_;
            double deltaZ = player.m_20189_() - player.f_19792_;
            return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        }

        private static boolean isValidAttacker(Entity attacker, Entity directAttacker) {
            LivingEntity livingEntity;
            return !(directAttacker instanceof ThrownDraupnirSpear) && attacker instanceof LivingEntity && ((livingEntity = (LivingEntity)attacker).m_21205_().m_41720_() != DRItems.DRAUPNIR_SPEAR.get() || directAttacker != attacker) && !(livingEntity instanceof ThorEntity);
        }

        public static boolean isDRWeapon(Entity directAttacker) {
            return directAttacker instanceof ThrownMjolnir || directAttacker instanceof ThrownDraupnirSpear || directAttacker instanceof ThrownLeviathanAxe;
        }

        public static void dodgeAttack(Level level, LivingEntity hurtEntity, Vec2 attackVector) {
            Vec3 entityPos = hurtEntity.m_20182_();
            double entityX = hurtEntity.m_20185_();
            double entityY = hurtEntity.m_20186_();
            double entityZ = hurtEntity.m_20189_();
            if (hurtEntity.m_20159_()) {
                hurtEntity.m_8127_();
            }
            Vec2 attackVNorm = BifrostProtection.findNormVec(attackVector);
            double scale = (double)new Random().nextFloat() * 1.5 + 0.5;
            Vec3 tpVector = BifrostProtection.getTPVector(level, attackVNorm, entityPos, scale);
            hurtEntity.m_6021_(tpVector.f_82479_, tpVector.f_82480_, tpVector.f_82481_);
        }
    }
}

