/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.items;

import com.deriys.divinerelics.capabilities.stuck_spears.StuckSpearsProvider;
import com.deriys.divinerelics.config.DivineRelicsCommonConfig;
import com.deriys.divinerelics.core.networking.DRMessages;
import com.deriys.divinerelics.core.networking.packets.SpearExplosionParticleS2CPacket;
import com.deriys.divinerelics.core.networking.packets.StuckSpearsS2CPacket;
import com.deriys.divinerelics.effects.BifrostProtection;
import com.deriys.divinerelics.entities.entity.ThrownDraupnirSpear;
import com.deriys.divinerelics.event.DREvents;
import com.deriys.divinerelics.init.DRSounds;
import com.deriys.divinerelics.items.Motosignir;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DraupnirSpear
extends SwordItem {
    public static final int THROW_THRESHOLD_TIME = (Integer)DivineRelicsCommonConfig.DRAUPNIR_SPEAR_THROW_THRESHOLD.get();
    public static final double BASE_DAMAGE = (Double)DivineRelicsCommonConfig.DRAUPNIR_SPEAR_DAMAGE.get();
    public static final double BASE_ATTACK_SPEED = (Double)DivineRelicsCommonConfig.DRAUPNIR_SPEAR_ATTACK_SPEED.get();
    public static final double SHOOT_POWER = (Double)DivineRelicsCommonConfig.DRAUPNIR_SPEAR_SHOOT_POWER.get();
    public static final Random RAND = new Random();
    private static final int DELAY_TICKS_THRESHOLD = 1;
    private static final double EXPLOSION_RADIUS = (Double)DivineRelicsCommonConfig.DRAUPNIR_SPEAR_EXPLOSION_RADIUS.get();
    private static final double EXPLOSION_DAMAGE = (Double)DivineRelicsCommonConfig.DRAUPNIR_SPEAR_EXPLOSION_DAMAGE.get();
    private static final int THROWN_SPEARS_THRESHOLD = (Integer)DivineRelicsCommonConfig.DRAUPNIR_SPEARS_COUNT.get();
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public DraupnirSpear(Tier p_40521_, int p_40522_, float p_40523_, Item.Properties p_40524_) {
        super(p_40521_, p_40522_, p_40523_, p_40524_);
        ImmutableMultimap.Builder $$1 = ImmutableMultimap.builder();
        $$1.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", BASE_DAMAGE, AttributeModifier.Operation.ADDITION));
        $$1.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", BASE_ATTACK_SPEED, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = $$1.build();
    }

    public static float getRandomPitch() {
        return RAND.nextFloat() * 0.1f + 0.95f;
    }

    public boolean m_6777_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return !player.m_7500_();
    }

    public UseAnim m_6164_(ItemStack p_43417_) {
        return UseAnim.SPEAR;
    }

    public int getThrownCount(ItemStack stack) {
        return stack.m_41784_().m_128451_("ThrownCount");
    }

    public void setThrownCount(ItemStack stack, int count) {
        stack.m_41784_().m_128405_("ThrownCount", count);
    }

    public int getDelayTicks(ItemStack stack) {
        return stack.m_41784_().m_128451_("DelayTicks");
    }

    public void setDelayTicks(ItemStack stack, int count) {
        stack.m_41784_().m_128405_("DelayTicks", count);
    }

    public boolean getExplosionState(ItemStack stack) {
        return stack.m_41784_().m_128471_("ExplosionState");
    }

    public void setExplosionState(ItemStack stack, boolean state) {
        stack.m_41784_().m_128379_("ExplosionState", state);
    }

    public void addThrownSpear(ItemStack stack, UUID uuid) {
        CompoundTag tag = stack.m_41784_();
        ListTag spearsTag = tag.m_128437_("ThrownSpears", 8);
        spearsTag.add((Object)StringTag.m_129297_((String)uuid.toString()));
        tag.m_128365_("ThrownSpears", (Tag)spearsTag);
    }

    public void setThrownSpears(ItemStack stack, List<UUID> list) {
        CompoundTag tag = stack.m_41784_();
        ListTag spearsTag = new ListTag();
        for (UUID uuid : list) {
            spearsTag.add((Object)StringTag.m_129297_((String)uuid.toString()));
        }
        tag.m_128365_("ThrownSpears", (Tag)spearsTag);
    }

    public List<UUID> getThrownSpears(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        ListTag spearsTag = tag.m_128437_("ThrownSpears", 8);
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (int i = 0; i < spearsTag.size(); ++i) {
            uuids.add(UUID.fromString(spearsTag.m_128778_(i)));
        }
        return uuids;
    }

    public void resetNBT(ItemStack itemStack) {
        this.setDelayTicks(itemStack, 0);
        this.setThrownCount(itemStack, 0);
        this.setExplosionState(itemStack, false);
    }

    public void clearThrownSpears(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("ThrownSpears", (Tag)new ListTag());
    }

    public boolean isNBTReset(ItemStack stack) {
        return !this.getExplosionState(stack) && this.getThrownCount(stack) == 0 && this.getDelayTicks(stack) == 0 && this.getThrownSpears(stack).isEmpty();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        int thrownCount = this.getThrownCount(itemStack);
        int delayTicks = this.getDelayTicks(itemStack);
        boolean isShiftDown = player.m_6144_();
        if (thrownCount < THROWN_SPEARS_THRESHOLD && delayTicks == 0 && !isShiftDown) {
            player.m_6672_(interactionHand);
            if (thrownCount == THROWN_SPEARS_THRESHOLD - 1) {
                this.setDelayTicks(itemStack, 15);
            }
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (delayTicks == 0 || isShiftDown) {
            BlockPos playerOnPos = player.m_20097_();
            level.m_5594_(null, playerOnPos, (SoundEvent)DRSounds.DRAUPNIR_SPEAR_EXPLOSION_HIT.get(), SoundSource.PLAYERS, 2.0f, DraupnirSpear.getRandomPitch());
            this.setDelayTicks(itemStack, 10);
            this.setExplosionState(itemStack, true);
            if (!level.f_46443_) {
                Vec2 normVec = BifrostProtection.findNormVec(player.m_20154_());
                DraupnirSpear.sendExplosionPacket(level, player.m_20185_() + (double)normVec.f_82470_ * 0.7, player.m_20186_() - 1.0, player.m_20189_() + (double)normVec.f_82471_ * 0.7, 2.0, 0.0, 25);
            }
            player.m_36335_().m_41524_((Item)this, 40 * (thrownCount + 1));
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public static void sendExplosionPacket(Level level, double x, double y, double z, double factor, double yRandom, int quantity) {
        SpearExplosionParticleS2CPacket packet = new SpearExplosionParticleS2CPacket(x, y, z, factor, yRandom, quantity);
        DRMessages.sendToChunk(packet, level.m_46745_(new BlockPos(x, y, z)));
    }

    public int m_8105_(ItemStack p_43419_) {
        return 36000;
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int p_41407_, boolean p_41408_) {
        if (DREvents.ForgeEvents.getOwner(itemStack).isEmpty()) {
            DREvents.ForgeEvents.bindItemToEntity(entity, itemStack);
        }
        int delayTicks = this.getDelayTicks(itemStack);
        List<UUID> thrownSpears = this.getThrownSpears(itemStack);
        if (thrownSpears.isEmpty() && !this.isNBTReset(itemStack)) {
            this.resetNBT(itemStack);
        }
        if (delayTicks > 1) {
            this.setDelayTicks(itemStack, --delayTicks);
        } else if (delayTicks == 1 && this.getExplosionState(itemStack)) {
            UUID uuid = thrownSpears.get(0);
            if (!level.f_46443_) {
                ServerLevel serverLevel = (ServerLevel)level;
                Entity entityUUID = serverLevel.m_8791_(uuid);
                if (this.isValidSpear(entityUUID) && entity instanceof Player) {
                    Player player = (Player)entity;
                    this.destroySpear(level, entityUUID, player, DamageSource.m_19337_((Entity)new ThrownDraupnirSpear(level, (LivingEntity)player, itemStack), (Entity)player));
                }
                thrownSpears.remove(0);
                this.setThrownSpears(itemStack, thrownSpears);
                if (entityUUID != null) {
                    if (entityUUID instanceof ThrownDraupnirSpear) {
                        entityUUID.m_146870_();
                    } else {
                        entityUUID.getCapability(StuckSpearsProvider.STUCK_SPEARS).ifPresent(stuckSpears -> {
                            stuckSpears.removeSpear();
                            DRMessages.sendToAllPlayers(new StuckSpearsS2CPacket(entityUUID.m_19879_(), stuckSpears.getSpears()));
                        });
                        entityUUID.f_19802_ = 1;
                    }
                    this.setDelayTicks(itemStack, RAND.nextInt(2, 6));
                }
            }
        } else if (delayTicks == 1 && !this.getExplosionState(itemStack)) {
            this.setDelayTicks(itemStack, --delayTicks);
        }
        super.m_6883_(itemStack, level, entity, p_41407_, p_41408_);
    }

    private boolean isValidSpear(Entity entity) {
        return entity instanceof ThrownDraupnirSpear || entity instanceof LivingEntity;
    }

    private void destroySpear(Level level, Entity spear, Player player, DamageSource damageSource) {
        double spearX = spear.m_20185_();
        double spearY = spear.m_20186_();
        double spearZ = spear.m_20189_();
        List<LivingEntity> entitiesInArea = Motosignir.getEntitiesInArea(level, spearX, spearY, spearZ, EXPLOSION_RADIUS);
        Motosignir.hurtAndKnockbackEntites(entitiesInArea, (LivingEntity)player, spear, damageSource, EXPLOSION_DAMAGE, 0.2f);
        level.m_5594_(null, spear.m_20097_(), (SoundEvent)DRSounds.DRAUPNIR_SPEAR_EXPLOSION.get(), SoundSource.PLAYERS, 2.0f, DraupnirSpear.getRandomPitch());
        DraupnirSpear.sendExplosionPacket(level, spearX, spearY, spearZ, 1.5, 0.0, 20);
    }

    public static void spawnSpearExplosionParticles(Level level, double x, double y, double z, double factor, double yRandom, int quantity) {
        BlockParticleOption particleOption = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50719_.m_49966_());
        for (int i = 0; i < quantity; ++i) {
            level.m_7106_((ParticleOptions)particleOption, x + (Math.random() - 0.5) * factor, y + (Math.random() - yRandom) * factor, z + (Math.random() - 0.5) * factor, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123797_, x + (Math.random() - 0.5) * factor, y + (Math.random() - yRandom) * factor, z + (Math.random() - 0.5) * factor, 0.0, 0.0, 0.0);
        }
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity livingEntity, int timeLeft) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int i = this.m_8105_(itemStack) - timeLeft;
            if (i >= THROW_THRESHOLD_TIME && !level.f_46443_) {
                int thrownCount = this.getThrownCount(itemStack);
                ThrownDraupnirSpear thrownSpear = new ThrownDraupnirSpear(level, (LivingEntity)player, itemStack);
                thrownSpear.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, (float)SHOOT_POWER, 1.0f);
                thrownSpear.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                thrownSpear.setThrowerPos(player.m_20182_());
                this.addThrownSpear(itemStack, thrownSpear.m_20148_());
                this.setThrownCount(itemStack, ++thrownCount);
                level.m_7967_((Entity)thrownSpear);
                level.m_6269_(null, (Entity)thrownSpear, (SoundEvent)DRSounds.DRAUPNIR_SPEAR_THROWING.get(), SoundSource.PLAYERS, 1.0f, DraupnirSpear.getRandomPitch());
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!slotChanged && oldStack.m_41720_() == newStack.m_41720_()) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        Vec3 lookVec = player.m_20154_();
        double length = entity.m_20182_().m_82546_(player.m_20182_()).m_82553_();
        double distanceModification = length > 3.0 ? 1.0 : length / 3.5;
        double speed = (double)0.7f * distanceModification;
        player.m_9236_().m_5594_(null, player.m_20097_(), (SoundEvent)DRSounds.DRAUPNIR_SPEAR_HIT.get(), SoundSource.PLAYERS, 1.0f, DraupnirSpear.getRandomPitch());
        player.m_20256_(new Vec3(lookVec.f_82479_ * speed, 0.0, lookVec.f_82481_ * speed));
        entity.f_19802_ = 9;
        return false;
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity p_43391_, LivingEntity attacker) {
        return true;
    }

    public boolean m_6813_(ItemStack itemStack, Level level, BlockState blockState, BlockPos blockPos, LivingEntity livingEntity) {
        if ((double)blockState.m_60800_((BlockGetter)level, blockPos) != 0.0) {
            itemStack.m_41622_(2, livingEntity, p_43385_ -> p_43385_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }

    public int m_6473_() {
        return 1;
    }

    public boolean m_5812_(ItemStack p_41453_) {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            components.add((Component)Component.m_237113_((String)"May this weapon strike true; may it be wielded with wisdom; may it be put down when its job is done."));
        } else {
            components.add((Component)Component.m_237113_((String)"Press SHIFT for more info").m_130940_(ChatFormatting.YELLOW));
            String ownerName = stack.m_41784_().m_128461_("OwnerNickname");
            if (!ownerName.isEmpty()) {
                components.add((Component)Component.m_237113_((String)""));
                components.add((Component)Component.m_237113_((String)("Loyal to: " + ownerName)));
            }
        }
    }
}

