/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.more_density_functions.density_function_types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;

public record Power(DensityFunction base, DensityFunction exponent, Optional<Double> maxOutput, Optional<Double> minOutput, Optional<DensityFunction> errorDf) implements DensityFunction
{
    private static final MapCodec<Power> DATA_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.f_208218_.fieldOf("base").forGetter(Power::base), (App)DensityFunction.f_208218_.fieldOf("exponent").forGetter(Power::exponent), (App)Codec.DOUBLE.optionalFieldOf("max_output").forGetter(Power::maxOutput), (App)Codec.DOUBLE.optionalFieldOf("min_output").forGetter(Power::minOutput), (App)DensityFunction.f_208218_.optionalFieldOf("error_output").forGetter(Power::errorDf)).apply((Applicative)instance, Power::new));
    public static final KeyDispatchDataCodec<Power> CODEC = KeyDispatchDataCodec.m_216238_(DATA_CODEC);

    public double m_207386_(@NotNull DensityFunction.FunctionContext pContext) {
        int exponentValue;
        int baseValue = (int)this.base.m_207386_(pContext);
        double result = Math.pow(baseValue, exponentValue = (int)this.exponent.m_207386_(pContext));
        if (Double.isNaN(result) || Double.isInfinite(result)) {
            if (this.errorDf.isPresent()) {
                return this.errorDf.get().m_207386_(pContext);
            }
            return 0.0;
        }
        if (result > this.maxOutput.orElse(1.0)) {
            return this.maxOutput.orElse(1.0);
        }
        if (result < this.minOutput.orElse(-1.0)) {
            return this.minOutput.orElse(-1.0);
        }
        return result;
    }

    public void m_207362_(double @NotNull [] pArray, DensityFunction.ContextProvider pContextProvider) {
        pContextProvider.m_207207_(pArray, (DensityFunction)this);
    }

    @NotNull
    public DensityFunction m_207456_(DensityFunction.Visitor pVisitor) {
        return pVisitor.m_214017_((DensityFunction)new Power(this.base, this.exponent, this.maxOutput, this.minOutput, this.errorDf));
    }

    public double m_207402_() {
        if (this.errorDf.isPresent()) {
            return Math.min(this.errorDf.get().m_207402_(), this.minOutput.orElse(-1.0));
        }
        return Math.min(0.0, this.minOutput.orElse(-1.0));
    }

    public double m_207401_() {
        if (this.errorDf.isPresent()) {
            return Math.max(this.errorDf.get().m_207401_(), this.maxOutput.orElse(1.0));
        }
        return Math.max(0.0, this.maxOutput.orElse(1.0));
    }

    @NotNull
    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC;
    }
}

