/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.more_density_functions.density_function_types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;

public record Reciprocal(DensityFunction df, Optional<Double> maxOutput, Optional<Double> minOutput, Optional<DensityFunction> errorDf) implements DensityFunction
{
    private static final MapCodec<Reciprocal> DATA_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.f_208218_.fieldOf("input").forGetter(Reciprocal::df), (App)Codec.DOUBLE.optionalFieldOf("max_output").forGetter(Reciprocal::maxOutput), (App)Codec.DOUBLE.optionalFieldOf("min_output").forGetter(Reciprocal::minOutput), (App)DensityFunction.f_208218_.optionalFieldOf("error_output").forGetter(Reciprocal::errorDf)).apply((Applicative)instance, Reciprocal::new));
    public static final KeyDispatchDataCodec<Reciprocal> CODEC = KeyDispatchDataCodec.m_216238_(DATA_CODEC);

    public double m_207386_(@NotNull DensityFunction.FunctionContext pContext) {
        double value = this.df.m_207386_(pContext);
        if (value == 0.0) {
            if (this.errorDf.isPresent()) {
                return this.errorDf.get().m_207386_(pContext);
            }
            return 0.0;
        }
        double result = 1.0 / value;
        if (result > this.maxOutput.orElse(1.0)) {
            return this.maxOutput.orElse(1.0);
        }
        if (result < this.minOutput.orElse(-1.0)) {
            return this.minOutput.orElse(-1.0);
        }
        return result;
    }

    public void m_207362_(double @NotNull [] pArray, DensityFunction.ContextProvider pContextProvider) {
        pContextProvider.m_207207_(pArray, (DensityFunction)this);
    }

    @NotNull
    public DensityFunction m_207456_(DensityFunction.Visitor pVisitor) {
        return pVisitor.m_214017_((DensityFunction)new Reciprocal(this.df, this.maxOutput, this.minOutput, this.errorDf));
    }

    public double m_207402_() {
        if (this.errorDf.isPresent()) {
            return Math.min(this.errorDf.get().m_207402_(), this.minOutput.orElse(-1.0));
        }
        return Math.min(0.0, this.minOutput.orElse(-1.0));
    }

    public double m_207401_() {
        if (this.errorDf.isPresent()) {
            return Math.max(this.errorDf.get().m_207401_(), this.maxOutput.orElse(1.0));
        }
        return Math.max(0.0, this.maxOutput.orElse(1.0));
    }

    @NotNull
    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC;
    }
}

