/*
 * Decompiled with CFR 0.152.
 */
package com.raphiiwarren.waterfreefarming.blocks;

import com.raphiiwarren.waterfreefarming.blocks.AbstractFarmElement;
import com.raphiiwarren.waterfreefarming.tileentity.ControllerDirtTileEntity;
import com.raphiiwarren.waterfreefarming.tileentity.FarmelementTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractController
extends BlockContainer {
    public AbstractController(Material material) {
        super(material);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing, IPlantable plantable) {
        return this.canControllerSustainPlant(state, world, pos, facing, plantable);
    }

    public abstract boolean canControllerSustainPlant(IBlockState var1, IBlockAccess var2, BlockPos var3, EnumFacing var4, IPlantable var5);

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.controllerTick(state, worldIn, pos, rand);
        for (EnumFacing direction : EnumFacing.Plane.HORIZONTAL) {
            if (!(worldIn.func_180495_p(pos.func_177972_a(direction)).func_177230_c() instanceof AbstractFarmElement)) continue;
            IBlockState farmElementState = worldIn.func_180495_p(pos.func_177972_a(direction));
            AbstractFarmElement farmElement = (AbstractFarmElement)farmElementState.func_177230_c();
            TileEntity farmElementTileEntity = worldIn.func_175625_s(pos.func_177972_a(direction));
            if (((FarmelementTileEntity)farmElementTileEntity).isActive()) continue;
            farmElement.activateFarmElement(worldIn, pos.func_177972_a(direction));
        }
    }

    public abstract void controllerTick(IBlockState var1, World var2, BlockPos var3, Random var4);

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            this.interactWith(worldIn, pos, playerIn);
        }
        return true;
    }

    protected abstract void interactWith(World var1, BlockPos var2, EntityPlayer var3);

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new ControllerDirtTileEntity();
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new ControllerDirtTileEntity();
    }

    public TileEntity getTileEntity(World world, BlockPos pos) {
        return world.func_175625_s(pos);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 1.0 + rand.nextDouble() * 4.0 / 10.0;
        double d2 = (double)pos.func_177952_p() + 0.5;
        double d4 = rand.nextDouble() * 0.6 - 0.3;
        if (rand.nextDouble() < 0.1) {
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0 + d4, d1 + d4, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof ControllerDirtTileEntity) {
            ((ControllerDirtTileEntity)tileentity).func_190575_a(stack.func_82833_r());
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof ControllerDirtTileEntity) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((ControllerDirtTileEntity)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_180663_b(worldIn, pos, state);
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }
}

