/*
 * Decompiled with CFR 0.152.
 */
package com.raphiiwarren.waterfreefarming.blocks;

import com.raphiiwarren.waterfreefarming.blocks.AbstractController;
import com.raphiiwarren.waterfreefarming.blocks.RedstoneFertilizedDirt;
import com.raphiiwarren.waterfreefarming.blocks.RedstoneFertilizedSand;
import com.raphiiwarren.waterfreefarming.blocks.RedstoneTilledFertilizedDirt;
import com.raphiiwarren.waterfreefarming.tileentity.FarmelementTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractFarmElement
extends BlockContainer {
    public AbstractFarmElement(Material material) {
        super(material);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new FarmelementTileEntity();
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new FarmelementTileEntity();
    }

    public TileEntity getTileEntity(World world, BlockPos pos) {
        return world.func_175625_s(pos);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing, IPlantable plantable) {
        return this.canFarmElementSustainPlant(state, world, pos, facing, plantable);
    }

    public abstract boolean canFarmElementSustainPlant(IBlockState var1, IBlockAccess var2, BlockPos var3, EnumFacing var4, IPlantable var5);

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        this.farmElementTick(state, world, pos, random);
    }

    public abstract void farmElementTick(IBlockState var1, World var2, BlockPos var3, Random var4);

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (((FarmelementTileEntity)tileentity).isActive()) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 1.0 + rand.nextDouble() * 4.0 / 10.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0 + d4, d1 + d4, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            this.activateFarmElement(worldIn, pos);
        }
    }

    public void activateFarmElement(World worldIn, BlockPos pos) {
        for (EnumFacing direction : EnumFacing.Plane.HORIZONTAL) {
            if (worldIn.func_180495_p(pos.func_177972_a(direction)).func_177230_c() instanceof AbstractController) {
                this.generateNewTileEntityData(worldIn, pos, pos.func_177972_a(direction));
            }
            if (!(worldIn.func_180495_p(pos.func_177972_a(direction)).func_177230_c() instanceof AbstractFarmElement)) continue;
            IBlockState farmElementState = worldIn.func_180495_p(pos.func_177972_a(direction));
            AbstractFarmElement neighbor = (AbstractFarmElement)farmElementState.func_177230_c();
            TileEntity tileentity = worldIn.func_175625_s(pos.func_177972_a(direction));
            if (!((FarmelementTileEntity)tileentity).isActive()) continue;
            this.generateNewTileEntityData(worldIn, pos, neighbor.calculateControllerPos(worldIn, pos.func_177972_a(direction)));
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (((FarmelementTileEntity)tileentity).isActive()) {
            this.notifyNeighborFarmElements(worldIn, pos, true);
        }
    }

    public void deactivateFarmElement(World worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block instanceof AbstractFarmElement) {
            for (EnumFacing direction : EnumFacing.Plane.HORIZONTAL) {
                Block controllerBlock = worldIn.func_180495_p(pos.func_177972_a(direction)).func_177230_c();
                if (!(controllerBlock instanceof AbstractController)) continue;
                worldIn.func_175684_a(pos.func_177972_a(direction), controllerBlock, 3);
            }
            TileEntity tileentity = worldIn.func_175625_s(pos);
            ((FarmelementTileEntity)tileentity).setActive(false);
            ((FarmelementTileEntity)tileentity).setControllerNorthOffset(0);
            ((FarmelementTileEntity)tileentity).setControllerSouthOffset(0);
            ((FarmelementTileEntity)tileentity).setControllerWestOffset(0);
            ((FarmelementTileEntity)tileentity).setControllerEastOffset(0);
            worldIn.func_175656_a(pos, block.func_176223_P());
        }
        this.notifyNeighborFarmElements(worldIn, pos, false);
    }

    public void notifyNeighborFarmElements(World worldIn, BlockPos pos, boolean value) {
        for (EnumFacing direction : EnumFacing.Plane.HORIZONTAL) {
            if (!(worldIn.func_180495_p(pos.func_177972_a(direction)).func_177230_c() instanceof AbstractFarmElement)) continue;
            TileEntity tileentity = worldIn.func_175625_s(pos.func_177972_a(direction));
            if (value) {
                if (((FarmelementTileEntity)tileentity).isActive()) continue;
                this.activateFarmElement(worldIn, pos.func_177972_a(direction));
                continue;
            }
            if (!((FarmelementTileEntity)tileentity).isActive()) continue;
            this.deactivateFarmElement(worldIn, pos.func_177972_a(direction));
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (((FarmelementTileEntity)tileentity).isActive()) {
            this.deactivateFarmElement(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_180495_p(fromPos).func_177230_c() instanceof AbstractFarmElement) {
                TileEntity neighborTileEntity = worldIn.func_175625_s(fromPos);
                TileEntity tileentity = worldIn.func_175625_s(pos);
                if (((FarmelementTileEntity)tileentity).isActive() != ((FarmelementTileEntity)neighborTileEntity).isActive()) {
                    this.notifyNeighborFarmElements(worldIn, fromPos, ((FarmelementTileEntity)neighborTileEntity).isActive());
                }
            }
            if (worldIn.func_180495_p(fromPos).func_177230_c() instanceof AbstractController) {
                this.activateFarmElement(worldIn, pos);
            }
            if (worldIn.func_180495_p(fromPos).func_177230_c() instanceof BlockAir && fromPos.equals((Object)this.calculateControllerPos(worldIn, pos))) {
                this.deactivateFarmElement(worldIn, pos);
            }
        }
    }

    public void generateNewTileEntityData(World worldIn, BlockPos farmElementPos, BlockPos controllerPos) {
        int offsetNorth = 0;
        int offsetSouth = 0;
        int offsetWest = 0;
        int offsetEast = 0;
        for (int i = -5; i <= 5; ++i) {
            if (controllerPos.func_177952_p() != farmElementPos.func_177952_p() + i) continue;
            if (i < 0) {
                offsetSouth = Math.abs(i);
                continue;
            }
            offsetNorth = i;
        }
        for (int j = -5; j <= 5; ++j) {
            if (controllerPos.func_177958_n() != farmElementPos.func_177958_n() + j) continue;
            if (j < 0) {
                offsetEast = Math.abs(j);
                continue;
            }
            offsetWest = j;
        }
        if (offsetNorth > 4 || offsetSouth > 4 || offsetWest > 4 || offsetEast > 4) {
            TileEntity tileentity = worldIn.func_175625_s(farmElementPos);
            ((FarmelementTileEntity)tileentity).setActive(false);
            IBlockState blockState = worldIn.func_180495_p(farmElementPos);
            Block block = blockState.func_177230_c();
            if (block instanceof RedstoneFertilizedDirt) {
                ((RedstoneFertilizedDirt)block).setActive(false, worldIn, farmElementPos);
            } else if (block instanceof RedstoneTilledFertilizedDirt) {
                ((RedstoneTilledFertilizedDirt)block).setActive(false, worldIn, farmElementPos);
            } else if (block instanceof RedstoneFertilizedSand) {
                ((RedstoneFertilizedSand)block).setActive(false, worldIn, farmElementPos);
            }
        } else {
            TileEntity tileentity = worldIn.func_175625_s(farmElementPos);
            ((FarmelementTileEntity)tileentity).setActive(true);
            ((FarmelementTileEntity)tileentity).setControllerNorthOffset(offsetNorth);
            ((FarmelementTileEntity)tileentity).setControllerSouthOffset(offsetSouth);
            ((FarmelementTileEntity)tileentity).setControllerWestOffset(offsetWest);
            ((FarmelementTileEntity)tileentity).setControllerEastOffset(offsetEast);
            IBlockState blockState = worldIn.func_180495_p(farmElementPos);
            Block block = blockState.func_177230_c();
            if (block instanceof RedstoneFertilizedDirt) {
                ((RedstoneFertilizedDirt)block).setActive(true, worldIn, farmElementPos);
            } else if (block instanceof RedstoneTilledFertilizedDirt) {
                ((RedstoneTilledFertilizedDirt)block).setActive(true, worldIn, farmElementPos);
            } else if (block instanceof RedstoneFertilizedSand) {
                ((RedstoneFertilizedSand)block).setActive(true, worldIn, farmElementPos);
            }
        }
    }

    public BlockPos calculateControllerPos(World world, BlockPos farmElementPos) {
        BlockPos returnPos = farmElementPos;
        TileEntity tileentity = world.func_175625_s(farmElementPos);
        if (((FarmelementTileEntity)tileentity).getControllerNorthOffset() != 0) {
            returnPos = returnPos.func_177970_e(((FarmelementTileEntity)tileentity).getControllerNorthOffset());
        }
        if (((FarmelementTileEntity)tileentity).getControllerSouthOffset() != 0) {
            returnPos = returnPos.func_177964_d(((FarmelementTileEntity)tileentity).getControllerSouthOffset());
        }
        if (((FarmelementTileEntity)tileentity).getControllerWestOffset() != 0) {
            returnPos = returnPos.func_177965_g(((FarmelementTileEntity)tileentity).getControllerWestOffset());
        }
        if (((FarmelementTileEntity)tileentity).getControllerEastOffset() != 0) {
            returnPos = returnPos.func_177985_f(((FarmelementTileEntity)tileentity).getControllerEastOffset());
        }
        return returnPos;
    }
}

