/*
 * Decompiled with CFR 0.152.
 */
package com.raphiiwarren.waterfreefarming.blocks;

import com.raphiiwarren.waterfreefarming.WaterfreeCreativeTab;
import com.raphiiwarren.waterfreefarming.blocks.AbstractFarmElement;
import com.raphiiwarren.waterfreefarming.blocks.ModBlocks;
import com.raphiiwarren.waterfreefarming.tileentity.ControllerDirtTileEntity;
import com.raphiiwarren.waterfreefarming.tileentity.FarmelementTileEntity;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockReed;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class RedstoneFertilizedSand
extends AbstractFarmElement {
    public boolean active;

    public RedstoneFertilizedSand(boolean active) {
        super(Material.field_151595_p);
        if (!active) {
            this.func_149647_a(WaterfreeCreativeTab.tabMyMod);
        }
        this.func_149663_c("redstone_fertilized_sand");
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
        this.func_149752_b(2.5f);
        if (active) {
            this.func_149715_a(1.0f);
        }
        if (!active) {
            this.func_149715_a(0.0f);
        }
        this.setHarvestLevel("shovel", 0);
        this.func_149672_a(SoundType.field_185855_h);
        this.active = active;
    }

    @Override
    public boolean canFarmElementSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(facing));
        if (plantable instanceof BlockReed) {
            return true;
        }
        return plantable instanceof BlockCactus;
    }

    @Override
    public void farmElementTick(IBlockState state, World world, BlockPos pos, Random random) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (((FarmelementTileEntity)tileentity).isActive()) {
            boolean isHarvestable = false;
            String topBlock = "";
            Block top = world.func_180495_p(pos.func_177981_b(2)).func_177230_c();
            if (top instanceof BlockReed) {
                isHarvestable = true;
                topBlock = "reed";
            } else if (top instanceof BlockCrops) {
                isHarvestable = true;
                topBlock = "cactus";
            }
            if (isHarvestable) {
                BlockPos controllerPos = this.calculateControllerPos(world, pos);
                ControllerDirtTileEntity controllerLocal = (ControllerDirtTileEntity)world.func_175625_s(controllerPos);
                BlockReed newHarvest = null;
                if (topBlock == "reed") {
                    newHarvest = (BlockReed)world.func_180495_p(pos.func_177981_b(2)).func_177230_c();
                } else if (topBlock == "cactus") {
                    newHarvest = (BlockCactus)world.func_180495_p(pos.func_177981_b(2)).func_177230_c();
                }
                ItemStack drops = newHarvest.func_185473_a(world, pos.func_177981_b(2), world.func_180495_p(pos.func_177981_b(2)));
                int gotHarvested = controllerLocal.addItemStack(drops);
                if (gotHarvested != -1) {
                    world.func_175655_b(pos.func_177981_b(2), false);
                }
            }
        }
    }

    public void setActive(boolean activeIn, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (activeIn) {
            worldIn.func_180501_a(pos, ModBlocks.activeRedstoneFertilizedSand.func_176223_P(), 3);
            worldIn.func_180501_a(pos, ModBlocks.activeRedstoneFertilizedSand.func_176223_P(), 3);
        } else {
            worldIn.func_180501_a(pos, ModBlocks.redstoneFertilizedSand.func_176223_P(), 3);
            worldIn.func_180501_a(pos, ModBlocks.redstoneFertilizedSand.func_176223_P(), 3);
        }
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }
}

