/*
 * Decompiled with CFR 0.152.
 */
package com.raphiiwarren.waterfreefarming.blocks;

import com.raphiiwarren.waterfreefarming.blocks.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TilledFertilizedDirt
extends BlockFarmland {
    public static final PropertyInteger MOISTURE = PropertyInteger.func_177719_a((String)"moisture", (int)0, (int)7);
    protected static final AxisAlignedBB FARMLAND_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);

    public TilledFertilizedDirt(Material material) {
        this.func_149663_c("tilled_fertilized_dirt");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(7)));
        this.func_149675_a(true);
        this.func_149713_g(255);
        this.func_149711_c(0.5f);
        this.func_149752_b(2.5f);
        this.setHarvestLevel("shovel", 0);
        this.func_149672_a(SoundType.field_185849_b);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FARMLAND_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i = (Integer)state.func_177229_b((IProperty)MOISTURE);
        if (!this.hasWater(worldIn, pos) && !worldIn.func_175727_C(pos.func_177984_a())) {
            if (i > 0) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.hasCrops(worldIn, pos)) {
                worldIn.func_175656_a(pos, ModBlocks.fertilizedDirt.func_176223_P());
            }
        } else if (i < 7) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
    }

    private boolean hasCrops(World worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block instanceof IPlantable && this.canSustainPlant(worldIn.func_180495_p(pos), (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)block);
    }

    private boolean hasWater(World worldIn, BlockPos pos) {
        return true;
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        super.func_189540_a(state, worldIn, pos, blockIn, pos);
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            worldIn.func_175656_a(pos, ModBlocks.fertilizedDirt.func_176223_P());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                return !iblockstate.func_185914_p() && block != Blocks.field_150458_ak && block != Blocks.field_185774_da && block != ModBlocks.tilledFertilizedDirt;
            }
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModBlocks.fertilizedDirt.func_180660_a(this.func_176223_P(), rand, fortune);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)ModBlocks.fertilizedDirt);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(meta & 7));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MOISTURE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MOISTURE});
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        if (plantable instanceof BlockBush) {
            return true;
        }
        switch (plantType) {
            case Crop: {
                return this == ModBlocks.tilledFertilizedDirt;
            }
            case Beach: {
                break;
            }
            case Cave: {
                break;
            }
            case Desert: {
                break;
            }
            case Nether: {
                break;
            }
            case Plains: {
                break;
            }
            case Water: {
                break;
            }
        }
        return false;
    }
}

