/*
 * Decompiled with CFR 0.152.
 */
package com.raphiiwarren.waterfreefarming.crafting;

import com.google.common.collect.Maps;
import com.raphiiwarren.waterfreefarming.blocks.ModBlocks;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;

public class FertilizerRecipes {
    private static final FertilizerRecipes WORKING_BASE = new FertilizerRecipes();
    private final Map<ItemStack, ItemStack> workingList = Maps.newHashMap();
    private final Map<ItemStack, Float> experienceList = Maps.newHashMap();

    public static FertilizerRecipes instance() {
        return WORKING_BASE;
    }

    private FertilizerRecipes() {
        this.addWorkingRecipeForBlock(Blocks.field_150346_d, new ItemStack((Block)ModBlocks.fertilizedDirt), 0.2f);
        this.addWorkingRecipeForBlock((Block)Blocks.field_150354_m, new ItemStack((Block)ModBlocks.fertilizedSand), 0.2f);
    }

    public void addWorkingRecipeForBlock(Block input, ItemStack stack, float experience) {
        this.addWorking(Item.func_150898_a((Block)input), stack, experience);
    }

    public void addWorking(Item input, ItemStack stack, float experience) {
        this.addWorkingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
    }

    public void addWorkingRecipe(ItemStack input, ItemStack stack, float experience) {
        if (this.getWorkingResult(input) != null) {
            FMLLog.info((String)("Ignored smelting recipe with conflicting input: " + input + " = " + stack), (Object[])new Object[0]);
            return;
        }
        this.workingList.put(input, stack);
        this.experienceList.put(stack, Float.valueOf(experience));
    }

    public ItemStack getWorkingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.workingList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getWorkingList() {
        return this.workingList;
    }

    public float getWorkingExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

