/*
 * Decompiled with CFR 0.152.
 */
package com.raphiiwarren.waterfreefarming.blocks;

import com.raphiiwarren.waterfreefarming.Main;
import com.raphiiwarren.waterfreefarming.blocks.ModBlocks;
import com.raphiiwarren.waterfreefarming.blocks.RedstoneFertilizedDirt;
import com.raphiiwarren.waterfreefarming.blocks.RedstoneFertilizedSand;
import com.raphiiwarren.waterfreefarming.blocks.RedstoneTilledFertilizedDirt;
import com.raphiiwarren.waterfreefarming.tileentity.ControllerDirtTileEntity;
import com.raphiiwarren.waterfreefarming.tileentity.FarmelementTileEntity;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControllerTilledFertilizedDirt
extends BlockContainer {
    public static final PropertyInteger MOISTURE = PropertyInteger.func_177719_a((String)"moisture", (int)0, (int)7);
    protected static final AxisAlignedBB FARMLAND_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
    boolean active;
    BlockPos controller;
    private static boolean keepInventory = false;

    public ControllerTilledFertilizedDirt(Material material) {
        super(Material.field_151578_c);
        this.func_149663_c("waterfreefarming:controller_tilled_fertilized_dirt");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(7)));
        this.func_149675_a(true);
        this.func_149713_g(255);
        this.func_149711_c(0.5f);
        this.func_149715_a(0.5f);
        this.func_149752_b(2.5f);
        this.setHarvestLevel("shovel", 0);
        this.func_149672_a(SoundType.field_185849_b);
        this.active = true;
        this.controller = null;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new ControllerDirtTileEntity();
    }

    public TileEntity getTileEntity(World world, BlockPos pos) {
        return world.func_175625_s(pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof ControllerDirtTileEntity) {
            player.openGui((Object)Main.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState blockstate) {
        TileEntity tileentity;
        if (!keepInventory && (tileentity = world.func_175625_s(pos)) instanceof ControllerDirtTileEntity) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((ControllerDirtTileEntity)tileentity));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, blockstate);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        if (plantable instanceof BlockBush) {
            return true;
        }
        switch (plantType) {
            case Crop: {
                return this == ModBlocks.controllerTilledFertilizedDirt;
            }
            case Beach: {
                break;
            }
            case Cave: {
                break;
            }
            case Desert: {
                break;
            }
            case Nether: {
                break;
            }
            case Plains: {
                break;
            }
            case Water: {
                break;
            }
        }
        return false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.controller = pos;
        if (this.active) {
            boolean isCrop = false;
            Block crops = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
            if (crops instanceof BlockCrops) {
                isCrop = true;
            }
            if (isCrop) {
                ControllerDirtTileEntity controllerLocal = (ControllerDirtTileEntity)worldIn.func_175625_s(this.controller);
                BlockCrops newCrops = (BlockCrops)worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
                if (!controllerLocal.isFull() && newCrops.func_185525_y(newCrops.func_176221_a(worldIn.func_180495_p(pos.func_177984_a()), (IBlockAccess)worldIn, pos.func_177984_a()))) {
                    worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    Item item = newCrops.func_180660_a(worldIn.func_180495_p(pos.func_177984_a()), rand, 0);
                    ItemStack drops = new ItemStack(item, rand.nextInt(3) + 1);
                    controllerLocal.addInventorySlotContents(drops);
                    worldIn.func_175656_a(pos.func_177984_a(), newCrops.func_176223_P());
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.active) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 1.0 + rand.nextDouble() * 4.0 / 10.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0 + d4, d1 + d4, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        this.controller = pos;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof ControllerDirtTileEntity) {
            ((ControllerDirtTileEntity)tileentity).func_190575_a(stack.func_82833_r());
        }
        this.controller = pos;
        this.activateFarm(worldIn, pos);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        this.deactivateFarm(worldIn, pos);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.deactivateFarm(worldIn, pos);
    }

    public RedstoneTilledFertilizedDirt castToTilledDirt(World worldIn, BlockPos pos, Block blockIn) {
        if (worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.redstoneTilledFertilizedDirt) {
            RedstoneTilledFertilizedDirt blockOut = (RedstoneTilledFertilizedDirt)blockIn;
            return blockOut;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.activeRedstoneTilledFertilizedDirt) {
            RedstoneTilledFertilizedDirt blockOut = (RedstoneTilledFertilizedDirt)blockIn;
            return blockOut;
        }
        return null;
    }

    public RedstoneFertilizedDirt castToRedstonedDirt(World worldIn, BlockPos pos, Block blockIn) {
        if (worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.redstoneFertilizedDirt) {
            RedstoneFertilizedDirt blockOut = (RedstoneFertilizedDirt)blockIn;
            return blockOut;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.activeRedstoneFertilizedDirt) {
            RedstoneFertilizedDirt blockOut = (RedstoneFertilizedDirt)blockIn;
            return blockOut;
        }
        return null;
    }

    public boolean isNeighbourActivable(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.redstoneTilledFertilizedDirt) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.redstoneFertilizedDirt) {
            return true;
        }
        return worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.redstoneFertilizedSand;
    }

    public boolean isNeighbourDeactivable(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.activeRedstoneTilledFertilizedDirt) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.activeRedstoneFertilizedDirt) {
            return true;
        }
        return worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.activeRedstoneFertilizedSand;
    }

    public boolean isEquivalentBlockPos(BlockPos pos1, BlockPos pos2) {
        if (pos1 != null && pos2 != null) {
            return pos1.func_177958_n() == pos2.func_177958_n() && pos1.func_177956_o() == pos2.func_177956_o() && pos1.func_177952_p() == pos2.func_177952_p();
        }
        return false;
    }

    public void activateFarm(World worldIn, BlockPos pos) {
        if (this.isNeighbourActivable(worldIn, pos.func_177978_c())) {
            BlockContainer newBlockNorth;
            Block blockNorth = worldIn.func_180495_p(pos.func_177978_c()).func_177230_c();
            if (blockNorth instanceof RedstoneTilledFertilizedDirt) {
                newBlockNorth = (RedstoneTilledFertilizedDirt)blockNorth;
                newBlockNorth.activateNeighbours(worldIn, pos.func_177978_c(), null, pos);
            }
            if (blockNorth instanceof RedstoneFertilizedDirt) {
                newBlockNorth = (RedstoneFertilizedDirt)blockNorth;
                newBlockNorth.activateNeighbours(worldIn, pos.func_177978_c(), null, pos);
            }
            if (blockNorth instanceof RedstoneFertilizedSand) {
                newBlockNorth = (RedstoneFertilizedSand)blockNorth;
                newBlockNorth.activateNeighbours(worldIn, pos.func_177978_c(), null, pos);
            }
        }
        if (this.isNeighbourActivable(worldIn, pos.func_177974_f())) {
            BlockContainer newBlockEast;
            Block blockEast = worldIn.func_180495_p(pos.func_177974_f()).func_177230_c();
            if (blockEast instanceof RedstoneTilledFertilizedDirt) {
                newBlockEast = (RedstoneTilledFertilizedDirt)blockEast;
                newBlockEast.activateNeighbours(worldIn, pos.func_177974_f(), null, pos);
            }
            if (blockEast instanceof RedstoneFertilizedDirt) {
                newBlockEast = (RedstoneFertilizedDirt)blockEast;
                newBlockEast.activateNeighbours(worldIn, pos.func_177974_f(), null, pos);
            }
            if (blockEast instanceof RedstoneFertilizedSand) {
                newBlockEast = (RedstoneFertilizedSand)blockEast;
                newBlockEast.activateNeighbours(worldIn, pos.func_177974_f(), null, pos);
            }
        }
        if (this.isNeighbourActivable(worldIn, pos.func_177968_d())) {
            BlockContainer newBlockSouth;
            Block blockSouth = worldIn.func_180495_p(pos.func_177968_d()).func_177230_c();
            if (blockSouth instanceof RedstoneTilledFertilizedDirt) {
                newBlockSouth = (RedstoneTilledFertilizedDirt)blockSouth;
                newBlockSouth.activateNeighbours(worldIn, pos.func_177968_d(), null, pos);
            }
            if (blockSouth instanceof RedstoneFertilizedDirt) {
                newBlockSouth = (RedstoneFertilizedDirt)blockSouth;
                newBlockSouth.activateNeighbours(worldIn, pos.func_177968_d(), null, pos);
            }
            if (blockSouth instanceof RedstoneFertilizedSand) {
                newBlockSouth = (RedstoneFertilizedSand)blockSouth;
                newBlockSouth.activateNeighbours(worldIn, pos.func_177968_d(), null, pos);
            }
        }
        if (this.isNeighbourActivable(worldIn, pos.func_177976_e())) {
            BlockContainer newBlockWest;
            Block blockWest = worldIn.func_180495_p(pos.func_177976_e()).func_177230_c();
            if (blockWest instanceof RedstoneTilledFertilizedDirt) {
                newBlockWest = (RedstoneTilledFertilizedDirt)blockWest;
                newBlockWest.activateNeighbours(worldIn, pos.func_177976_e(), null, pos);
            }
            if (blockWest instanceof RedstoneFertilizedDirt) {
                newBlockWest = (RedstoneFertilizedDirt)blockWest;
                newBlockWest.activateNeighbours(worldIn, pos.func_177976_e(), null, pos);
            }
            if (blockWest instanceof RedstoneFertilizedSand) {
                newBlockWest = (RedstoneFertilizedSand)blockWest;
                newBlockWest.activateNeighbours(worldIn, pos.func_177976_e(), null, pos);
            }
        }
    }

    public void deactivateFarm(World worldIn, BlockPos pos) {
        if (this.isNeighbourDeactivable(worldIn, pos.func_177978_c())) {
            BlockContainer newBlockNorth;
            FarmelementTileEntity northTileEntity;
            Block blockNorth = worldIn.func_180495_p(pos.func_177978_c()).func_177230_c();
            if (blockNorth instanceof RedstoneTilledFertilizedDirt && this.isEquivalentBlockPos(pos, (northTileEntity = (FarmelementTileEntity)(newBlockNorth = (RedstoneTilledFertilizedDirt)blockNorth).getTileEntity(worldIn, pos.func_177978_c())).getControllerPos())) {
                newBlockNorth.deactivateNeighbours(worldIn, pos.func_177978_c(), null, pos);
            }
            if (blockNorth instanceof RedstoneFertilizedDirt && this.isEquivalentBlockPos(pos, (northTileEntity = (FarmelementTileEntity)(newBlockNorth = (RedstoneFertilizedDirt)blockNorth).getTileEntity(worldIn, pos.func_177978_c())).getControllerPos())) {
                newBlockNorth.deactivateNeighbours(worldIn, pos.func_177978_c(), null, pos);
            }
            if (blockNorth instanceof RedstoneFertilizedSand && this.isEquivalentBlockPos(pos, (northTileEntity = (FarmelementTileEntity)(newBlockNorth = (RedstoneFertilizedSand)blockNorth).getTileEntity(worldIn, pos.func_177978_c())).getControllerPos())) {
                newBlockNorth.deactivateNeighbours(worldIn, pos.func_177978_c(), null, pos);
            }
        }
        if (this.isNeighbourDeactivable(worldIn, pos.func_177974_f())) {
            BlockContainer newBlockEast;
            FarmelementTileEntity eastTileEntity;
            Block blockEast = worldIn.func_180495_p(pos.func_177974_f()).func_177230_c();
            if (blockEast instanceof RedstoneTilledFertilizedDirt && this.isEquivalentBlockPos(pos, (eastTileEntity = (FarmelementTileEntity)(newBlockEast = (RedstoneTilledFertilizedDirt)blockEast).getTileEntity(worldIn, pos.func_177974_f())).getControllerPos())) {
                newBlockEast.deactivateNeighbours(worldIn, pos.func_177974_f(), null, pos);
            }
            if (blockEast instanceof RedstoneFertilizedDirt && this.isEquivalentBlockPos(pos, (eastTileEntity = (FarmelementTileEntity)(newBlockEast = (RedstoneFertilizedDirt)blockEast).getTileEntity(worldIn, pos.func_177974_f())).getControllerPos())) {
                newBlockEast.deactivateNeighbours(worldIn, pos.func_177974_f(), null, pos);
            }
            if (blockEast instanceof RedstoneFertilizedSand && this.isEquivalentBlockPos(pos, (eastTileEntity = (FarmelementTileEntity)(newBlockEast = (RedstoneFertilizedSand)blockEast).getTileEntity(worldIn, pos.func_177974_f())).getControllerPos())) {
                newBlockEast.deactivateNeighbours(worldIn, pos.func_177974_f(), null, pos);
            }
        }
        if (this.isNeighbourDeactivable(worldIn, pos.func_177968_d())) {
            BlockContainer newBlockSouth;
            FarmelementTileEntity southTileEntity;
            Block blockSouth = worldIn.func_180495_p(pos.func_177968_d()).func_177230_c();
            if (blockSouth instanceof RedstoneTilledFertilizedDirt && this.isEquivalentBlockPos(pos, (southTileEntity = (FarmelementTileEntity)(newBlockSouth = (RedstoneTilledFertilizedDirt)blockSouth).getTileEntity(worldIn, pos.func_177968_d())).getControllerPos())) {
                newBlockSouth.deactivateNeighbours(worldIn, pos.func_177968_d(), null, pos);
            }
            if (blockSouth instanceof RedstoneFertilizedDirt && this.isEquivalentBlockPos(pos, (southTileEntity = (FarmelementTileEntity)(newBlockSouth = (RedstoneFertilizedDirt)blockSouth).getTileEntity(worldIn, pos.func_177968_d())).getControllerPos())) {
                newBlockSouth.deactivateNeighbours(worldIn, pos.func_177968_d(), null, pos);
            }
            if (blockSouth instanceof RedstoneFertilizedSand && this.isEquivalentBlockPos(pos, (southTileEntity = (FarmelementTileEntity)(newBlockSouth = (RedstoneFertilizedSand)blockSouth).getTileEntity(worldIn, pos.func_177968_d())).getControllerPos())) {
                newBlockSouth.deactivateNeighbours(worldIn, pos.func_177968_d(), null, pos);
            }
        }
        if (this.isNeighbourDeactivable(worldIn, pos.func_177976_e())) {
            BlockContainer newBlockWest;
            FarmelementTileEntity westTileEntity;
            Block blockWest = worldIn.func_180495_p(pos.func_177976_e()).func_177230_c();
            if (blockWest instanceof RedstoneTilledFertilizedDirt && this.isEquivalentBlockPos(pos, (westTileEntity = (FarmelementTileEntity)(newBlockWest = (RedstoneTilledFertilizedDirt)blockWest).getTileEntity(worldIn, pos.func_177976_e())).getControllerPos())) {
                newBlockWest.deactivateNeighbours(worldIn, pos.func_177976_e(), null, pos);
            }
            if (blockWest instanceof RedstoneFertilizedDirt && this.isEquivalentBlockPos(pos, (westTileEntity = (FarmelementTileEntity)(newBlockWest = (RedstoneFertilizedDirt)blockWest).getTileEntity(worldIn, pos.func_177976_e())).getControllerPos())) {
                newBlockWest.deactivateNeighbours(worldIn, pos.func_177976_e(), null, pos);
            }
            if (blockWest instanceof RedstoneFertilizedSand && this.isEquivalentBlockPos(pos, (westTileEntity = (FarmelementTileEntity)(newBlockWest = (RedstoneFertilizedSand)blockWest).getTileEntity(worldIn, pos.func_177976_e())).getControllerPos())) {
                newBlockWest.deactivateNeighbours(worldIn, pos.func_177976_e(), null, pos);
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FARMLAND_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        super.func_189540_a(state, worldIn, pos, blockIn, pos);
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            worldIn.func_175656_a(pos, ModBlocks.controllerFertilizedDirt.func_176223_P());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                return !iblockstate.func_185914_p() && block != Blocks.field_150458_ak && block != Blocks.field_185774_da && block != ModBlocks.controllerTilledFertilizedDirt;
            }
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModBlocks.controllerFertilizedDirt.func_180660_a(this.func_176223_P(), rand, fortune);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)ModBlocks.controllerFertilizedDirt);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(meta & 7));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MOISTURE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MOISTURE});
    }
}

