/*
 * Decompiled with CFR 0.152.
 */
package com.raphiiwarren.waterfreefarming.blocks;

import com.raphiiwarren.waterfreefarming.WaterfreeCreativeTab;
import com.raphiiwarren.waterfreefarming.blocks.ControllerFertilizedDirt;
import com.raphiiwarren.waterfreefarming.blocks.ControllerSand;
import com.raphiiwarren.waterfreefarming.blocks.ControllerTilledFertilizedDirt;
import com.raphiiwarren.waterfreefarming.blocks.ModBlocks;
import com.raphiiwarren.waterfreefarming.blocks.RedstoneFertilizedDirt;
import com.raphiiwarren.waterfreefarming.blocks.RedstoneTilledFertilizedDirt;
import com.raphiiwarren.waterfreefarming.tileentity.ControllerDirtTileEntity;
import com.raphiiwarren.waterfreefarming.tileentity.FarmelementTileEntity;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockReed;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RedstoneFertilizedSand
extends BlockContainer {
    public boolean active;
    public BlockPos controller;
    private boolean keepInventory = false;
    private boolean getsDestroyed = false;

    public RedstoneFertilizedSand(Material material, boolean active) {
        super(Material.field_151595_p);
        if (!active) {
            this.func_149647_a(WaterfreeCreativeTab.tabMyMod);
        }
        this.func_149663_c("redstone_fertilized_sand");
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
        this.func_149752_b(2.5f);
        this.setHarvestLevel("shovel", 0);
        this.func_149672_a(SoundType.field_185855_h);
        this.active = false;
        this.controller = null;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        if (plantable instanceof BlockReed) {
            return true;
        }
        return plantable instanceof BlockCactus;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        FarmelementTileEntity thisTileEntity = (FarmelementTileEntity)this.getTileEntity(worldIn, pos);
        if (thisTileEntity.isActive() && thisTileEntity.hasController() && worldIn.func_175623_d(thisTileEntity.getControllerPos())) {
            this.deactivateNeighbours(worldIn, pos, pos, this.controller);
        }
        if (thisTileEntity.isActive()) {
            boolean isHarvestable = false;
            String topBlock = "";
            Block top = worldIn.func_180495_p(pos.func_177981_b(2)).func_177230_c();
            if (top instanceof BlockReed) {
                isHarvestable = true;
                topBlock = "reed";
            } else if (top instanceof BlockCactus) {
                isHarvestable = true;
                topBlock = "cactus";
            }
            if (isHarvestable) {
                ControllerDirtTileEntity controllerLocal = (ControllerDirtTileEntity)worldIn.func_175625_s(thisTileEntity.getControllerPos());
                BlockReed newHarvest = null;
                if (topBlock == "reed") {
                    newHarvest = (BlockReed)worldIn.func_180495_p(pos.func_177981_b(2)).func_177230_c();
                } else if (topBlock == "cactus") {
                    newHarvest = (BlockCactus)worldIn.func_180495_p(pos.func_177981_b(2)).func_177230_c();
                }
                if (!controllerLocal.isFull()) {
                    worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    Item item = newHarvest.func_180660_a(worldIn.func_180495_p(pos.func_177981_b(2)), rand, 0);
                    ItemStack drops = new ItemStack(item, 1);
                    controllerLocal.addInventorySlotContents(drops);
                    worldIn.func_175698_g(pos.func_177981_b(2));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        FarmelementTileEntity thisTileEntity = (FarmelementTileEntity)this.getTileEntity(worldIn, pos);
        if (thisTileEntity.isActive()) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 1.0 + rand.nextDouble() * 4.0 / 10.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0 + d4, d1 + d4, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
            }
            BlockPos controller = thisTileEntity.getControllerPos();
            int xDistance = controller.func_177958_n() - pos.func_177958_n();
            int zDistance = controller.func_177952_p() - pos.func_177952_p();
            float baseValue = 0.5f;
            float decreaseFactor = 0.046f;
            int distanceSum = Math.abs(xDistance) + Math.abs(zDistance);
            this.func_149715_a(baseValue - (float)distanceSum * decreaseFactor);
        } else {
            this.func_149715_a(0.0f);
        }
    }

    public void setActive(boolean activeIn, World worldIn, BlockPos pos, BlockPos controllerIn) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        this.keepInventory = true;
        FarmelementTileEntity thisTileEntity = (FarmelementTileEntity)this.getTileEntity(worldIn, pos);
        thisTileEntity.updateInformation(activeIn, controllerIn);
        if (activeIn) {
            worldIn.func_180501_a(pos, ModBlocks.activeRedstoneFertilizedSand.func_176223_P(), 3);
            worldIn.func_180501_a(pos, ModBlocks.activeRedstoneFertilizedSand.func_176223_P(), 3);
        } else {
            worldIn.func_180501_a(pos, ModBlocks.redstoneFertilizedSand.func_176223_P(), 3);
            worldIn.func_180501_a(pos, ModBlocks.redstoneFertilizedSand.func_176223_P(), 3);
        }
        this.keepInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new FarmelementTileEntity();
    }

    public TileEntity getTileEntity(World world, BlockPos pos) {
        return world.func_175625_s(pos);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState blockstate) {
        if (this.getsDestroyed) {
            boolean wasActive = false;
            FarmelementTileEntity thisTileEntity = (FarmelementTileEntity)this.getTileEntity(world, pos);
            if (thisTileEntity != null) {
                BlockPos tempControllerPos = thisTileEntity.getControllerPos();
                if (!this.keepInventory && thisTileEntity.isActive()) {
                    wasActive = true;
                    this.deactivateNeighbours(world, pos, pos, null);
                }
                super.func_180663_b(world, pos, blockstate);
                world.func_175698_g(pos);
                if (wasActive) {
                    Block controllerBlock = world.func_180495_p(tempControllerPos).func_177230_c();
                    if (controllerBlock instanceof ControllerFertilizedDirt) {
                        ((ControllerFertilizedDirt)controllerBlock).activateFarm(world, tempControllerPos);
                    }
                    if (controllerBlock instanceof ControllerTilledFertilizedDirt) {
                        ((ControllerTilledFertilizedDirt)controllerBlock).activateFarm(world, tempControllerPos);
                    }
                    if (controllerBlock instanceof ControllerSand) {
                        ((ControllerSand)controllerBlock).activateFarm(world, tempControllerPos);
                    }
                }
            }
            this.getsDestroyed = false;
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.checkNeighbours(worldIn, pos);
    }

    public void activateNeighbours(World worldIn, BlockPos currentPos, BlockPos sender, BlockPos controllerIn) {
        if (this.isControllerInRange(worldIn, currentPos, controllerIn)) {
            this.setActive(true, worldIn, currentPos, controllerIn);
            if (this.isNeighbourActivable(worldIn, currentPos.func_177978_c()) && currentPos.func_177978_c() != sender) {
                BlockContainer newBlockNorth;
                Block blockNorth = worldIn.func_180495_p(currentPos.func_177978_c()).func_177230_c();
                if (blockNorth instanceof RedstoneTilledFertilizedDirt) {
                    newBlockNorth = (RedstoneTilledFertilizedDirt)blockNorth;
                    newBlockNorth.activateNeighbours(worldIn, currentPos.func_177978_c(), currentPos, controllerIn);
                }
                if (blockNorth instanceof RedstoneFertilizedDirt) {
                    newBlockNorth = (RedstoneFertilizedDirt)blockNorth;
                    newBlockNorth.activateNeighbours(worldIn, currentPos.func_177978_c(), currentPos, controllerIn);
                }
                if (blockNorth instanceof RedstoneFertilizedSand) {
                    newBlockNorth = (RedstoneFertilizedSand)blockNorth;
                    newBlockNorth.activateNeighbours(worldIn, currentPos.func_177978_c(), currentPos, controllerIn);
                }
            }
            if (this.isNeighbourActivable(worldIn, currentPos.func_177974_f()) && currentPos.func_177974_f() != sender) {
                BlockContainer newBlockEast;
                Block blockEast = worldIn.func_180495_p(currentPos.func_177974_f()).func_177230_c();
                if (blockEast instanceof RedstoneTilledFertilizedDirt) {
                    newBlockEast = (RedstoneTilledFertilizedDirt)blockEast;
                    newBlockEast.activateNeighbours(worldIn, currentPos.func_177974_f(), currentPos, controllerIn);
                }
                if (blockEast instanceof RedstoneFertilizedDirt) {
                    newBlockEast = (RedstoneFertilizedDirt)blockEast;
                    newBlockEast.activateNeighbours(worldIn, currentPos.func_177974_f(), currentPos, controllerIn);
                }
                if (blockEast instanceof RedstoneFertilizedSand) {
                    newBlockEast = (RedstoneFertilizedSand)blockEast;
                    newBlockEast.activateNeighbours(worldIn, currentPos.func_177974_f(), currentPos, controllerIn);
                }
            }
            if (this.isNeighbourActivable(worldIn, currentPos.func_177968_d()) && currentPos.func_177968_d() != sender) {
                BlockContainer newBlockSouth;
                Block blockSouth = worldIn.func_180495_p(currentPos.func_177968_d()).func_177230_c();
                if (blockSouth instanceof RedstoneTilledFertilizedDirt) {
                    newBlockSouth = (RedstoneTilledFertilizedDirt)blockSouth;
                    newBlockSouth.activateNeighbours(worldIn, currentPos.func_177968_d(), currentPos, controllerIn);
                }
                if (blockSouth instanceof RedstoneFertilizedDirt) {
                    newBlockSouth = (RedstoneFertilizedDirt)blockSouth;
                    newBlockSouth.activateNeighbours(worldIn, currentPos.func_177968_d(), currentPos, controllerIn);
                }
                if (blockSouth instanceof RedstoneFertilizedSand) {
                    newBlockSouth = (RedstoneFertilizedSand)blockSouth;
                    newBlockSouth.activateNeighbours(worldIn, currentPos.func_177968_d(), currentPos, controllerIn);
                }
            }
            if (this.isNeighbourActivable(worldIn, currentPos.func_177976_e()) && currentPos.func_177976_e() != sender) {
                BlockContainer newBlockWest;
                Block blockWest = worldIn.func_180495_p(currentPos.func_177976_e()).func_177230_c();
                if (blockWest instanceof RedstoneTilledFertilizedDirt) {
                    newBlockWest = (RedstoneTilledFertilizedDirt)blockWest;
                    newBlockWest.activateNeighbours(worldIn, currentPos.func_177976_e(), currentPos, controllerIn);
                }
                if (blockWest instanceof RedstoneFertilizedDirt) {
                    newBlockWest = (RedstoneFertilizedDirt)blockWest;
                    newBlockWest.activateNeighbours(worldIn, currentPos.func_177976_e(), currentPos, controllerIn);
                }
                if (blockWest instanceof RedstoneFertilizedSand) {
                    newBlockWest = (RedstoneFertilizedSand)blockWest;
                    newBlockWest.activateNeighbours(worldIn, currentPos.func_177976_e(), currentPos, controllerIn);
                }
            }
        }
    }

    public void deactivateNeighbours(World worldIn, BlockPos currentPos, BlockPos sender, BlockPos controller) {
        FarmelementTileEntity thisTileEntity = (FarmelementTileEntity)this.getTileEntity(worldIn, currentPos);
        BlockPos oldController = thisTileEntity.getControllerPos();
        this.setActive(false, worldIn, currentPos, null);
        if (this.isNeighbourDeactivable(worldIn, currentPos.func_177978_c()) && currentPos.func_177978_c() != sender) {
            BlockContainer newBlockNorth;
            FarmelementTileEntity northTileEntity;
            Block blockNorth = worldIn.func_180495_p(currentPos.func_177978_c()).func_177230_c();
            if (blockNorth instanceof RedstoneTilledFertilizedDirt && this.isEquivalentBlockPos(oldController, (northTileEntity = (FarmelementTileEntity)(newBlockNorth = (RedstoneTilledFertilizedDirt)blockNorth).getTileEntity(worldIn, currentPos.func_177978_c())).getControllerPos())) {
                newBlockNorth.deactivateNeighbours(worldIn, currentPos.func_177978_c(), currentPos, controller);
            }
            if (blockNorth instanceof RedstoneFertilizedDirt && this.isEquivalentBlockPos(oldController, (northTileEntity = (FarmelementTileEntity)(newBlockNorth = (RedstoneFertilizedDirt)blockNorth).getTileEntity(worldIn, currentPos.func_177978_c())).getControllerPos())) {
                newBlockNorth.deactivateNeighbours(worldIn, currentPos.func_177978_c(), currentPos, controller);
            }
            if (blockNorth instanceof RedstoneFertilizedSand && this.isEquivalentBlockPos(oldController, (northTileEntity = (FarmelementTileEntity)(newBlockNorth = (RedstoneFertilizedSand)blockNorth).getTileEntity(worldIn, currentPos.func_177978_c())).getControllerPos())) {
                newBlockNorth.deactivateNeighbours(worldIn, currentPos.func_177978_c(), currentPos, controller);
            }
        }
        if (this.isNeighbourDeactivable(worldIn, currentPos.func_177974_f()) && currentPos.func_177974_f() != sender) {
            BlockContainer newBlockEast;
            FarmelementTileEntity eastTileEntity;
            Block blockEast = worldIn.func_180495_p(currentPos.func_177974_f()).func_177230_c();
            if (blockEast instanceof RedstoneTilledFertilizedDirt && this.isEquivalentBlockPos(oldController, (eastTileEntity = (FarmelementTileEntity)(newBlockEast = (RedstoneTilledFertilizedDirt)blockEast).getTileEntity(worldIn, currentPos.func_177974_f())).getControllerPos())) {
                newBlockEast.deactivateNeighbours(worldIn, currentPos.func_177974_f(), currentPos, controller);
            }
            if (blockEast instanceof RedstoneFertilizedDirt && this.isEquivalentBlockPos(oldController, (eastTileEntity = (FarmelementTileEntity)(newBlockEast = (RedstoneFertilizedDirt)blockEast).getTileEntity(worldIn, currentPos.func_177974_f())).getControllerPos())) {
                newBlockEast.deactivateNeighbours(worldIn, currentPos.func_177974_f(), currentPos, controller);
            }
            if (blockEast instanceof RedstoneFertilizedSand && this.isEquivalentBlockPos(oldController, (eastTileEntity = (FarmelementTileEntity)(newBlockEast = (RedstoneFertilizedSand)blockEast).getTileEntity(worldIn, currentPos.func_177974_f())).getControllerPos())) {
                newBlockEast.deactivateNeighbours(worldIn, currentPos.func_177974_f(), currentPos, controller);
            }
        }
        if (this.isNeighbourDeactivable(worldIn, currentPos.func_177968_d()) && currentPos.func_177968_d() != sender) {
            BlockContainer newBlockSouth;
            FarmelementTileEntity southTileEntity;
            Block blockSouth = worldIn.func_180495_p(currentPos.func_177968_d()).func_177230_c();
            if (blockSouth instanceof RedstoneTilledFertilizedDirt && this.isEquivalentBlockPos(oldController, (southTileEntity = (FarmelementTileEntity)(newBlockSouth = (RedstoneTilledFertilizedDirt)blockSouth).getTileEntity(worldIn, currentPos.func_177968_d())).getControllerPos())) {
                newBlockSouth.deactivateNeighbours(worldIn, currentPos.func_177968_d(), currentPos, controller);
            }
            if (blockSouth instanceof RedstoneFertilizedDirt && this.isEquivalentBlockPos(oldController, (southTileEntity = (FarmelementTileEntity)(newBlockSouth = (RedstoneFertilizedDirt)blockSouth).getTileEntity(worldIn, currentPos.func_177968_d())).getControllerPos())) {
                newBlockSouth.deactivateNeighbours(worldIn, currentPos.func_177968_d(), currentPos, controller);
            }
            if (blockSouth instanceof RedstoneFertilizedSand && this.isEquivalentBlockPos(oldController, (southTileEntity = (FarmelementTileEntity)(newBlockSouth = (RedstoneFertilizedSand)blockSouth).getTileEntity(worldIn, currentPos.func_177968_d())).getControllerPos())) {
                newBlockSouth.deactivateNeighbours(worldIn, currentPos.func_177968_d(), currentPos, controller);
            }
        }
        if (this.isNeighbourDeactivable(worldIn, currentPos.func_177976_e()) && currentPos.func_177976_e() != sender) {
            BlockContainer newBlockWest;
            FarmelementTileEntity westTileEntity;
            Block blockWest = worldIn.func_180495_p(currentPos.func_177976_e()).func_177230_c();
            if (blockWest instanceof RedstoneTilledFertilizedDirt && this.isEquivalentBlockPos(oldController, (westTileEntity = (FarmelementTileEntity)(newBlockWest = (RedstoneTilledFertilizedDirt)blockWest).getTileEntity(worldIn, currentPos.func_177976_e())).getControllerPos())) {
                newBlockWest.deactivateNeighbours(worldIn, currentPos.func_177976_e(), currentPos, controller);
            }
            if (blockWest instanceof RedstoneFertilizedDirt && this.isEquivalentBlockPos(oldController, (westTileEntity = (FarmelementTileEntity)(newBlockWest = (RedstoneFertilizedDirt)blockWest).getTileEntity(worldIn, currentPos.func_177976_e())).getControllerPos())) {
                newBlockWest.deactivateNeighbours(worldIn, currentPos.func_177976_e(), currentPos, controller);
            }
            if (blockWest instanceof RedstoneFertilizedSand && this.isEquivalentBlockPos(oldController, (westTileEntity = (FarmelementTileEntity)(newBlockWest = (RedstoneFertilizedSand)blockWest).getTileEntity(worldIn, currentPos.func_177976_e())).getControllerPos())) {
                newBlockWest.deactivateNeighbours(worldIn, currentPos.func_177976_e(), currentPos, controller);
            }
        }
    }

    public void checkNeighbours(World worldIn, BlockPos pos) {
        BlockContainer newBlockWest;
        FarmelementTileEntity westTileEntity;
        BlockContainer newBlockSouth;
        FarmelementTileEntity southTileEntity;
        BlockContainer newBlockEast;
        FarmelementTileEntity eastTileEntity;
        BlockContainer newBlockNorth;
        FarmelementTileEntity northTileEntity;
        Block blockNorth = worldIn.func_180495_p(pos.func_177978_c()).func_177230_c();
        if (blockNorth instanceof ControllerFertilizedDirt) {
            this.activateNeighbours(worldIn, pos, null, pos.func_177978_c());
            return;
        }
        if (blockNorth instanceof ControllerTilledFertilizedDirt) {
            this.activateNeighbours(worldIn, pos, null, pos.func_177978_c());
            return;
        }
        if (blockNorth instanceof ControllerSand) {
            this.activateNeighbours(worldIn, pos, null, pos.func_177978_c());
            return;
        }
        if (blockNorth instanceof RedstoneTilledFertilizedDirt && (northTileEntity = (FarmelementTileEntity)(newBlockNorth = (RedstoneTilledFertilizedDirt)blockNorth).getTileEntity(worldIn, pos.func_177978_c())).isActive() && this.isControllerInRange(worldIn, pos, northTileEntity.getControllerPos())) {
            this.activateNeighbours(worldIn, pos, null, northTileEntity.getControllerPos());
            return;
        }
        if (blockNorth instanceof RedstoneFertilizedDirt && (northTileEntity = (FarmelementTileEntity)(newBlockNorth = (RedstoneFertilizedDirt)blockNorth).getTileEntity(worldIn, pos.func_177978_c())).isActive() && this.isControllerInRange(worldIn, pos, northTileEntity.getControllerPos())) {
            this.activateNeighbours(worldIn, pos, null, northTileEntity.getControllerPos());
            return;
        }
        if (blockNorth instanceof RedstoneFertilizedSand && (northTileEntity = (FarmelementTileEntity)(newBlockNorth = (RedstoneFertilizedSand)blockNorth).getTileEntity(worldIn, pos.func_177978_c())).isActive() && this.isControllerInRange(worldIn, pos, northTileEntity.getControllerPos())) {
            this.activateNeighbours(worldIn, pos, null, northTileEntity.getControllerPos());
            return;
        }
        Block blockEast = worldIn.func_180495_p(pos.func_177974_f()).func_177230_c();
        if (blockEast instanceof ControllerFertilizedDirt) {
            this.activateNeighbours(worldIn, pos, null, pos.func_177974_f());
            return;
        }
        if (blockEast instanceof ControllerTilledFertilizedDirt) {
            this.activateNeighbours(worldIn, pos, null, pos.func_177978_c());
            return;
        }
        if (blockEast instanceof ControllerSand) {
            this.activateNeighbours(worldIn, pos, null, pos.func_177978_c());
            return;
        }
        if (blockEast instanceof RedstoneTilledFertilizedDirt && (eastTileEntity = (FarmelementTileEntity)(newBlockEast = (RedstoneTilledFertilizedDirt)blockEast).getTileEntity(worldIn, pos.func_177974_f())).isActive() && this.isControllerInRange(worldIn, pos, eastTileEntity.getControllerPos())) {
            this.activateNeighbours(worldIn, pos, null, eastTileEntity.getControllerPos());
            return;
        }
        if (blockEast instanceof RedstoneFertilizedDirt && (eastTileEntity = (FarmelementTileEntity)(newBlockEast = (RedstoneFertilizedDirt)blockEast).getTileEntity(worldIn, pos.func_177974_f())).isActive() && this.isControllerInRange(worldIn, pos, eastTileEntity.getControllerPos())) {
            this.activateNeighbours(worldIn, pos, null, eastTileEntity.getControllerPos());
            return;
        }
        if (blockEast instanceof RedstoneFertilizedSand && (eastTileEntity = (FarmelementTileEntity)(newBlockEast = (RedstoneFertilizedSand)blockEast).getTileEntity(worldIn, pos.func_177974_f())).isActive() && this.isControllerInRange(worldIn, pos, eastTileEntity.getControllerPos())) {
            this.activateNeighbours(worldIn, pos, null, eastTileEntity.getControllerPos());
            return;
        }
        Block blockSouth = worldIn.func_180495_p(pos.func_177968_d()).func_177230_c();
        if (blockSouth instanceof ControllerFertilizedDirt) {
            this.activateNeighbours(worldIn, pos, null, pos.func_177968_d());
            return;
        }
        if (blockSouth instanceof ControllerTilledFertilizedDirt) {
            this.activateNeighbours(worldIn, pos, null, pos.func_177978_c());
            return;
        }
        if (blockSouth instanceof ControllerSand) {
            this.activateNeighbours(worldIn, pos, null, pos.func_177978_c());
            return;
        }
        if (blockSouth instanceof RedstoneTilledFertilizedDirt && (southTileEntity = (FarmelementTileEntity)(newBlockSouth = (RedstoneTilledFertilizedDirt)blockSouth).getTileEntity(worldIn, pos.func_177968_d())).isActive() && this.isControllerInRange(worldIn, pos, southTileEntity.getControllerPos())) {
            this.activateNeighbours(worldIn, pos, null, southTileEntity.getControllerPos());
            return;
        }
        if (blockSouth instanceof RedstoneFertilizedDirt && (southTileEntity = (FarmelementTileEntity)(newBlockSouth = (RedstoneFertilizedDirt)blockSouth).getTileEntity(worldIn, pos.func_177968_d())).isActive() && this.isControllerInRange(worldIn, pos, southTileEntity.getControllerPos())) {
            this.activateNeighbours(worldIn, pos, null, southTileEntity.getControllerPos());
            return;
        }
        if (blockSouth instanceof RedstoneFertilizedSand && (southTileEntity = (FarmelementTileEntity)(newBlockSouth = (RedstoneFertilizedSand)blockSouth).getTileEntity(worldIn, pos.func_177968_d())).isActive() && this.isControllerInRange(worldIn, pos, southTileEntity.getControllerPos())) {
            this.activateNeighbours(worldIn, pos, null, southTileEntity.getControllerPos());
            return;
        }
        Block blockWest = worldIn.func_180495_p(pos.func_177976_e()).func_177230_c();
        if (blockWest instanceof ControllerFertilizedDirt) {
            this.activateNeighbours(worldIn, pos, null, pos.func_177976_e());
            return;
        }
        if (blockWest instanceof ControllerTilledFertilizedDirt) {
            this.activateNeighbours(worldIn, pos, null, pos.func_177978_c());
            return;
        }
        if (blockWest instanceof ControllerSand) {
            this.activateNeighbours(worldIn, pos, null, pos.func_177978_c());
            return;
        }
        if (blockWest instanceof RedstoneTilledFertilizedDirt && (westTileEntity = (FarmelementTileEntity)(newBlockWest = (RedstoneTilledFertilizedDirt)blockWest).getTileEntity(worldIn, pos.func_177976_e())).isActive() && this.isControllerInRange(worldIn, pos, westTileEntity.getControllerPos())) {
            this.activateNeighbours(worldIn, pos, null, westTileEntity.getControllerPos());
            return;
        }
        if (blockWest instanceof RedstoneFertilizedDirt && (westTileEntity = (FarmelementTileEntity)(newBlockWest = (RedstoneFertilizedDirt)blockWest).getTileEntity(worldIn, pos.func_177976_e())).isActive() && this.isControllerInRange(worldIn, pos, westTileEntity.getControllerPos())) {
            this.activateNeighbours(worldIn, pos, null, westTileEntity.getControllerPos());
            return;
        }
        if (blockWest instanceof RedstoneFertilizedSand && (westTileEntity = (FarmelementTileEntity)(newBlockWest = (RedstoneFertilizedSand)blockWest).getTileEntity(worldIn, pos.func_177976_e())).isActive() && this.isControllerInRange(worldIn, pos, westTileEntity.getControllerPos())) {
            this.activateNeighbours(worldIn, pos, null, westTileEntity.getControllerPos());
            return;
        }
    }

    public boolean isNeighbourActivable(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.redstoneTilledFertilizedDirt) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.redstoneFertilizedDirt) {
            return true;
        }
        return worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.redstoneFertilizedSand;
    }

    public boolean isNeighbourDeactivable(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.activeRedstoneTilledFertilizedDirt) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.activeRedstoneFertilizedDirt) {
            return true;
        }
        return worldIn.func_180495_p(pos).func_177230_c() == ModBlocks.activeRedstoneFertilizedSand;
    }

    public boolean isControllerInRange(World worldIn, BlockPos blockPos, BlockPos controllerPos) {
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)blockPos.func_177982_a(-4, 0, -4), (BlockPos)blockPos.func_177982_a(4, 1, 4))) {
            if (blockpos.func_177958_n() != controllerPos.func_177958_n() || blockpos.func_177956_o() != controllerPos.func_177956_o() || blockpos.func_177952_p() != controllerPos.func_177952_p()) continue;
            return true;
        }
        return false;
    }

    public boolean isEquivalentBlockPos(BlockPos pos1, BlockPos pos2) {
        if (pos1 != null && pos2 != null) {
            return pos1.func_177958_n() == pos2.func_177958_n() && pos1.func_177956_o() == pos2.func_177956_o() && pos1.func_177952_p() == pos2.func_177952_p();
        }
        return false;
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        this.getsDestroyed = true;
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.getsDestroyed = true;
    }
}

