/*
 * Decompiled with CFR 0.152.
 */
package net.dylanvhs.bountiful_critters.block;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.dylanvhs.bountiful_critters.block.custom.RoastedPillbugBlock;
import net.dylanvhs.bountiful_critters.block.custom.SaltLampBlock;
import net.dylanvhs.bountiful_critters.block.custom.SeagrassBallBlock;
import net.dylanvhs.bountiful_critters.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"bountiful_critters");
    public static final RegistryObject<Block> ROASTED_PILLBUG_BLOCK = ModBlocks.registerBlock("roasted_pillbug_block", () -> new RoastedPillbugBlock(BlockBehaviour.Properties.m_284310_().m_280606_().m_60978_(0.5f).m_60918_(SoundType.f_56745_).m_278166_(PushReaction.DESTROY).m_60955_()));
    public static final RegistryObject<Block> SALT_LAMP = ModBlocks.registerBlock("salt_lamp", () -> new SaltLampBlock(BlockBehaviour.Properties.m_284310_().m_60953_(ModBlocks.litBlockEmission(15)).m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60922_(ModBlocks::always)));
    public static final RegistryObject<Block> SEAGRASS_BALL_BLOCK = ModBlocks.registerBlock("seagrass_ball_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_60918_(SoundType.f_56752_)));
    public static final RegistryObject<Block> SEAGRASS_BALL_PLACED = ModBlocks.registerBlock("seagrass_ball_placed", () -> new SeagrassBallBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.2f).m_60918_(SoundType.f_56752_).m_280170_().m_60910_().m_60955_()));

    public static <B extends Block> RegistryObject<B> registerBlock(String name, Supplier<? extends B> supplier) {
        RegistryObject block = BLOCKS.register(name, supplier);
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    private static <T extends Block> Supplier<T> create(String key, Supplier<T> block, Function<Supplier<T>, Item> item) {
        Supplier entry = ModBlocks.create(key, block);
        ModItems.ITEMS.register(key, () -> (Item)item.apply(entry));
        return entry;
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithoutBlockItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> Supplier<T> create(String key, Supplier<T> block, CreativeModeTab tab) {
        return ModBlocks.create(key, block, (Supplier<T> entry) -> new BlockItem((Block)entry.get(), new Item.Properties()));
    }

    private static <T extends Block> Supplier<T> create(String key, Supplier<T> block) {
        return BLOCKS.register(key, block);
    }

    private static ToIntFunction<BlockState> litBlockEmission(int pLightValue) {
        return p_50763_ -> (Boolean)p_50763_.m_61143_((Property)BlockStateProperties.f_61443_) != false ? pLightValue : 0;
    }

    private static Boolean never(BlockState p_50779_, BlockGetter p_50780_, BlockPos p_50781_, EntityType<?> p_50782_) {
        return false;
    }

    private static Boolean always(BlockState p_50810_, BlockGetter p_50811_, BlockPos p_50812_, EntityType<?> p_50813_) {
        return true;
    }
}

