/*
 * Decompiled with CFR 0.152.
 */
package net.dylanvhs.bountiful_critters.entity.ai;

import net.dylanvhs.bountiful_critters.entity.custom.HumpbackWhaleEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class HumpbackWhaleJumpGoal
extends JumpGoal {
    private static final int[] STEPS_TO_CHECK = new int[]{0, 1, 4, 5, 6, 7};
    private final HumpbackWhaleEntity liopleurodon;
    private final int interval;
    private boolean breached;

    public HumpbackWhaleJumpGoal(HumpbackWhaleEntity pLiopleurodon, int pInterval) {
        this.liopleurodon = pLiopleurodon;
        this.interval = HumpbackWhaleJumpGoal.m_186073_((int)pInterval);
    }

    public boolean m_8036_() {
        if (this.liopleurodon.m_217043_().m_188503_(this.interval) != 0) {
            return false;
        }
        Direction direction = this.liopleurodon.m_6374_();
        int i = direction.m_122429_();
        int j = direction.m_122431_();
        BlockPos blockpos = this.liopleurodon.m_20183_();
        for (int k : STEPS_TO_CHECK) {
            if (this.waterIsClear(blockpos, i, j, k) && this.surfaceIsClear(blockpos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    private boolean waterIsClear(BlockPos pPos, int pDx, int pDz, int pScale) {
        BlockPos blockpos = pPos.m_7918_(pDx * pScale, 0, pDz * pScale);
        return this.liopleurodon.m_9236_().m_6425_(blockpos).m_205070_(FluidTags.f_13131_) && !this.liopleurodon.m_9236_().m_8055_(blockpos).m_280555_();
    }

    private boolean surfaceIsClear(BlockPos pPos, int pDx, int pDz, int pScale) {
        return this.liopleurodon.m_9236_().m_8055_(pPos.m_7918_(pDx * pScale, 1, pDz * pScale)).m_60795_() && this.liopleurodon.m_9236_().m_8055_(pPos.m_7918_(pDx * pScale, 2, pDz * pScale)).m_60795_();
    }

    public boolean m_8045_() {
        double d0 = this.liopleurodon.m_20184_().f_82480_;
        return !(d0 * d0 < (double)0.1f && this.liopleurodon.m_146909_() != 0.0f && Math.abs(this.liopleurodon.m_146909_()) < 10.0f && this.liopleurodon.m_20069_() || this.liopleurodon.m_20096_());
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean isJumping() {
        return true;
    }

    public void m_8056_() {
        Direction direction = this.liopleurodon.m_6374_();
        this.liopleurodon.m_20256_(this.liopleurodon.m_20184_().m_82520_((double)direction.m_122429_() * 0.6, 1.0, (double)direction.m_122431_() * 0.6));
        this.liopleurodon.m_21573_().m_26573_();
        this.liopleurodon.m_6858_(true);
    }

    public void m_8041_() {
        this.liopleurodon.m_146926_(0.0f);
        this.liopleurodon.m_6858_(false);
    }

    public void m_8037_() {
        boolean flag = this.breached;
        if (!flag) {
            FluidState fluidstate = this.liopleurodon.m_9236_().m_6425_(this.liopleurodon.m_20183_());
            this.breached = fluidstate.m_205070_(FluidTags.f_13131_);
        }
        if (this.breached && !flag) {
            this.liopleurodon.m_5496_(SoundEvents.f_11805_, 1.0f, 1.0f);
        }
        Vec3 vec3 = this.liopleurodon.m_20184_();
        if (vec3.f_82480_ * vec3.f_82480_ < (double)0.1f && this.liopleurodon.m_146909_() != 0.0f) {
            this.liopleurodon.m_146926_(Mth.m_14189_((float)0.2f, (float)this.liopleurodon.m_146909_(), (float)0.0f));
        } else if (vec3.m_82553_() > (double)1.0E-5f) {
            double d0 = vec3.m_165924_();
            double d1 = Math.atan2(-vec3.f_82480_, d0) * 57.2957763671875;
            this.liopleurodon.m_146926_((float)d1);
        }
    }
}

