/*
 * Decompiled with CFR 0.152.
 */
package net.dylanvhs.bountiful_critters.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.dylanvhs.bountiful_critters.entity.ModEntities;
import net.dylanvhs.bountiful_critters.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class LonghornEntity
extends TamableAnimal
implements NeutralMob,
GeoAnimatable {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final Ingredient TEMPTATION_ITEM = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41864_});
    private static final EntityDataAccessor<Boolean> DATA_HAS_LEFT_HORN = SynchedEntityData.m_135353_(LonghornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_HAS_RIGHT_HORN = SynchedEntityData.m_135353_(LonghornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int stunnedTick;
    private boolean canBePushed = true;
    private UUID persistentAngerTarget;
    private static final float START_HEALTH = 25.0f;
    private static final float TAME_HEALTH = 35.0f;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(LonghornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CHARGE_COOLDOWN_TICKS = SynchedEntityData.m_135353_(LonghornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_TARGET = SynchedEntityData.m_135353_(LonghornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public LonghornEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return LonghornEntity.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_(Attributes.f_22278_, 0.1).m_22265_();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ModItems.LONGHORN_SPAWN_EGG.get());
    }

    @Nullable
    public LonghornEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        UUID uuid;
        LonghornEntity longhorn = (LonghornEntity)((EntityType)ModEntities.LONGHORN.get()).m_20615_((Level)pLevel);
        if (longhorn != null && (uuid = this.m_21805_()) != null) {
            longhorn.m_21816_(uuid);
            longhorn.m_7105_(true);
        }
        return longhorn;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.8f;
    }

    public boolean m_6898_(ItemStack pStack) {
        return TEMPTATION_ITEM.test(pStack);
    }

    public static <T extends Mob> boolean canSpawn(EntityType type, LevelAccessor worldIn, MobSpawnType reason, BlockPos p_223317_3_, RandomSource random) {
        BlockState blockstate = worldIn.m_8055_(p_223317_3_.m_7495_());
        return blockstate.m_60713_(Blocks.f_50440_);
    }

    public boolean m_6094_() {
        return this.canBePushed;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11830_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11832_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11831_;
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, TEMPTATION_ITEM, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(7, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new LongHornPrepareChargeGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LongHornChargeGoal(this, 2.5));
    }

    public void m_7105_(boolean pTamed) {
        super.m_7105_(pTamed);
        if (pTamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(35.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(25.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(8.0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("StunTick", this.stunnedTick);
        compound.m_128379_("HasLeftHorn", this.hasLeftHorn());
        compound.m_128379_("HasRightHorn", this.hasRightHorn());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.stunnedTick = compound.m_128451_("StunTick");
        this.f_19804_.m_135381_(DATA_HAS_LEFT_HORN, (Object)compound.m_128471_("HasLeftHorn"));
        this.f_19804_.m_135381_(DATA_HAS_RIGHT_HORN, (Object)compound.m_128471_("HasRightHorn"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGE_COOLDOWN_TICKS, (Object)0);
        this.f_19804_.m_135372_(HAS_TARGET, (Object)false);
        this.f_19804_.m_135372_(DATA_HAS_LEFT_HORN, (Object)true);
        this.f_19804_.m_135372_(DATA_HAS_RIGHT_HORN, (Object)true);
    }

    public boolean hasLeftHorn() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HAS_LEFT_HORN);
    }

    public boolean hasRightHorn() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HAS_RIGHT_HORN);
    }

    public boolean m_7327_(Entity target) {
        if (this.m_6162_()) {
            return false;
        }
        boolean shouldHurt = true;
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        float knockback = (float)this.m_21133_(Attributes.f_22282_);
        if (shouldHurt == target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage)) {
            if (knockback > 0.0f && target instanceof LivingEntity) {
                ((LivingEntity)target).m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_((LivingEntity)this, target);
            this.m_21335_(target);
        }
        return shouldHurt;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public boolean m_21674_(LivingEntity p_21675_) {
        return this.m_6779_(p_21675_);
    }

    protected void m_30232_() {
        if (this.m_6162_()) {
            this.m_21051_(Attributes.f_22281_).m_22100_(1.0);
            this.removeHorns();
        } else {
            this.m_21051_(Attributes.f_22281_).m_22100_(8.0);
            this.addHorns();
        }
    }

    public boolean m_6779_(LivingEntity entity) {
        boolean prev = super.m_6779_(entity);
        if (this.m_6162_()) {
            return false;
        }
        if (!this.hasRightHorn() && !this.hasLeftHorn()) {
            return false;
        }
        return prev;
    }

    protected boolean hasTargets() {
        return true;
    }

    private void attack(LivingEntity entity) {
        entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
    }

    public void setChargeCooldownTicks(int ticks) {
        this.f_19804_.m_135381_(CHARGE_COOLDOWN_TICKS, (Object)ticks);
    }

    public int getChargeCooldownTicks() {
        return (Integer)this.f_19804_.m_135370_(CHARGE_COOLDOWN_TICKS);
    }

    public boolean hasChargeCooldown() {
        return (Integer)this.f_19804_.m_135370_(CHARGE_COOLDOWN_TICKS) > 0;
    }

    public void resetChargeCooldownTicks() {
        this.f_19804_.m_135381_(CHARGE_COOLDOWN_TICKS, (Object)40);
    }

    public void setHasTarget(boolean hasTarget) {
        this.f_19804_.m_135381_(HAS_TARGET, (Object)hasTarget);
    }

    public boolean hasTarget() {
        return (Boolean)this.f_19804_.m_135370_(HAS_TARGET);
    }

    public boolean m_7307_(Entity entityIn) {
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_269323_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return entityIn.m_7306_((Entity)this);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_6084_()) {
            return;
        }
        this.m_21051_(Attributes.f_22279_).m_22100_(this.m_6107_() ? 0.0 : 0.2);
        if (this.stunnedTick > 0) {
            --this.stunnedTick;
            this.stunEffect();
            if (this.f_19796_.m_188501_() <= 0.02f && this.f_19796_.m_188501_() < 0.02f) {
                this.dropHorn();
            }
        }
    }

    public boolean dropHorn() {
        boolean flag = this.hasLeftHorn();
        boolean flag1 = this.hasRightHorn();
        if (!flag && !flag1) {
            return false;
        }
        EntityDataAccessor<Boolean> entitydataaccessor = !flag ? DATA_HAS_RIGHT_HORN : (!flag1 ? DATA_HAS_LEFT_HORN : (this.f_19796_.m_188499_() ? DATA_HAS_LEFT_HORN : DATA_HAS_RIGHT_HORN));
        this.f_19804_.m_135381_(entitydataaccessor, (Object)false);
        Vec3 vec3 = this.m_20182_();
        ItemStack itemstack = new ItemStack((ItemLike)ModItems.LONGHORN_HORN.get());
        double d0 = Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.2f, (float)0.2f);
        double d1 = Mth.m_216283_((RandomSource)this.f_19796_, (float)0.3f, (float)0.7f);
        double d2 = Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.2f, (float)0.2f);
        ItemEntity itementity = new ItemEntity(this.m_9236_(), vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), itemstack, d0, d1, d2);
        this.m_9236_().m_7967_((Entity)itementity);
        return true;
    }

    public void addHorns() {
        this.f_19804_.m_135381_(DATA_HAS_LEFT_HORN, (Object)true);
        this.f_19804_.m_135381_(DATA_HAS_RIGHT_HORN, (Object)true);
    }

    public void removeHorns() {
        this.f_19804_.m_135381_(DATA_HAS_LEFT_HORN, (Object)false);
        this.f_19804_.m_135381_(DATA_HAS_RIGHT_HORN, (Object)false);
    }

    private void stunEffect() {
        if (this.f_19796_.m_188503_(6) == 0) {
            double d = this.m_20185_() - (double)this.m_20205_() * Math.sin(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            double e = this.m_20186_() + (double)this.m_20206_() - 0.3;
            double f = this.m_20189_() + (double)this.m_20205_() * Math.cos(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123797_, true, this.m_20185_(), this.m_20188_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.stunnedTick > 0;
    }

    protected void m_6731_(LivingEntity defender) {
        this.stunnedTick = 60;
        this.resetChargeCooldownTicks();
        this.m_21573_().m_26573_();
        this.m_5496_(SoundEvents.f_12362_, 1.0f, 1.0f);
        this.m_9236_().m_7605_((Entity)this, (byte)39);
        defender.m_7334_((Entity)this);
        defender.f_19864_ = true;
    }

    public void performAttack() {
        if (!this.m_9236_().f_46443_) {
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
            for (Entity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(4.0))) {
                if (entity instanceof LonghornEntity || entity instanceof Player || !this.m_21824_() || !this.m_217005_()) continue;
                entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 10.0f);
            }
            this.m_21051_(Attributes.f_22279_).m_22100_((double)0.23f);
        }
    }

    public boolean m_7757_(LivingEntity pTarget, LivingEntity pOwner) {
        if (!(pTarget instanceof Creeper) && !(pTarget instanceof Ghast)) {
            if (pTarget instanceof LonghornEntity) {
                LonghornEntity wolf = (LonghornEntity)pTarget;
                return !wolf.m_21824_() || wolf.m_269323_() != pOwner;
            }
            if (pTarget instanceof Player && pOwner instanceof Player && !((Player)pOwner).m_7099_((Player)pTarget)) {
                return false;
            }
            if (pTarget instanceof AbstractHorse && ((AbstractHorse)pTarget).m_30614_()) {
                return false;
            }
            return !(pTarget instanceof TamableAnimal) || !((TamableAnimal)pTarget).m_21824_();
        }
        return false;
    }

    public void m_7822_(byte id) {
        if (id == 39) {
            this.stunnedTick = 60;
        }
        super.m_7822_(id);
    }

    private boolean isWithinYRange(LivingEntity target) {
        if (target == null) {
            return false;
        }
        return Math.abs(target.m_20186_() - this.m_20186_()) < 3.0;
    }

    public boolean m_6573_(Player pPlayer) {
        return true;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (itemstack.m_150930_(Items.f_42446_) && !this.m_6162_()) {
            pPlayer.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)pPlayer, (ItemStack)Items.f_42455_.m_7968_());
            pPlayer.m_21008_(pHand, itemstack1);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)pPlayer) || this.m_21824_() || itemstack.m_150930_(Items.f_41864_) && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.m_6071_(pPlayer, pHand);
            if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)pPlayer)) {
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (itemstack.m_150930_(Items.f_41864_) && this.stunnedTick > 0) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                this.m_21828_(pPlayer);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (this.stunnedTick > 0) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.long_horn.stunned", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (geoAnimatableAnimationState.isMoving()) {
            if (this.m_20142_()) {
                geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.long_horn.charge", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.long_horn.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.hasChargeCooldown() && this.hasTarget()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.long_horn.prep", Animation.LoopType.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.long_horn.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    static class LongHornPrepareChargeGoal
    extends Goal {
        protected final LonghornEntity longhorn;

        public LongHornPrepareChargeGoal(LonghornEntity longhorn) {
            this.longhorn = longhorn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.longhorn.m_5448_();
            if (target == null || !target.m_6084_() || this.longhorn.stunnedTick > 0 || !this.longhorn.isWithinYRange(target) || this.longhorn.m_6162_()) {
                this.longhorn.resetChargeCooldownTicks();
                return false;
            }
            return target instanceof Player && this.longhorn.hasChargeCooldown();
        }

        public void m_8056_() {
            LivingEntity target = this.longhorn.m_5448_();
            if (target == null) {
                return;
            }
            this.longhorn.setHasTarget(true);
            this.longhorn.resetChargeCooldownTicks();
            this.longhorn.canBePushed = false;
        }

        public void m_8041_() {
            this.longhorn.setHasTarget(false);
            this.longhorn.canBePushed = true;
        }

        public void m_8037_() {
            LivingEntity target = this.longhorn.m_5448_();
            if (target == null) {
                return;
            }
            this.longhorn.m_21563_().m_148051_((Entity)target);
            this.longhorn.setChargeCooldownTicks(Math.max(0, this.longhorn.getChargeCooldownTicks() - 1));
        }
    }

    static class LongHornChargeGoal
    extends Goal {
        protected final LonghornEntity mob;
        private final double speedModifier;
        private Path path;
        private Vec3 chargeDirection;

        public LongHornChargeGoal(LonghornEntity pathfinderMob, double speedModifier) {
            this.mob = pathfinderMob;
            this.speedModifier = speedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.chargeDirection = Vec3.f_82478_;
        }

        public boolean m_8036_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null || !target.m_6084_() || this.mob.hasChargeCooldown() || this.mob.stunnedTick > 0 || this.mob.m_6162_()) {
                return false;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)target, 0);
            return target instanceof Player && this.path != null;
        }

        public boolean m_8045_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null || !target.m_6084_() || this.mob.hasChargeCooldown() || this.mob.stunnedTick > 0) {
                return false;
            }
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            BlockPos blockPosition = this.mob.m_20183_();
            BlockPos target = this.path.m_77406_();
            this.chargeDirection = new Vec3((double)(blockPosition.m_123341_() - target.m_123341_()), 0.0, (double)(blockPosition.m_123343_() - target.m_123343_())).m_82541_();
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
            this.mob.m_6858_(true);
        }

        public void m_8041_() {
            this.mob.resetChargeCooldownTicks();
            this.mob.m_21573_().m_26573_();
            this.mob.m_6858_(false);
        }

        public void m_8037_() {
            this.mob.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)this.path.m_77406_()));
            if (this.mob.f_19862_ && this.mob.m_20096_()) {
                this.mob.m_6135_();
            }
            this.tryToHurt();
        }

        protected void tryToHurt() {
            LivingEntity livingEntity;
            List nearbyEntities = this.mob.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_(), (LivingEntity)this.mob, this.mob.m_20191_());
            if (!nearbyEntities.isEmpty() && !((livingEntity = (LivingEntity)nearbyEntities.get(0)) instanceof LonghornEntity)) {
                livingEntity.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_));
                float speed = Mth.m_14036_((float)(this.mob.m_6113_() * 1.65f), (float)0.2f, (float)3.0f);
                float shieldBlockModifier = livingEntity.m_21275_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob)) ? 0.5f : 1.0f;
                livingEntity.m_147240_((double)(shieldBlockModifier * speed) * 2.0, this.chargeDirection.m_7096_(), this.chargeDirection.m_7094_());
                double knockbackResistance = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                livingEntity.m_20256_(livingEntity.m_20184_().m_82520_(0.0, (double)0.4f * knockbackResistance, 0.0));
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                if (livingEntity.equals((Object)this.mob.m_5448_())) {
                    this.m_8041_();
                }
            }
        }
    }
}

