/*
 * Decompiled with CFR 0.152.
 */
package net.dylanvhs.bountiful_critters.entity.custom;

import java.util.List;
import net.dylanvhs.bountiful_critters.entity.ModEntities;
import net.dylanvhs.bountiful_critters.entity.custom.BluntHeadedTreeSnakeEntity;
import net.dylanvhs.bountiful_critters.entity.custom.GeckoEntity;
import net.dylanvhs.bountiful_critters.item.ModItems;
import net.dylanvhs.bountiful_critters.sounds.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class PillbugEntity
extends Animal
implements GeoEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(PillbugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final float SPIDER_SPECIAL_EFFECT_CHANCE = 0.1f;
    private static final EntityDataAccessor<Boolean> IS_ROLLED_UP = SynchedEntityData.m_135353_(PillbugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_POISONOUS = SynchedEntityData.m_135353_(PillbugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean canBePushed = true;

    public PillbugEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public boolean isBasketball() {
        String n = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        return n != null && n.toLowerCase().contains("basketball");
    }

    public static <T extends Mob> boolean canSpawn(EntityType type, LevelAccessor worldIn, MobSpawnType reason, BlockPos p_223317_3_, RandomSource random) {
        BlockState blockstate = worldIn.m_8055_(p_223317_3_.m_7495_());
        return blockstate.m_60713_(Blocks.f_50440_) || blockstate.m_60713_(Blocks.f_50069_) || blockstate.m_60713_(Blocks.f_152550_);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ModItems.PILLBUG_SPAWN_EGG.get());
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new WallClimberNavigation((Mob)this, pLevel);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean pClimbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = pClimbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42583_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.2f, true));
        this.f_21345_.m_25352_(9, (Goal)new AvoidEntityGoal((PathfinderMob)this, Spider.class, 8.0f, 1.2, 1.2));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Husk.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Drowned.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Stray.class, true));
    }

    public static AttributeSupplier setAttributes() {
        return AbstractSchoolingFish.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22285_, 1.0).m_22265_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        this.setRollUp(false);
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_6094_() {
        return this.canBePushed;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42583_);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.PILLBUG_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.PILLBUG_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.PILLBUG_DEATH.get();
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_((SoundEvent)ModSounds.PILLBUG_STEP.get(), 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return (AgeableMob)((EntityType)ModEntities.PILLBUG.get()).m_20615_((Level)world);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() == Items.f_42618_ && this.m_6084_() && !this.m_6162_() && !this.isRolledUp()) {
            this.m_5496_(SoundEvents.f_271339_, 1.0f, 1.0f);
            heldItem.m_41774_(1);
            ItemStack itemstack1 = new ItemStack((ItemLike)ModItems.POTTED_PILLBUG.get());
            this.setBucketData(itemstack1);
            if (!this.m_9236_().f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, itemstack1);
            }
            if (heldItem.m_41619_()) {
                player.m_21008_(hand, itemstack1);
            } else if (!player.m_150109_().m_36054_(itemstack1)) {
                player.m_36176_(itemstack1, false);
            }
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_41619_() && !this.m_6162_() && this.isRolledUp()) {
            ItemStack itemstack2 = new ItemStack((ItemLike)ModItems.PILLBUG_THROWABLE.get());
            player.m_21008_(hand, itemstack2);
            this.setBucketData(itemstack2);
            this.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void setBucketData(ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ROLLED_UP, (Object)false);
        this.f_19804_.m_135372_(IS_POISONOUS, (Object)false);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public boolean isRolledUp() {
        return (Boolean)this.f_19804_.m_135370_(IS_ROLLED_UP);
    }

    public void setRollUp(boolean rollUp) {
        this.f_19804_.m_135381_(IS_ROLLED_UP, (Object)rollUp);
    }

    public boolean isPoisonous() {
        return (Boolean)this.f_19804_.m_135370_(IS_POISONOUS);
    }

    public void setPoisonous(boolean poisonous) {
        this.f_19804_.m_135381_(IS_POISONOUS, (Object)poisonous);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isRolledUp();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            this.m_21051_(Attributes.f_22279_).m_22100_(this.m_6107_() ? 0.0 : 0.2);
            this.m_21051_(Attributes.f_22278_).m_22100_(this.m_6107_() ? 0.6 : 0.0);
        }
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, pEntity);
        }
        return flag;
    }

    protected float m_6118_() {
        return 0.0f;
    }

    public void m_6667_(DamageSource pCause) {
        if (!this.m_6162_()) {
            if (this.m_21023_(MobEffects.f_19614_)) {
                this.m_19998_((ItemLike)ModItems.POISONOUS_PILLBUG.get());
            } else if (this.m_6060_()) {
                this.m_19998_((ItemLike)ModItems.ROASTED_PILLBUG.get());
            } else {
                this.m_19998_((ItemLike)ModItems.RAW_PILLBUG.get());
            }
        }
        this.setRollUp(false);
        super.m_6667_(pCause);
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268612_) || super.m_6673_(source);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_);
            this.setPoisonous(this.m_21023_(MobEffects.f_19614_));
        }
        this.setRollUp(this.isRolledUp());
        List list = this.m_9236_().m_45971_(Player.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82377_(5.0, 2.0, 5.0));
        List list1 = this.m_9236_().m_45971_(BluntHeadedTreeSnakeEntity.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82377_(5.0, 2.0, 5.0));
        List list2 = this.m_9236_().m_45971_(GeckoEntity.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82377_(5.0, 2.0, 5.0));
        if (!(list.isEmpty() && list1.isEmpty() && list2.isEmpty())) {
            if (list.stream().noneMatch(Entity::m_6047_)) {
                this.setRollUp(true);
                this.m_21573_().m_26573_();
            } else {
                this.setRollUp(false);
            }
        } else {
            this.setRollUp(false);
        }
    }

    public boolean m_6779_(LivingEntity entity) {
        boolean prev = super.m_6779_(entity);
        if (this.m_6162_()) {
            return false;
        }
        return prev;
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        RandomSource randomsource = pLevel.m_213780_();
        if (pSpawnData == null) {
            pSpawnData = new PillbugEffectsGroupData();
            if (pLevel.m_46791_() == Difficulty.HARD && randomsource.m_188501_() < 0.1f * pDifficulty.m_19057_()) {
                ((PillbugEffectsGroupData)pSpawnData).setRandomEffect(randomsource);
            }
        }
        if (pSpawnData instanceof PillbugEffectsGroupData) {
            PillbugEffectsGroupData pillbug$pillbugeffectsgroupdata = (PillbugEffectsGroupData)pSpawnData;
            MobEffect mobeffect = pillbug$pillbugeffectsgroupdata.effect;
            if (mobeffect != null) {
                this.m_7292_(new MobEffectInstance(mobeffect, -1));
            }
        }
        return pSpawnData;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (this.isRolledUp() && this.m_20096_()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.pillbug.rolled_up", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isClimbing() && geoAnimatableAnimationState.isMoving()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.pillbug.climb", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isClimbing() && !geoAnimatableAnimationState.isMoving()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.pillbug.climb_idle", Animation.LoopType.LOOP));
            geoAnimatableAnimationState.getController().setAnimationSpeed((double)1.4f);
            return PlayState.CONTINUE;
        }
        if (geoAnimatableAnimationState.isMoving()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.pillbug.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.pillbug.idle", Animation.LoopType.LOOP));
        geoAnimatableAnimationState.getController().setAnimationSpeed((double)1.4f);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    public static class PillbugEffectsGroupData
    implements SpawnGroupData {
        @javax.annotation.Nullable
        public MobEffect effect;

        public void setRandomEffect(RandomSource pRandom) {
            int i = pRandom.m_188503_(2);
            if (i <= 1) {
                this.effect = MobEffects.f_19596_;
            } else if (i <= 2) {
                this.effect = MobEffects.f_19614_;
            }
        }
    }
}

