/*
 * Decompiled with CFR 0.152.
 */
package net.dylanvhs.bountiful_critters.entity.custom;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dylanvhs.bountiful_critters.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class StingrayEntity
extends AbstractFish
implements GeoEntity,
Bucketable {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final Predicate<LivingEntity> SCARY_MOB = p_289442_ -> {
        if (p_289442_ instanceof Player && ((Player)p_289442_).m_7500_()) {
            return false;
        }
        return p_289442_.m_6095_() == EntityType.f_147039_ || p_289442_.m_6336_() != MobType.f_21644_;
    };
    static final TargetingConditions targetingConditions = TargetingConditions.m_148353_().m_26893_().m_148355_().m_26888_(SCARY_MOB);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(StingrayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(StingrayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public StingrayEntity(EntityType<? extends AbstractFish> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public static String getVariantName(int variant) {
        return switch (variant) {
            case 1 -> "muddy";
            case 2 -> "blue_spotted";
            default -> "gray";
        };
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ModItems.STINGRAY_SPAWN_EGG.get());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Nonnull
    public ItemStack m_28282_() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.STINGRAY_BUCKET.get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    public void m_6872_(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("BucketVariantTag", this.getVariant());
    }

    public void m_142278_(@Nonnull CompoundTag compound) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compound);
        if (compound.m_128425_("BucketVariantTag", 3)) {
            this.setVariant(compound.m_128451_("BucketVariantTag"));
        }
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    private void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            for (Mob mob : this.m_9236_().m_6443_(Mob.class, this.m_20191_().m_82400_(0.3), p_149013_ -> targetingConditions.m_26885_((LivingEntity)this, (LivingEntity)p_149013_))) {
                if (!mob.m_6084_()) continue;
                this.touch(mob);
            }
        }
    }

    public void m_6123_(Player pEntity) {
        if (pEntity instanceof ServerPlayer && pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 1.0f)) {
            if (!this.m_20067_()) {
                ((ServerPlayer)pEntity).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132162_, 0.0f));
            }
            pEntity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 60, 0), (Entity)this);
        }
    }

    private void touch(Mob pMob) {
        if (pMob.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 1.0f)) {
            pMob.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 60, 0), (Entity)this);
            this.m_5496_(SoundEvents.f_12295_, 1.0f, 1.0f);
        }
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_203706_1_);
    }

    public static <T extends Mob> boolean canSpawn(EntityType<StingrayEntity> p_223364_0_, LevelAccessor p_223364_1_, MobSpawnType reason, BlockPos p_223364_3_, RandomSource p_223364_4_) {
        return WaterAnimal.m_218282_(p_223364_0_, (LevelAccessor)p_223364_1_, (MobSpawnType)reason, (BlockPos)p_223364_3_, (RandomSource)p_223364_4_);
    }

    @Nonnull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public static AttributeSupplier setAttributes() {
        return AbstractFish.m_21552_().m_22268_(Attributes.f_22276_, 7.0).m_22268_(Attributes.f_22279_, 0.8).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 15){

            public boolean m_8036_() {
                return !this.f_25725_.m_20069_() && super.m_8036_();
            }
        });
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        float variantChange = this.m_217043_().m_188501_();
        Holder holder = worldIn.m_204166_(this.m_20183_());
        if (holder.m_203565_(Biomes.f_48207_)) {
            this.setVariant(1);
        } else if (holder.m_203565_(Biomes.f_220595_)) {
            this.setVariant(1);
        } else if (holder.m_203565_(Biomes.f_48212_)) {
            this.setVariant(1);
        } else if (holder.m_203565_(Biomes.f_48208_)) {
            this.setVariant(1);
        } else if (holder.m_203565_(Biomes.f_48166_)) {
            this.setVariant(2);
        } else if (holder.m_203565_(Biomes.f_48167_)) {
            this.setVariant(2);
        } else if (holder.m_203565_(Biomes.f_48170_)) {
            this.setVariant(2);
        } else {
            this.setVariant(0);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12526_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12527_;
    }

    protected SoundEvent m_7975_(DamageSource p_28281_) {
        return SoundEvents.f_12529_;
    }

    protected SoundEvent m_5699_() {
        return SoundEvents.f_12528_;
    }

    protected PathNavigation m_6037_(Level p_27480_) {
        return new WaterBoundPathNavigation((Mob)this, p_27480_);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (geoAnimatableAnimationState.isMoving()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.stingray.swim", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.stingray.swim", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

