/*
 * Decompiled with CFR 0.152.
 */
package net.dylanvhs.bountiful_critters.item.custom;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dylanvhs.bountiful_critters.entity.ModEntities;
import net.dylanvhs.bountiful_critters.entity.ai.Hookable;
import net.dylanvhs.bountiful_critters.entity.custom.BluntHeadedTreeSnakeEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class HookItem
extends BucketItem {
    private final Supplier<? extends EntityType<?>> entityType;
    private final Item item1;
    private static final ChatFormatting TITLE_FORMAT = ChatFormatting.GRAY;
    private static final ChatFormatting DESCRIPTION_FORMAT = ChatFormatting.BLUE;
    private static final Component BLUNT_HEADED_TREE_SNAKE = Component.m_237115_((String)Util.m_137492_((String)"snake", (ResourceLocation)new ResourceLocation("bountiful_critters", "blunt_headed_tree_snake"))).m_130940_(TITLE_FORMAT);

    public HookItem(Supplier<EntityType<?>> entityType, Item item, Item.Properties properties) {
        this(entityType, Fluids.f_76191_, item, properties);
    }

    public HookItem(Supplier<EntityType<?>> entityType, Fluid fluid, Item item, Item.Properties properties) {
        super(fluid, properties);
        this.item1 = item;
        this.entityType = entityType;
    }

    private void spawn(ServerLevel pServerLevel, ItemStack pBucketedMobStack, BlockPos pPos) {
        Entity entity = this.getEntityType().m_20592_(pServerLevel, pBucketedMobStack, (Player)null, pPos, MobSpawnType.BUCKET, true, false);
        if (entity instanceof Hookable) {
            Hookable bucketable = (Hookable)entity;
            bucketable.loadFromHookTag(pBucketedMobStack.m_41784_());
            bucketable.setFromHook(true);
        }
    }

    public void m_142131_(@Nullable Player pPlayer, Level pLevel, ItemStack pContainerStack, BlockPos pPos) {
        if (pLevel instanceof ServerLevel) {
            this.spawn((ServerLevel)pLevel, pContainerStack, pPos);
            pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157810_, pPos);
        }
    }

    protected void m_7718_(@Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos) {
        pLevel.m_5594_(pPlayer, pPos, this.getEmptySound(), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        ItemStack heldItem = player.m_21120_(hand);
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState blockstate = world.m_8055_(blockpos);
        if (world.f_46443_) {
            if (this.entityType != null) {
                this.m_7718_(player, (LevelAccessor)world, blockpos);
            }
            return InteractionResult.SUCCESS;
        }
        BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)world, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
        Supplier<EntityType<?>> entitytype = this.entityType;
        Entity entityType = entitytype.get().m_20592_((ServerLevel)world, heldItem, player, blockpos1, MobSpawnType.BUCKET, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
        if (entityType != null) {
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, this.item1.m_7968_());
                }
            }
            if (entityType instanceof Hookable) {
                Hookable bucketable = (Hookable)entityType;
                bucketable.loadFromHookTag(heldItem.m_41784_());
                bucketable.setFromHook(true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        CompoundTag compoundnbt;
        if (this.getEntityType() == ModEntities.BLUNT_HEADED_TREE_SNAKE.get() && (compoundnbt = stack.m_41783_()) != null && compoundnbt.m_128425_("HookVariantTag", 3)) {
            int i = compoundnbt.m_128451_("HookVariantTag");
            tooltip.add(BLUNT_HEADED_TREE_SNAKE);
            String s = "entity.bountiful_critters.blunt_headed_tree_snake.variant_" + BluntHeadedTreeSnakeEntity.getVariantName(i);
            tooltip.add((Component)Component.m_237115_((String)s).m_130940_(DESCRIPTION_FORMAT).m_130940_(ChatFormatting.ITALIC));
        }
    }

    protected EntityType<?> getEntityType() {
        return this.entityType.get();
    }

    protected SoundEvent getEmptySound() {
        return SoundEvents.f_184214_;
    }
}

