/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.jamandjelly.block.entity;

import net.alminoris.jamandjelly.block.custom.JammingPotBlock;
import net.alminoris.jamandjelly.block.entity.ImplementedInventory;
import net.alminoris.jamandjelly.block.entity.ModBlockEntities;
import net.alminoris.jamandjelly.integration.arborealnature.item.IntegrationItems;
import net.alminoris.jamandjelly.item.ModItems;
import net.alminoris.jamandjelly.network.BlockPosPayload;
import net.alminoris.jamandjelly.screen.JammingPotScreenHandler;
import net.alminoris.jamandjelly.sound.ModSounds;
import net.alminoris.jamandjelly.util.helper.RecipeHelper;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class JammingPotBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<BlockPosPayload>,
ImplementedInventory {
    private final class_2371<class_1799> INVENTORY = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    private static final int INPUT_SLOT_0 = 0;
    private static final int INPUT_SLOT_1 = 1;
    private static final int INPUT_SLOT_2 = 2;
    private static final int INPUT_SLOT_3 = 3;
    private static final int INPUT_SLOT_4 = 4;
    private static final int OUTPUT_SLOT = 5;
    protected final class_3913 propertyDelegate;
    private int progress = 0;
    private int maxProgress = 240;
    private int isFlameOn = 0;
    private class_1799 result = null;
    private JammingPotBlock.Inside newInside = JammingPotBlock.Inside.APPLE;
    private int soundMaxTicks = 80;
    private int soundTickCounter = 80;

    public JammingPotBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.JAMMING_POT_BLOCK_ENTITY, pos, state);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> JammingPotBlockEntity.this.progress;
                    case 1 -> JammingPotBlockEntity.this.maxProgress;
                    case 2 -> JammingPotBlockEntity.this.isFlameOn;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        JammingPotBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        JammingPotBlockEntity.this.maxProgress = value;
                        break;
                    }
                    case 2: {
                        JammingPotBlockEntity.this.isFlameOn = value;
                    }
                }
            }

            public int method_17389() {
                return 3;
            }
        };
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.INVENTORY;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.INVENTORY, (class_7225.class_7874)registryLookup);
        nbt.method_10569("jamming_pot.progress", this.progress);
        nbt.method_10569("jamming_pot.isFlameOn", this.isFlameOn);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.INVENTORY, (class_7225.class_7874)registryLookup);
        nbt.method_10550("jamming_pot.progress");
        nbt.method_10550("jamming_pot.isFlameOn");
    }

    public BlockPosPayload getScreenOpeningData(class_3222 serverPlayerEntity) {
        return new BlockPosPayload(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.jamandjelly.jamming_pot");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new JammingPotScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        boolean currentSupport;
        if (world.field_9236) {
            return;
        }
        JammingPotBlock.Variant currentVariant = this.hasLadle() ? JammingPotBlock.Variant.NORMAL : JammingPotBlock.Variant.CLOSED;
        if (this.hasFlame(world, pos)) {
            currentSupport = true;
            this.isFlameOn = 1;
        } else {
            currentSupport = false;
            this.isFlameOn = 0;
        }
        if (this.isOutputSlotEmptyOrReceivable()) {
            RecipeHelper recipeHelper = new RecipeHelper("jamming_pot", this.method_5438(0), this.method_5438(1), this.method_5438(2), this.method_5438(3), this.method_5438(4));
            if (this.hasRecipe(recipeHelper) && this.isFlameOn == 1 && this.hasLadle()) {
                currentVariant = JammingPotBlock.Variant.INSIDED;
                if (this.soundTickCounter == this.soundMaxTicks) {
                    world.method_45447(null, pos, ModSounds.SOUND_JAM_BOILING, class_3419.field_15254);
                    this.soundTickCounter = 0;
                } else {
                    ++this.soundTickCounter;
                }
                this.increaseCraftProgress();
                JammingPotBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (this.hasCraftingFinished()) {
                    currentVariant = JammingPotBlock.Variant.NORMAL;
                    this.craftItem();
                    this.resetProgress();
                }
            } else {
                this.resetProgress();
            }
        } else {
            this.resetProgress();
            JammingPotBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
        world.method_8501(pos, (class_2680)((class_2680)((class_2680)state.method_11657(JammingPotBlock.VARIANT, (Comparable)((Object)currentVariant))).method_11657((class_2769)JammingPotBlock.SUPPORT, (Comparable)Boolean.valueOf(currentSupport))).method_11657(JammingPotBlock.INSIDE, (Comparable)((Object)this.newInside)));
    }

    private boolean hasLadle() {
        return this.method_5438(4).method_7909() == ModItems.LADLE;
    }

    private boolean hasFlame(class_1937 world, class_2338 pos) {
        class_2680 belowState = world.method_8320(pos.method_10074());
        return belowState.method_27852(class_2246.field_17350);
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        this.method_5434(0, 1);
        this.method_5434(1, 1);
        this.method_5434(2, 1);
        this.method_5434(3, 1);
        class_1799 ladleItem = this.method_5438(4);
        if (ladleItem.method_7919() < ladleItem.method_7936() - 1) {
            ladleItem.method_7974(ladleItem.method_7919() + 1);
            this.method_5447(4, ladleItem);
        } else {
            this.method_5434(4, 1);
        }
        this.method_5447(5, new class_1799((class_1935)this.result.method_7909(), this.method_5438(5).method_7947() + this.result.method_7947()));
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftProgress() {
        ++this.progress;
    }

    private boolean hasRecipe(RecipeHelper recipeHelper) {
        boolean hasInputRes;
        if (!recipeHelper.hasInput()) {
            return false;
        }
        this.result = recipeHelper.getResult();
        boolean bl = hasInputRes = recipeHelper.hasInput() && this.canInsertAmountIntoOutputSlot(this.result) && this.canInsertItemIntoOutputSlot(this.result.method_7909());
        if (hasInputRes) {
            if (this.result.method_7909() == ModItems.APPLE_JAM_BOTTLE) {
                this.newInside = JammingPotBlock.Inside.APPLE;
            } else if (this.result.method_7909() == ModItems.SWEETBERRY_JAM_BOTTLE) {
                this.newInside = JammingPotBlock.Inside.SWEETBERRY;
            } else if (this.result.method_7909() == ModItems.MELON_JAM_BOTTLE) {
                this.newInside = JammingPotBlock.Inside.MELON;
            } else if (FabricLoader.getInstance().isModLoaded("arborealnature")) {
                for (String name : IntegrationItems.JAM_NAMES) {
                    if (this.result.method_7909() != IntegrationItems.JAM_BOTTLES.get(name)) continue;
                    this.newInside = JammingPotBlock.Inside.fromString(name);
                    break;
                }
            }
        }
        return hasInputRes;
    }

    private boolean canInsertItemIntoOutputSlot(class_1792 item) {
        return this.method_5438(5).method_7909() == item || this.method_5438(5).method_7960();
    }

    private boolean canInsertAmountIntoOutputSlot(class_1799 result) {
        return this.method_5438(5).method_7947() + result.method_7947() <= this.method_5438(5).method_7914();
    }

    private boolean isOutputSlotEmptyOrReceivable() {
        return this.method_5438(5).method_7960() || this.method_5438(5).method_7947() < this.method_5438(5).method_7914();
    }
}

