/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pigletstructures.network;

import java.util.function.Supplier;
import net.mcreator.pigletstructures.PigletStructuresMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PigletStructuresModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        PigletStructuresMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        PigletStructuresMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.dusty_emerald_value = message.data.dusty_emerald_value;
                    variables.not_mysterious_package_loot_type = message.data.not_mysterious_package_loot_type;
                    variables.not_mysterious_package_loot_quantity = message.data.not_mysterious_package_loot_quantity;
                    variables.kwik_shop_plains_current_choice = message.data.kwik_shop_plains_current_choice;
                    variables.ancient_recall_wand_x = message.data.ancient_recall_wand_x;
                    variables.ancient_recall_wand_y = message.data.ancient_recall_wand_y;
                    variables.ancient_recall_wand_z = message.data.ancient_recall_wand_z;
                    variables.ancient_recall_wand_did_player_sleep_in_overworld = message.data.ancient_recall_wand_did_player_sleep_in_overworld;
                    variables.ancient_recall_wand_overlay = message.data.ancient_recall_wand_overlay;
                    variables.Ancient_recall_wand_final_destination_y = message.data.Ancient_recall_wand_final_destination_y;
                    variables.unpredictable_wand_knowledge = message.data.unpredictable_wand_knowledge;
                    variables.the_enchanted_book_of_minerals_scanning_x = message.data.the_enchanted_book_of_minerals_scanning_x;
                    variables.the_enchanted_book_of_minerals_scanning_y = message.data.the_enchanted_book_of_minerals_scanning_y;
                    variables.the_enchanted_book_of_minerals_scanning_z = message.data.the_enchanted_book_of_minerals_scanning_z;
                    variables.miner_ring_level_of_haste = message.data.miner_ring_level_of_haste;
                    variables.number_of_bloody_berserker_bracelets = message.data.number_of_bloody_berserker_bracelets;
                    variables.number_of_snowy_rings = message.data.number_of_snowy_rings;
                    variables.number_of_frozen_hearts = message.data.number_of_frozen_hearts;
                    variables.number_of_ice_cubed_skulls = message.data.number_of_ice_cubed_skulls;
                    variables.number_of_midnight_moonlight_rings = message.data.number_of_midnight_moonlight_rings;
                    variables.number_of_ribs_bracelets = message.data.number_of_ribs_bracelets;
                    variables.death_locator_did_player_die = message.data.death_locator_did_player_die;
                    variables.death_locator_location_x = message.data.death_locator_location_x;
                    variables.death_locator_location_y = message.data.death_locator_location_y;
                    variables.death_locator_location_z = message.data.death_locator_location_z;
                    variables.death_locator_item_copy_activation = message.data.death_locator_item_copy_activation;
                    variables.suspicious_fossil_loot_type = message.data.suspicious_fossil_loot_type;
                    variables.suspicious_fossil_loot_quantity = message.data.suspicious_fossil_loot_quantity;
                    variables.curio_set_skeleton_fortress = message.data.curio_set_skeleton_fortress;
                    variables.ancient_skeleton_amulets_number = message.data.ancient_skeleton_amulets_number;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double dusty_emerald_value = 0.0;
        public ItemStack not_mysterious_package_loot_type = ItemStack.f_41583_;
        public double not_mysterious_package_loot_quantity = 0.0;
        public double kwik_shop_plains_current_choice = 1.0;
        public double ancient_recall_wand_x = 0.0;
        public double ancient_recall_wand_y = 0.0;
        public double ancient_recall_wand_z = 0.0;
        public boolean ancient_recall_wand_did_player_sleep_in_overworld = false;
        public boolean ancient_recall_wand_overlay = false;
        public double Ancient_recall_wand_final_destination_y = 0.0;
        public double unpredictable_wand_knowledge = 0.0;
        public double the_enchanted_book_of_minerals_scanning_x = 0.0;
        public double the_enchanted_book_of_minerals_scanning_y = 0.0;
        public double the_enchanted_book_of_minerals_scanning_z = 0.0;
        public double miner_ring_level_of_haste = 0.0;
        public double number_of_bloody_berserker_bracelets = 0.0;
        public double number_of_snowy_rings = 0.0;
        public double number_of_frozen_hearts = 0.0;
        public double number_of_ice_cubed_skulls = 0.0;
        public double number_of_midnight_moonlight_rings = 0.0;
        public double number_of_ribs_bracelets = 0.0;
        public boolean death_locator_did_player_die = false;
        public double death_locator_location_x = 0.0;
        public double death_locator_location_y = 0.0;
        public double death_locator_location_z = 0.0;
        public boolean death_locator_item_copy_activation = false;
        public ItemStack suspicious_fossil_loot_type = ItemStack.f_41583_;
        public double suspicious_fossil_loot_quantity = 0.0;
        public double curio_set_skeleton_fortress = 0.0;
        public double ancient_skeleton_amulets_number = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PigletStructuresMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("dusty_emerald_value", this.dusty_emerald_value);
            nbt.m_128365_("not_mysterious_package_loot_type", (Tag)this.not_mysterious_package_loot_type.m_41739_(new CompoundTag()));
            nbt.m_128347_("not_mysterious_package_loot_quantity", this.not_mysterious_package_loot_quantity);
            nbt.m_128347_("kwik_shop_plains_current_choice", this.kwik_shop_plains_current_choice);
            nbt.m_128347_("ancient_recall_wand_x", this.ancient_recall_wand_x);
            nbt.m_128347_("ancient_recall_wand_y", this.ancient_recall_wand_y);
            nbt.m_128347_("ancient_recall_wand_z", this.ancient_recall_wand_z);
            nbt.m_128379_("ancient_recall_wand_did_player_sleep_in_overworld", this.ancient_recall_wand_did_player_sleep_in_overworld);
            nbt.m_128379_("ancient_recall_wand_overlay", this.ancient_recall_wand_overlay);
            nbt.m_128347_("Ancient_recall_wand_final_destination_y", this.Ancient_recall_wand_final_destination_y);
            nbt.m_128347_("unpredictable_wand_knowledge", this.unpredictable_wand_knowledge);
            nbt.m_128347_("the_enchanted_book_of_minerals_scanning_x", this.the_enchanted_book_of_minerals_scanning_x);
            nbt.m_128347_("the_enchanted_book_of_minerals_scanning_y", this.the_enchanted_book_of_minerals_scanning_y);
            nbt.m_128347_("the_enchanted_book_of_minerals_scanning_z", this.the_enchanted_book_of_minerals_scanning_z);
            nbt.m_128347_("miner_ring_level_of_haste", this.miner_ring_level_of_haste);
            nbt.m_128347_("number_of_bloody_berserker_bracelets", this.number_of_bloody_berserker_bracelets);
            nbt.m_128347_("number_of_snowy_rings", this.number_of_snowy_rings);
            nbt.m_128347_("number_of_frozen_hearts", this.number_of_frozen_hearts);
            nbt.m_128347_("number_of_ice_cubed_skulls", this.number_of_ice_cubed_skulls);
            nbt.m_128347_("number_of_midnight_moonlight_rings", this.number_of_midnight_moonlight_rings);
            nbt.m_128347_("number_of_ribs_bracelets", this.number_of_ribs_bracelets);
            nbt.m_128379_("death_locator_did_player_die", this.death_locator_did_player_die);
            nbt.m_128347_("death_locator_location_x", this.death_locator_location_x);
            nbt.m_128347_("death_locator_location_y", this.death_locator_location_y);
            nbt.m_128347_("death_locator_location_z", this.death_locator_location_z);
            nbt.m_128379_("death_locator_item_copy_activation", this.death_locator_item_copy_activation);
            nbt.m_128365_("suspicious_fossil_loot_type", (Tag)this.suspicious_fossil_loot_type.m_41739_(new CompoundTag()));
            nbt.m_128347_("suspicious_fossil_loot_quantity", this.suspicious_fossil_loot_quantity);
            nbt.m_128347_("curio_set_skeleton_fortress", this.curio_set_skeleton_fortress);
            nbt.m_128347_("ancient_skeleton_amulets_number", this.ancient_skeleton_amulets_number);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.dusty_emerald_value = nbt.m_128459_("dusty_emerald_value");
            this.not_mysterious_package_loot_type = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("not_mysterious_package_loot_type"));
            this.not_mysterious_package_loot_quantity = nbt.m_128459_("not_mysterious_package_loot_quantity");
            this.kwik_shop_plains_current_choice = nbt.m_128459_("kwik_shop_plains_current_choice");
            this.ancient_recall_wand_x = nbt.m_128459_("ancient_recall_wand_x");
            this.ancient_recall_wand_y = nbt.m_128459_("ancient_recall_wand_y");
            this.ancient_recall_wand_z = nbt.m_128459_("ancient_recall_wand_z");
            this.ancient_recall_wand_did_player_sleep_in_overworld = nbt.m_128471_("ancient_recall_wand_did_player_sleep_in_overworld");
            this.ancient_recall_wand_overlay = nbt.m_128471_("ancient_recall_wand_overlay");
            this.Ancient_recall_wand_final_destination_y = nbt.m_128459_("Ancient_recall_wand_final_destination_y");
            this.unpredictable_wand_knowledge = nbt.m_128459_("unpredictable_wand_knowledge");
            this.the_enchanted_book_of_minerals_scanning_x = nbt.m_128459_("the_enchanted_book_of_minerals_scanning_x");
            this.the_enchanted_book_of_minerals_scanning_y = nbt.m_128459_("the_enchanted_book_of_minerals_scanning_y");
            this.the_enchanted_book_of_minerals_scanning_z = nbt.m_128459_("the_enchanted_book_of_minerals_scanning_z");
            this.miner_ring_level_of_haste = nbt.m_128459_("miner_ring_level_of_haste");
            this.number_of_bloody_berserker_bracelets = nbt.m_128459_("number_of_bloody_berserker_bracelets");
            this.number_of_snowy_rings = nbt.m_128459_("number_of_snowy_rings");
            this.number_of_frozen_hearts = nbt.m_128459_("number_of_frozen_hearts");
            this.number_of_ice_cubed_skulls = nbt.m_128459_("number_of_ice_cubed_skulls");
            this.number_of_midnight_moonlight_rings = nbt.m_128459_("number_of_midnight_moonlight_rings");
            this.number_of_ribs_bracelets = nbt.m_128459_("number_of_ribs_bracelets");
            this.death_locator_did_player_die = nbt.m_128471_("death_locator_did_player_die");
            this.death_locator_location_x = nbt.m_128459_("death_locator_location_x");
            this.death_locator_location_y = nbt.m_128459_("death_locator_location_y");
            this.death_locator_location_z = nbt.m_128459_("death_locator_location_z");
            this.death_locator_item_copy_activation = nbt.m_128471_("death_locator_item_copy_activation");
            this.suspicious_fossil_loot_type = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("suspicious_fossil_loot_type"));
            this.suspicious_fossil_loot_quantity = nbt.m_128459_("suspicious_fossil_loot_quantity");
            this.curio_set_skeleton_fortress = nbt.m_128459_("curio_set_skeleton_fortress");
            this.ancient_skeleton_amulets_number = nbt.m_128459_("ancient_skeleton_amulets_number");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("piglet_structures", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "piglet_structures_mapvars";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                PigletStructuresMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "piglet_structures_worldvars";
        public double fork_test = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.fork_test = nbt.m_128459_("fork_test");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("fork_test", this.fork_test);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                PigletStructuresMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.dusty_emerald_value = original.dusty_emerald_value;
            clone.not_mysterious_package_loot_type = original.not_mysterious_package_loot_type;
            clone.not_mysterious_package_loot_quantity = original.not_mysterious_package_loot_quantity;
            clone.kwik_shop_plains_current_choice = original.kwik_shop_plains_current_choice;
            clone.ancient_recall_wand_x = original.ancient_recall_wand_x;
            clone.ancient_recall_wand_y = original.ancient_recall_wand_y;
            clone.ancient_recall_wand_z = original.ancient_recall_wand_z;
            clone.ancient_recall_wand_did_player_sleep_in_overworld = original.ancient_recall_wand_did_player_sleep_in_overworld;
            clone.ancient_recall_wand_overlay = original.ancient_recall_wand_overlay;
            clone.Ancient_recall_wand_final_destination_y = original.Ancient_recall_wand_final_destination_y;
            clone.unpredictable_wand_knowledge = original.unpredictable_wand_knowledge;
            clone.the_enchanted_book_of_minerals_scanning_x = original.the_enchanted_book_of_minerals_scanning_x;
            clone.the_enchanted_book_of_minerals_scanning_y = original.the_enchanted_book_of_minerals_scanning_y;
            clone.the_enchanted_book_of_minerals_scanning_z = original.the_enchanted_book_of_minerals_scanning_z;
            clone.miner_ring_level_of_haste = original.miner_ring_level_of_haste;
            clone.number_of_bloody_berserker_bracelets = original.number_of_bloody_berserker_bracelets;
            clone.number_of_snowy_rings = original.number_of_snowy_rings;
            clone.number_of_frozen_hearts = original.number_of_frozen_hearts;
            clone.number_of_ice_cubed_skulls = original.number_of_ice_cubed_skulls;
            clone.number_of_midnight_moonlight_rings = original.number_of_midnight_moonlight_rings;
            clone.number_of_ribs_bracelets = original.number_of_ribs_bracelets;
            clone.death_locator_did_player_die = original.death_locator_did_player_die;
            clone.death_locator_location_x = original.death_locator_location_x;
            clone.death_locator_location_y = original.death_locator_location_y;
            clone.death_locator_location_z = original.death_locator_location_z;
            clone.death_locator_item_copy_activation = original.death_locator_item_copy_activation;
            clone.suspicious_fossil_loot_type = original.suspicious_fossil_loot_type;
            clone.suspicious_fossil_loot_quantity = original.suspicious_fossil_loot_quantity;
            clone.curio_set_skeleton_fortress = original.curio_set_skeleton_fortress;
            clone.ancient_skeleton_amulets_number = original.ancient_skeleton_amulets_number;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    PigletStructuresMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    PigletStructuresMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                PigletStructuresMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

