/*
 * Decompiled with CFR 0.152.
 */
package com.ludwici.carpetvariants;

import com.ludwici.carpetvariants.registry.BlockRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="carpetvariants")
public class CarpetVariantsMod {
    public static final String MODID = "carpetvariants";
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<String, RegistryObject<Block>> replaceMap = new HashMap<String, RegistryObject<Block>>();

    public CarpetVariantsMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::enqueueIMC);
        eventBus.addListener(this::processIMC);
        eventBus.addListener(this::doClientStuff);
        BlockRegistry.BLOCKS.register(eventBus);
        BlockRegistry.ITEMS.register(eventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        replaceMap = new HashMap<String, RegistryObject<Block>>();
        replaceMap.put("white_carpet", BlockRegistry.WHITE_CARPET_VARIANT);
        replaceMap.put("orange_carpet", BlockRegistry.ORANGE_CARPET_VARIANT);
        replaceMap.put("magenta_carpet", BlockRegistry.MAGENTA_CARPET_VARIANT);
        replaceMap.put("light_blue_carpet", BlockRegistry.LIGHT_BLUE_CARPET_VARIANT);
        replaceMap.put("yellow_carpet", BlockRegistry.YELLOW_CARPET_VARIANT);
        replaceMap.put("lime_carpet", BlockRegistry.LIME_CARPET_VARIANT);
        replaceMap.put("pink_carpet", BlockRegistry.PINK_CARPET_VARIANT);
        replaceMap.put("gray_carpet", BlockRegistry.GRAY_CARPET_VARIANT);
        replaceMap.put("light_gray_carpet", BlockRegistry.LIGHT_GRAY_CARPET_VARIANT);
        replaceMap.put("cyan_carpet", BlockRegistry.CYAN_CARPET_VARIANT);
        replaceMap.put("purple_carpet", BlockRegistry.PURPLE_CARPET_VARIANT);
        replaceMap.put("blue_carpet", BlockRegistry.BLUE_CARPET_VARIANT);
        replaceMap.put("brown_carpet", BlockRegistry.BROWN_CARPET_VARIANT);
        replaceMap.put("green_carpet", BlockRegistry.GREEN_CARPET_VARIANT);
        replaceMap.put("red_carpet", BlockRegistry.RED_CARPET_VARIANT);
        replaceMap.put("black_carpet", BlockRegistry.BLACK_CARPET_VARIANT);
    }

    public static Block replace(Block block) {
        String name = Registry.field_212618_g.func_177774_c((Object)block).func_110623_a();
        return (Block)replaceMap.get(name).get();
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MODID, (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
        }
    }
}

