/*
 * Decompiled with CFR 0.152.
 */
package com.ludwici.carpetvariants.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class CarpetVariantBlock
extends CarpetBlock {
    public static final IntegerProperty FACE_COUNT = IntegerProperty.func_177719_a((String)"face_count", (int)0, (int)6);
    public static final BooleanProperty UP = SixWayBlock.field_196496_z;
    public static final BooleanProperty DOWN = SixWayBlock.field_196489_A;
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)SixWayBlock.field_196491_B.entrySet().stream().collect(Util.func_199749_a());
    private static final VoxelShape UP_AABB = Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;
    protected final Item replaceItem;

    public CarpetVariantBlock(Item replaceItem, DyeColor dyeColor, AbstractBlock.Properties pProperties) {
        super(dyeColor, pProperties);
        this.replaceItem = replaceItem;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)UP, (Comparable)Boolean.FALSE)).func_206870_a((Property)DOWN, (Comparable)Boolean.FALSE)).func_206870_a((Property)NORTH, (Comparable)Boolean.FALSE)).func_206870_a((Property)EAST, (Comparable)Boolean.FALSE)).func_206870_a((Property)SOUTH, (Comparable)Boolean.FALSE)).func_206870_a((Property)WEST, (Comparable)Boolean.FALSE)).func_206870_a((Property)FACE_COUNT, (Comparable)Integer.valueOf(0)));
        this.shapesCache = ImmutableMap.copyOf(this.field_176227_L.func_177619_a().stream().collect(Collectors.toMap(Function.identity(), CarpetVariantBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState pState) {
        VoxelShape voxelshape = VoxelShapes.func_197880_a();
        if (((Boolean)pState.func_177229_b((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)pState.func_177229_b((Property)DOWN)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)DOWN_AABB);
        }
        if (((Boolean)pState.func_177229_b((Property)NORTH)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)pState.func_177229_b((Property)SOUTH)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)pState.func_177229_b((Property)EAST)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)pState.func_177229_b((Property)WEST)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.func_197766_b() ? VoxelShapes.func_197868_b() : voxelshape;
    }

    public VoxelShape func_220053_a(BlockState pState, IBlockReader pLevel, BlockPos pPos, ISelectionContext pContext) {
        return this.shapesCache.get(pState);
    }

    private static boolean canAttachTo(IWorldReader blockGetter, Direction direction, BlockPos blockPos, BlockState blockState) {
        return Block.func_208061_a((VoxelShape)blockState.func_196951_e((IBlockReader)blockGetter, blockPos), (Direction)direction.func_176734_d());
    }

    public static boolean isAcceptableNeighbour(IWorldReader pBlockReader, BlockPos pNeighborPos, Direction pAttachedFace) {
        return CarpetVariantBlock.canAttachTo(pBlockReader, pAttachedFace, pNeighborPos, pBlockReader.func_180495_p(pNeighborPos));
    }

    public static BooleanProperty getPropertyForFace(Direction pFace) {
        return PROPERTY_BY_DIRECTION.get(pFace);
    }

    private boolean canSupportAtFace(IWorldReader pLevel, BlockPos pPos, Direction pDirection) {
        BlockPos blockpos = pPos.func_177972_a(pDirection);
        if (CarpetVariantBlock.isAcceptableNeighbour(pLevel, blockpos, pDirection)) {
            return true;
        }
        BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(pDirection);
        BlockState blockstate = pLevel.func_180495_p(pPos.func_177984_a());
        return blockstate.func_203425_a((Block)this) && (Boolean)blockstate.func_177229_b((Property)booleanproperty) != false;
    }

    public boolean func_196253_a(BlockState pState, BlockItemUseContext pUseContext) {
        BlockState blockstate = pUseContext.func_195991_k().func_180495_p(pUseContext.func_195995_a());
        boolean hasParts = false;
        ItemStack itemStack = pUseContext.func_195996_i();
        boolean same = itemStack.func_77973_b() == this.func_199767_j() || itemStack.func_77973_b() == this.replaceItem;
        for (Direction direction : pUseContext.func_196009_e()) {
            BooleanProperty booleanproperty = CarpetVariantBlock.getPropertyForFace(direction);
            boolean flag1 = (Boolean)blockstate.func_177229_b((Property)booleanproperty);
            if (flag1 || !same || !this.canSupportAtFace((IWorldReader)pUseContext.func_195991_k(), pUseContext.func_195995_a(), direction)) continue;
            hasParts = true;
            break;
        }
        int faces = this.countFaces(blockstate);
        if (same && pUseContext.func_196012_c() && pUseContext.func_196000_l() == Direction.UP && !hasParts) {
            return false;
        }
        return blockstate.func_203425_a((Block)this) && same && faces < PROPERTY_BY_DIRECTION.size();
    }

    private BlockState getUpdatedState(BlockState pState, IWorldReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.func_177984_a();
        BlockState blockstate = null;
        int count = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty = CarpetVariantBlock.getPropertyForFace(direction);
            if (!((Boolean)pState.func_177229_b((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = this.canSupportAtFace(pLevel, pPos, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = pLevel.func_180495_p(blockpos);
                }
                flag = blockstate.func_203425_a((Block)this) && (Boolean)blockstate.func_177229_b((Property)booleanproperty) != false;
            }
            pState = (BlockState)pState.func_206870_a((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
            if (!flag) continue;
            ++count;
        }
        count = count + ((Boolean)pState.func_177229_b((Property)DOWN) != false ? 1 : 0) + ((Boolean)pState.func_177229_b((Property)UP) != false ? 1 : 0);
        pState = (BlockState)pState.func_206870_a((Property)FACE_COUNT, (Comparable)Integer.valueOf(count));
        return pState;
    }

    private boolean hasFaces(BlockState pState) {
        return this.countFaces(pState) > 0;
    }

    public int countFaces(BlockState pState) {
        int i = 0;
        for (BooleanProperty booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            if (!((Boolean)pState.func_177229_b((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    public boolean func_196260_a(BlockState pState, IWorldReader pLevel, BlockPos pPos) {
        return this.hasFaces(this.getUpdatedState(pState, pLevel, pPos)) || (Boolean)pState.func_177229_b((Property)DOWN) != false && super.func_196260_a(pState, pLevel, pPos);
    }

    public BlockState func_196271_a(BlockState pState, Direction pFacing, BlockState pFacingState, IWorld pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        int faces = this.countFaces(pState);
        if (faces == 1 && (((Boolean)pState.func_177229_b((Property)UP)).booleanValue() && pLevel.func_175623_d(pCurrentPos.func_177984_a()) || ((Boolean)pState.func_177229_b((Property)DOWN)).booleanValue() && pLevel.func_175623_d(pCurrentPos.func_177977_b()))) {
            return Blocks.field_150350_a.func_176223_P();
        }
        BlockState blockstate = this.getUpdatedState(pState, (IWorldReader)pLevel, pCurrentPos);
        return !this.hasFaces(blockstate) ? Blocks.field_150350_a.func_176223_P() : blockstate;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext pContext) {
        BlockState blockstate1;
        BlockPos blockpos = pContext.func_195995_a();
        BlockState blockstate = pContext.func_195991_k().func_180495_p(blockpos);
        boolean flag = false;
        if (blockstate.func_203425_a((Block)this)) {
            blockstate1 = blockstate;
            flag = true;
        } else {
            blockstate1 = blockstate.func_177230_c() instanceof CarpetBlock ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FACE_COUNT, (Comparable)Integer.valueOf(1)) : this.func_176223_P();
        }
        for (Direction direction : pContext.func_196009_e()) {
            boolean flag1;
            BooleanProperty booleanproperty = CarpetVariantBlock.getPropertyForFace(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.func_177229_b((Property)booleanproperty) != false;
            if (flag1 || !this.canSupportAtFace((IWorldReader)pContext.func_195991_k(), pContext.func_195995_a(), direction)) continue;
            return (BlockState)((BlockState)blockstate1.func_206870_a((Property)booleanproperty, (Comparable)Boolean.TRUE)).func_206870_a((Property)FACE_COUNT, (Comparable)Integer.valueOf((Integer)blockstate1.func_177229_b((Property)FACE_COUNT) + 1));
        }
        if (!flag) {
            return (BlockState)((BlockState)blockstate1.func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FACE_COUNT, (Comparable)Integer.valueOf(1));
        }
        return blockstate1;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> pBuilder) {
        pBuilder.func_206894_a(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST, FACE_COUNT});
    }

    public BlockState func_185499_a(BlockState pState, Rotation pRotate) {
        switch (pRotate) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.func_206870_a((Property)NORTH, pState.func_177229_b((Property)SOUTH))).func_206870_a((Property)EAST, pState.func_177229_b((Property)WEST))).func_206870_a((Property)SOUTH, pState.func_177229_b((Property)NORTH))).func_206870_a((Property)WEST, pState.func_177229_b((Property)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.func_206870_a((Property)NORTH, pState.func_177229_b((Property)EAST))).func_206870_a((Property)EAST, pState.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, pState.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, pState.func_177229_b((Property)NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.func_206870_a((Property)NORTH, pState.func_177229_b((Property)WEST))).func_206870_a((Property)EAST, pState.func_177229_b((Property)NORTH))).func_206870_a((Property)SOUTH, pState.func_177229_b((Property)EAST))).func_206870_a((Property)WEST, pState.func_177229_b((Property)SOUTH));
            }
        }
        return pState;
    }

    public BlockState func_185471_a(BlockState pState, Mirror pMirror) {
        switch (pMirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)pState.func_206870_a((Property)NORTH, pState.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, pState.func_177229_b((Property)NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)pState.func_206870_a((Property)EAST, pState.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, pState.func_177229_b((Property)EAST));
            }
        }
        return super.func_185471_a(pState, pMirror);
    }
}

