/*
 * Decompiled with CFR 0.152.
 */
package net.dylanvhs.bountiful_critters.entity.custom;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dylanvhs.bountiful_critters.BountifulCritters;
import net.dylanvhs.bountiful_critters.entity.ModEntities;
import net.dylanvhs.bountiful_critters.entity.PotAccess;
import net.dylanvhs.bountiful_critters.entity.ai.Bagable;
import net.dylanvhs.bountiful_critters.entity.ai.Hookable;
import net.dylanvhs.bountiful_critters.entity.custom.PillbugEntity;
import net.dylanvhs.bountiful_critters.item.ModItems;
import net.dylanvhs.bountiful_critters.sounds.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BluntHeadedTreeSnakeEntity
extends Animal
implements GeoEntity,
Hookable,
Bagable {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(BluntHeadedTreeSnakeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> FROM_HOOK = SynchedEntityData.m_135353_(BluntHeadedTreeSnakeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_BAG = SynchedEntityData.m_135353_(BluntHeadedTreeSnakeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(BluntHeadedTreeSnakeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Ingredient TEMPTATION_ITEM = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.POTTED_PILLBUG.get()});

    public BluntHeadedTreeSnakeEntity(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 0.0f);
        this.m_274367_(1.0f);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ModItems.BLUNT_HEADED_TREE_SNAKE_SPAWN_EGG.get());
    }

    @Nullable
    public BluntHeadedTreeSnakeEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        BluntHeadedTreeSnakeEntity snake = (BluntHeadedTreeSnakeEntity)((EntityType)ModEntities.BLUNT_HEADED_TREE_SNAKE.get()).m_20615_((Level)pLevel);
        if (snake != null) {
            int i = this.f_19796_.m_188499_() ? this.getVariant() : ((BluntHeadedTreeSnakeEntity)pOtherParent).getVariant();
            snake.setVariant(i);
            snake.m_21530_();
        }
        return snake;
    }

    public static String getVariantName(int variant) {
        return switch (variant) {
            case 1 -> "white_brown";
            case 2 -> "yellow";
            case 3 -> "melinda";
            default -> "brown";
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(FROM_HOOK, (Object)false);
        this.f_19804_.m_135372_(FROM_BAG, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("FromHook", this.fromHook());
        compound.m_128379_("FromBag", this.fromBag());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setFromHook(compound.m_128471_("FromHook"));
        this.setFromBag(compound.m_128471_("FromBag"));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 5.0f, 1.0, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Frog.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, PillbugEntity.class, true));
        this.f_21345_.m_25352_(8, (Goal)new SnakeGoToPotGoal(1.2f, 12, 1));
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 1.0).m_22265_();
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public boolean m_6898_(ItemStack pStack) {
        return TEMPTATION_ITEM.test(pStack);
    }

    protected void m_142075_(Player pPlayer, InteractionHand pHand, ItemStack pStack) {
        if (!pPlayer.m_7500_()) {
            if (pStack.m_150930_((Item)ModItems.POTTED_PILLBUG.get())) {
                pPlayer.m_21008_(pHand, new ItemStack((ItemLike)Items.f_42618_));
            } else {
                super.m_142075_(pPlayer, pHand, pStack);
            }
        }
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = super.m_7327_(pEntity);
        if (flag && pEntity instanceof LivingEntity) {
            float f = this.m_9236_().m_6436_(this.m_20183_()).m_19056_();
            ((LivingEntity)pEntity).m_147207_(new MobEffectInstance(MobEffects.f_19614_, 80 * (int)f), (Entity)this);
        }
        return flag;
    }

    public static <T extends Mob> boolean canSpawn(EntityType type, LevelAccessor worldIn, MobSpawnType reason, BlockPos p_223317_3_, RandomSource random) {
        BlockState blockstate = worldIn.m_8055_(p_223317_3_.m_7495_());
        return blockstate.m_60713_(Blocks.f_50440_) || blockstate.m_204336_(BlockTags.f_13106_) || blockstate.m_204336_(BlockTags.f_13035_);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SNAKE_HISS.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11915_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SNAKE_HISS.get();
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_(SoundEvents.f_11834_, 0.0f, 1.0f);
    }

    protected float m_6121_() {
        return 0.1f;
    }

    public boolean m_6573_(Player pPlayer) {
        return true;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    private void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public boolean fromHook() {
        return (Boolean)this.f_19804_.m_135370_(FROM_HOOK);
    }

    @Override
    public void setFromHook(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FROM_HOOK, (Object)p_203706_1_);
    }

    @Override
    @Nonnull
    public ItemStack getHookItemStack() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.CAPTURED_BLUNT_HEADED_TREE_SNAKE.get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    @Override
    @Nonnull
    public ItemStack getBagItemStack() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.BAGGED_BLUNT_HEADED_TREE_SNAKE.get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    @Override
    public void saveToHookTag(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        Hookable.saveDefaultDataToBagTag((Mob)this, bucket);
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("Age", this.m_146764_());
        compoundnbt.m_128405_("HookVariantTag", this.getVariant());
    }

    @Override
    public void loadFromHookTag(@Nonnull CompoundTag compound) {
        Hookable.loadDefaultDataFromBagTag((Mob)this, compound);
        if (compound.m_128441_("Age")) {
            this.m_146762_(compound.m_128451_("Age"));
        }
        if (compound.m_128425_("HookVariantTag", 3)) {
            this.setVariant(compound.m_128451_("HookVariantTag"));
        }
    }

    @Nonnull
    public InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        ItemStack itemstack4 = player.m_21206_();
        if (itemstack.m_41720_() == ModItems.SNAKE_HOOK.get() && this.m_6084_()) {
            Hookable.hookMobPickup(player, hand, this);
        } else if (itemstack4.m_41720_() == ModItems.REPTILE_BAG.get() && itemstack.m_41720_() == ModItems.SNAKE_HOOK.get() && this.m_6084_()) {
            Bagable.bagMobPickup(player, hand, this);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    @Nonnull
    public SoundEvent getPickupSound() {
        return SoundEvents.f_184215_;
    }

    @Override
    public boolean fromBag() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BAG);
    }

    @Override
    public void setFromBag(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FROM_BAG, (Object)p_203706_1_);
    }

    @Override
    public void saveToBagTag(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        Bagable.saveDefaultDataToBagTag((Mob)this, bucket);
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("Age", this.m_146764_());
        compoundnbt.m_128405_("BagVariantTag", this.getVariant());
    }

    @Override
    public void loadFromBagTag(@Nonnull CompoundTag compound) {
        Bagable.loadDefaultDataFromBagTag((Mob)this, compound);
        if (compound.m_128441_("Age")) {
            this.m_146762_(compound.m_128451_("Age"));
        }
        if (compound.m_128425_("BagVariantTag", 3)) {
            this.setVariant(compound.m_128451_("BagVariantTag"));
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        boolean flag = false;
        float variantChange = this.m_217043_().m_188501_();
        if (reason != MobSpawnType.BUCKET && flag) {
            this.m_146762_(-24000);
        }
        if (variantChange <= 0.1f) {
            this.setVariant(3);
        } else if (variantChange <= 0.3f) {
            this.setVariant(2);
        } else if (variantChange <= 0.5f) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 4, this::attackPredicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (geoAnimatableAnimationState.isMoving()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.blunt_headed_tree_snake.walk", Animation.LoopType.LOOP));
            geoAnimatableAnimationState.getController().setAnimationSpeed((double)1.3f);
            return PlayState.CONTINUE;
        }
        geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.blunt_headed_tree_snake.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (this.f_20911_ && geoAnimatableAnimationState.isMoving() && geoAnimatableAnimationState.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            geoAnimatableAnimationState.getController().forceAnimationReset();
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.blunt_headed_tree_snake.walk_attack", Animation.LoopType.PLAY_ONCE));
            this.f_20911_ = false;
        } else if (this.f_20911_ && !geoAnimatableAnimationState.isMoving() && geoAnimatableAnimationState.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            geoAnimatableAnimationState.getController().forceAnimationReset();
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.blunt_headed_tree_snake.idle_attack", Animation.LoopType.PLAY_ONCE));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    public class SnakeGoToPotGoal
    extends MoveToBlockGoal {
        private static final int WAIT_TICKS = 40;
        protected int ticksWaited;

        public SnakeGoToPotGoal(double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((PathfinderMob)BluntHeadedTreeSnakeEntity.this, pSpeedModifier, pSearchRange, pVerticalSearchRange);
        }

        public double m_8052_() {
            return 2.0;
        }

        public boolean m_8064_() {
            return this.f_25601_ % 100 == 0;
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            BlockState blockstate = pLevel.m_8055_(pPos);
            return blockstate.m_60713_(Blocks.f_271197_) && !PotAccess.hasSnake(this.f_25602_);
        }

        public void m_8037_() {
            if (this.m_25625_()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            }
            super.m_8037_();
        }

        protected void onReachedTarget() {
            if (ForgeEventFactory.getMobGriefingEvent((Level)BluntHeadedTreeSnakeEntity.this.m_9236_(), (Entity)BluntHeadedTreeSnakeEntity.this)) {
                BlockState blockstate = BluntHeadedTreeSnakeEntity.this.m_9236_().m_8055_(this.f_25602_);
                if (BluntHeadedTreeSnakeEntity.this.m_20075_().m_60713_(Blocks.f_271197_) && !PotAccess.hasSnake(this.f_25602_)) {
                    this.goInPot(blockstate);
                }
            }
        }

        private void goInPot(BlockState pState) {
            PotAccess.setSnake(this.f_25602_, BluntHeadedTreeSnakeEntity.this);
            BountifulCritters.LOGGER.info("moved snake to pot at " + BluntHeadedTreeSnakeEntity.this.m_20099_().m_123344_());
            BluntHeadedTreeSnakeEntity.this.m_5496_(SoundEvents.f_271337_, 1.0f, 1.0f);
            if (BluntHeadedTreeSnakeEntity.this.m_9236_().f_46443_) {
                Vec3 vec3 = BluntHeadedTreeSnakeEntity.this.m_20252_(0.0f);
                float f = Mth.m_14089_((float)(BluntHeadedTreeSnakeEntity.this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
                float f1 = Mth.m_14031_((float)(BluntHeadedTreeSnakeEntity.this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
                float f2 = 1.2f - BluntHeadedTreeSnakeEntity.this.f_19796_.m_188501_() * 0.7f;
                BluntHeadedTreeSnakeEntity.this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, BluntHeadedTreeSnakeEntity.this.m_20185_() - vec3.f_82479_ * (double)f2 + (double)f, BluntHeadedTreeSnakeEntity.this.m_20186_() - vec3.f_82480_, BluntHeadedTreeSnakeEntity.this.m_20189_() - vec3.f_82481_ * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                BluntHeadedTreeSnakeEntity.this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, BluntHeadedTreeSnakeEntity.this.m_20185_() - vec3.f_82479_ * (double)f2 - (double)f, BluntHeadedTreeSnakeEntity.this.m_20186_() - vec3.f_82480_, BluntHeadedTreeSnakeEntity.this.m_20189_() - vec3.f_82481_ * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            }
        }

        public boolean m_8036_() {
            return !BluntHeadedTreeSnakeEntity.this.m_6162_() && super.m_8036_();
        }

        public void m_8056_() {
            this.ticksWaited = 0;
            super.m_8056_();
        }
    }
}

