/*
 * Decompiled with CFR 0.152.
 */
package net.dylanvhs.bountiful_critters.entity.custom;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dylanvhs.bountiful_critters.entity.ModEntities;
import net.dylanvhs.bountiful_critters.entity.ai.Bagable;
import net.dylanvhs.bountiful_critters.entity.custom.PillbugEntity;
import net.dylanvhs.bountiful_critters.item.ModItems;
import net.dylanvhs.bountiful_critters.sounds.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class GeckoEntity
extends Animal
implements GeoEntity,
Bagable {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(GeckoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> FROM_BAG = SynchedEntityData.m_135353_(GeckoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_WARNING = SynchedEntityData.m_135353_(GeckoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(GeckoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Ingredient TEMPTATION_ITEM = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RAW_PILLBUG.get(), Items.f_42591_});
    private boolean canBePushed = true;
    protected int tame;

    public GeckoEntity(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ModItems.GECKO_SPAWN_EGG.get());
    }

    @Nullable
    public GeckoEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        GeckoEntity gecko = (GeckoEntity)((EntityType)ModEntities.GECKO.get()).m_20615_((Level)pLevel);
        if (gecko != null) {
            int i = this.f_19796_.m_188499_() ? this.getVariant() : ((GeckoEntity)pOtherParent).getVariant();
            gecko.setVariant(i);
            gecko.m_21530_();
        }
        return gecko;
    }

    public boolean m_6094_() {
        if (this.isWarning()) {
            this.canBePushed = false;
            return false;
        }
        this.canBePushed = true;
        return true;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            this.setWarning(false);
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new WallClimberNavigation((Mob)this, pLevel);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean pClimbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = pClimbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    public static String getVariantName(int variant) {
        return switch (variant) {
            case 1 -> "green";
            case 2 -> "tokay";
            case 3 -> "electric_blue_day";
            case 4 -> "yellow_headed";
            default -> "leopard";
        };
    }

    @Override
    public boolean fromBag() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BAG);
    }

    @Override
    public void setFromBag(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FROM_BAG, (Object)p_203706_1_);
    }

    @Override
    @Nonnull
    public ItemStack getBagItemStack() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.BAGGED_GECKO.get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    @Override
    public void saveToBagTag(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        Bagable.saveDefaultDataToBagTag((Mob)this, bucket);
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("Age", this.m_146764_());
        compoundnbt.m_128405_("BagVariantTag", this.getVariant());
    }

    @Override
    public void loadFromBagTag(@Nonnull CompoundTag compound) {
        Bagable.loadDefaultDataFromBagTag((Mob)this, compound);
        if (compound.m_128441_("Age")) {
            this.m_146762_(compound.m_128451_("Age"));
        }
        if (compound.m_128441_("Age")) {
            this.m_146762_(compound.m_128451_("Age"));
        }
        if (compound.m_128425_("BagVariantTag", 3)) {
            this.setVariant(compound.m_128451_("BagVariantTag"));
        }
    }

    @Nonnull
    public InteractionResult m_6071_(@Nonnull Player pPlayer, @Nonnull InteractionHand pHand) {
        return Bagable.bagMobPickup(pPlayer, pHand, this).orElse(super.m_6071_(pPlayer, pHand));
    }

    @Override
    @Nonnull
    public SoundEvent getPickupSound() {
        return SoundEvents.f_184215_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(FROM_BAG, (Object)false);
        this.f_19804_.m_135372_(IS_WARNING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("FromBag", this.fromBag());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setFromBag(compound.m_128471_("FromBag"));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, TEMPTATION_ITEM, false));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 5.0f, 1.0, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, PillbugEntity.class, true));
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 1.0).m_22265_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.GECKO_AMBIENT.get();
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public boolean m_6898_(ItemStack pStack) {
        return TEMPTATION_ITEM.test(pStack);
    }

    public static <T extends Mob> boolean canSpawn(EntityType type, LevelAccessor worldIn, MobSpawnType reason, BlockPos p_223317_3_, RandomSource random) {
        BlockState blockstate = worldIn.m_8055_(p_223317_3_.m_7495_());
        return blockstate.m_60713_(Blocks.f_50440_) || blockstate.m_204336_(BlockTags.f_13106_) || blockstate.m_204336_(BlockTags.f_13035_);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isWarning();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            this.m_21051_(Attributes.f_22279_).m_22100_(this.m_6107_() ? 0.0 : 0.2);
        }
    }

    public boolean isWarning() {
        return (Boolean)this.f_19804_.m_135370_(IS_WARNING);
    }

    public void setWarning(boolean rollUp) {
        this.f_19804_.m_135381_(IS_WARNING, (Object)rollUp);
    }

    public void m_8119_() {
        List list;
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_);
        }
        if (this.isWarning() && this.f_19796_.m_188501_() < 0.04f) {
            for (int i = 0; i < this.f_19796_.m_188503_(2) + 1; ++i) {
                this.m_5496_(SoundEvents.f_144171_, 0.5f, 1.0f);
            }
        }
        if (!(list = this.m_9236_().m_45971_(Monster.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82377_(8.0, 3.0, 8.0))).isEmpty()) {
            if (list.stream().noneMatch(Entity::m_6047_)) {
                this.setWarning(true);
                this.m_21573_().m_26573_();
            } else {
                this.setWarning(false);
            }
        } else {
            this.setWarning(false);
        }
    }

    public boolean m_6573_(Player pPlayer) {
        return true;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    private void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        boolean flag = false;
        float variantChange = this.m_217043_().m_188501_();
        if (reason != MobSpawnType.BUCKET && flag) {
            this.m_146762_(-24000);
        }
        if (variantChange <= 0.25f) {
            this.setVariant(4);
        } else if (variantChange <= 0.3f) {
            this.setVariant(3);
        } else if (variantChange <= 0.4f) {
            this.setVariant(2);
        } else if (variantChange <= 0.55f) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 4, this::attackPredicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (this.isWarning()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.gecko.warn", Animation.LoopType.LOOP));
            geoAnimatableAnimationState.getController().setAnimationSpeed(2.0);
            return PlayState.CONTINUE;
        }
        if (geoAnimatableAnimationState.isMoving()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.gecko.walk", Animation.LoopType.LOOP));
            geoAnimatableAnimationState.getController().setAnimationSpeed(1.5);
            return PlayState.CONTINUE;
        }
        if (this.isClimbing() && geoAnimatableAnimationState.isMoving()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.gecko.climb", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isClimbing() && !geoAnimatableAnimationState.isMoving()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.gecko.climb_idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.gecko.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (this.f_20911_ && geoAnimatableAnimationState.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            geoAnimatableAnimationState.getController().forceAnimationReset();
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.gecko.lick", Animation.LoopType.PLAY_ONCE));
            geoAnimatableAnimationState.getController().setAnimationSpeed(2.5);
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }
}

