/*
 * Decompiled with CFR 0.152.
 */
package net.dylanvhs.bountiful_critters.entity.custom;

import java.util.List;
import javax.annotation.Nullable;
import net.dylanvhs.bountiful_critters.entity.ModEntities;
import net.dylanvhs.bountiful_critters.entity.ai.CustomBreathAirGoal;
import net.dylanvhs.bountiful_critters.entity.ai.HumpbackWhaleJumpGoal;
import net.dylanvhs.bountiful_critters.entity.custom.KrillEntity;
import net.dylanvhs.bountiful_critters.item.ModItems;
import net.dylanvhs.bountiful_critters.sounds.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class HumpbackWhaleEntity
extends Animal
implements GeoAnimatable {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final Ingredient TEMPTATION_ITEM = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RAW_KRILL.get()});
    private static final EntityDataAccessor<Integer> MOISTNESS_LEVEL = SynchedEntityData.m_135353_(HumpbackWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_FEEDING = SynchedEntityData.m_135353_(HumpbackWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int filterCooldown;
    public static final int TOTAL_AIR_SUPPLY = 4800;
    private static final int TOTAL_MOISTNESS_LEVEL = 2400;
    private boolean canBePushed = false;

    public HumpbackWhaleEntity(EntityType<? extends HumpbackWhaleEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new MoveHelperController(this);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 15);
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 85.0).m_22268_(Attributes.f_22277_, 75.0).m_22268_(Attributes.f_22279_, 1.5).m_22268_(Attributes.f_22285_, 0.5).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22278_, 5.0).m_22265_();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ModItems.HUMPBACK_WHALE_SPAWN_EGG.get());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new CustomBreathAirGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, TEMPTATION_ITEM, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new HumpbackWhaleJumpGoal(this, 1));
        this.f_21345_.m_25352_(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.2f, true));
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, KrillEntity.class, true));
    }

    @Nullable
    public HumpbackWhaleEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (HumpbackWhaleEntity)((EntityType)ModEntities.HUMPBACK_WHALE.get()).m_20615_((Level)pLevel);
    }

    public static boolean checkFishSpawnRules(EntityType<? extends HumpbackWhaleEntity> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos p_223363_3_, RandomSource randomIn) {
        return worldIn.m_8055_(p_223363_3_).m_60713_(Blocks.f_49990_) && worldIn.m_8055_(p_223363_3_.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.WHALE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.WHALE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.WHALE_DEATH.get();
    }

    protected float m_6121_() {
        return 0.5f;
    }

    public boolean m_6914_(LevelReader worldIn) {
        return worldIn.m_45784_((Entity)this);
    }

    public boolean m_6094_() {
        return this.canBePushed;
    }

    protected PathNavigation m_6037_(Level p_27480_) {
        return new WaterBoundPathNavigation((Mob)this, p_27480_);
    }

    public boolean m_6898_(ItemStack pStack) {
        return TEMPTATION_ITEM.test(pStack);
    }

    public int m_6062_() {
        return 8000;
    }

    protected int m_7305_(int pCurrentAir) {
        return this.m_6062_();
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return 1.75f;
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    protected boolean m_7341_(Entity pEntity) {
        return false;
    }

    public boolean m_6040_() {
        return false;
    }

    public int getMoistnessLevel() {
        return (Integer)this.f_19804_.m_135370_(MOISTNESS_LEVEL);
    }

    public void setMoisntessLevel(int pMoistnessLevel) {
        this.f_19804_.m_135381_(MOISTNESS_LEVEL, (Object)pMoistnessLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOISTNESS_LEVEL, (Object)2400);
        this.f_19804_.m_135372_(IS_FEEDING, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Moistness", this.getMoistnessLevel());
        pCompound.m_128405_("FilterCooldown", this.filterCooldown);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setMoisntessLevel(pCompound.m_128451_("Moistness"));
        this.filterCooldown = pCompound.m_128451_("FilterCooldown");
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean isFeeding() {
        return (Boolean)this.f_19804_.m_135370_(IS_FEEDING);
    }

    public void setFeeding(boolean feeding) {
        this.f_19804_.m_135381_(IS_FEEDING, (Object)feeding);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_6084_()) {
            return;
        }
        if (this.filterCooldown > 0) {
            --this.filterCooldown;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        List list = this.m_9236_().m_45971_(KrillEntity.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82377_(10.0, 10.0, 10.0));
        if (!list.isEmpty()) {
            this.setFeeding(true);
        } else {
            this.setFeeding(false);
        }
        if (this.m_21525_()) {
            this.m_20301_(this.m_6062_());
        } else {
            if (this.m_20071_()) {
                this.setMoisntessLevel(2400);
            } else {
                this.setMoisntessLevel(this.getMoistnessLevel() - 1);
                if (this.getMoistnessLevel() <= 0) {
                    this.m_6469_(this.m_269291_().m_269483_(), 1.0f);
                }
            }
            if (this.m_9236_().f_46443_ && this.m_20069_() && this.m_20184_().m_82556_() > 0.03) {
                Vec3 vec3 = this.m_20252_(0.0f);
                float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
                float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
                float f2 = 1.2f - this.f_19796_.m_188501_() * 0.7f;
                for (int i = 0; i < 2; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vec3.f_82479_ * (double)f2 + (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vec3.f_82479_ * (double)f2 - (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_7822_(byte id) {
        if (id == 39) {
            this.filterCooldown = 1000;
        }
        super.m_7822_(id);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() == Items.f_41830_ && this.m_6084_() && !this.m_6162_() && this.filterCooldown == 0 || heldItem.m_41720_() == Items.f_41831_ && this.m_6084_() && !this.m_6162_() && this.filterCooldown == 0 || heldItem.m_41720_() == Items.f_41832_ && this.m_6084_() && !this.m_6162_() && this.filterCooldown == 0) {
            this.m_5496_(SoundEvents.f_11803_, 1.0f, 1.0f);
            heldItem.m_41774_(1);
            this.filterCooldown = 1000;
            float lootChange = this.m_217043_().m_188501_();
            if (lootChange <= 0.05f) {
                this.m_19998_((ItemLike)Items.f_42415_);
                if (lootChange <= 0.04f) {
                    this.m_20000_((ItemLike)Items.f_42716_, 4);
                }
                if ((double)lootChange <= 0.05) {
                    this.m_20000_((ItemLike)Items.f_42415_, 4);
                }
                if ((double)lootChange <= 0.5) {
                    this.m_20000_((ItemLike)Items.f_42518_, 4);
                }
                if (lootChange <= 0.04f) {
                    this.m_20000_((ItemLike)Items.f_42616_, 4);
                }
            } else if (lootChange <= 0.08f) {
                this.m_20000_((ItemLike)Items.f_42616_, 4);
                if ((double)lootChange <= 0.5) {
                    this.m_20000_((ItemLike)Items.f_41854_, 4);
                }
                if ((double)lootChange <= 0.5) {
                    this.m_20000_((ItemLike)Items.f_42413_, 4);
                }
                if ((double)lootChange <= 0.5) {
                    this.m_20000_((ItemLike)Items.f_42518_, 4);
                }
            } else if (lootChange <= 0.3f) {
                this.m_20000_((ItemLike)Items.f_42416_, 4);
                if ((double)lootChange <= 0.5) {
                    this.m_20000_((ItemLike)Items.f_41912_, 4);
                }
            } else if (lootChange <= 0.5f) {
                this.m_20000_((ItemLike)Items.f_42417_, 4);
                if ((double)lootChange <= 0.5) {
                    this.m_20000_((ItemLike)Items.f_42749_, 4);
                }
                if ((double)lootChange <= 0.5) {
                    this.m_20000_((ItemLike)Items.f_42413_, 4);
                }
                if ((double)lootChange <= 0.5) {
                    this.m_20000_((ItemLike)Items.f_42518_, 4);
                }
            } else if (lootChange <= 0.65f) {
                this.m_20000_((ItemLike)Items.f_42587_, 4);
                if ((double)lootChange <= 0.5) {
                    this.m_20000_((ItemLike)Items.f_151052_, 4);
                }
            } else if (lootChange <= 0.75f) {
                this.m_20000_((ItemLike)Items.f_42499_, 4);
                if ((double)lootChange <= 0.5) {
                    this.m_20000_((ItemLike)Items.f_42526_, 4);
                }
                if ((double)lootChange <= 0.5) {
                    this.m_20000_((ItemLike)Items.f_42518_, 4);
                }
            } else if (lootChange <= 0.9f) {
                this.m_20000_((ItemLike)Items.f_42413_, 4);
                if ((double)lootChange <= 0.5) {
                    this.m_20000_((ItemLike)Items.f_42518_, 4);
                }
            } else {
                this.m_20000_((ItemLike)Items.f_41830_, 4);
                if ((double)lootChange <= 0.5) {
                    this.m_20000_((ItemLike)Items.f_42413_, 4);
                }
                if ((double)lootChange <= 0.5) {
                    this.m_20000_((ItemLike)Items.f_42499_, 4);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    protected SoundEvent m_5509_() {
        return (SoundEvent)ModSounds.WHALE_SPLASH.get();
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11808_;
    }

    public boolean m_6779_(LivingEntity entity) {
        boolean prev = super.m_6779_(entity);
        if (this.m_6162_()) {
            return false;
        }
        return prev;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (geoAnimatableAnimationState.isMoving()) {
            if (this.m_20142_()) {
                geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.humpback_whale.jump", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isFeeding()) {
                geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.humpback_whale.eat", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.humpback_whale.swim", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (!this.m_20069_()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.humpback_whale.idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.humpback_whale.swim", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    static class MoveHelperController
    extends MoveControl {
        private final HumpbackWhaleEntity dolphin;

        public MoveHelperController(HumpbackWhaleEntity dolphinIn) {
            super((Mob)dolphinIn);
            this.dolphin = dolphinIn;
        }

        public void m_8126_() {
            if (this.dolphin.m_20069_()) {
                this.dolphin.m_20256_(this.dolphin.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.dolphin.m_21573_().m_26571_()) {
                double d2;
                double d1;
                double d0 = this.f_24975_ - this.dolphin.m_20185_();
                double d3 = d0 * d0 + (d1 = this.f_24976_ - this.dolphin.m_20186_()) * d1 + (d2 = this.f_24977_ - this.dolphin.m_20189_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.f_24974_.m_21564_(0.0f);
                } else {
                    float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.dolphin.m_146922_(this.m_24991_(this.dolphin.m_146908_(), f, 10.0f));
                    this.dolphin.f_20883_ = this.dolphin.m_146908_();
                    this.dolphin.f_20885_ = this.dolphin.m_146908_();
                    float f1 = (float)(this.f_24978_ * this.dolphin.m_21133_(Attributes.f_22279_));
                    if (this.dolphin.m_20069_()) {
                        this.dolphin.m_7910_(f1 * 0.02f);
                        float f2 = -((float)(Mth.m_14136_((double)d1, (double)Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)))) * 57.2957763671875));
                        f2 = Mth.m_14036_((float)Mth.m_14177_((float)f2), (float)-85.0f, (float)85.0f);
                        this.dolphin.m_146926_(this.m_24991_(this.dolphin.m_146909_(), f2, 5.0f));
                        float f3 = Mth.m_14089_((float)(this.dolphin.m_146909_() * ((float)Math.PI / 180)));
                        float f4 = Mth.m_14031_((float)(this.dolphin.m_146909_() * ((float)Math.PI / 180)));
                        this.dolphin.f_20902_ = f3 * f1;
                        this.dolphin.f_20901_ = -f4 * f1;
                    } else {
                        this.dolphin.m_7910_(f1 * 0.1f);
                    }
                }
            } else {
                this.dolphin.m_7910_(0.0f);
                this.dolphin.m_21570_(0.0f);
                this.dolphin.m_21567_(0.0f);
                this.dolphin.m_21564_(0.0f);
            }
        }
    }
}

