/*
 * Decompiled with CFR 0.152.
 */
package net.dylanvhs.bountiful_critters.entity.custom;

import net.dylanvhs.bountiful_critters.damage.ModDamageTypes;
import net.dylanvhs.bountiful_critters.entity.ModEntities;
import net.dylanvhs.bountiful_critters.entity.custom.PillbugEntity;
import net.dylanvhs.bountiful_critters.sounds.ModSounds;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class PillbugProjectileEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Integer> BOUNCES = SynchedEntityData.m_135353_(PillbugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    int bounces = 0;

    public PillbugProjectileEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public PillbugProjectileEntity(Level pLevel, LivingEntity pShooter) {
        super((EntityType)ModEntities.THROWABLE_PILLBUG.get(), pShooter, pLevel);
    }

    public PillbugProjectileEntity(Level pLevel, double pX, double pY, double pZ) {
        super((EntityType)ModEntities.THROWABLE_PILLBUG.get(), pX, pY, pZ, pLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOUNCES, (Object)this.bounces);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getBounces());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBounces(compound.m_128451_("Variant"));
    }

    public int getBounces() {
        return (Integer)this.f_19804_.m_135370_(BOUNCES);
    }

    public void setBounces(int variant) {
        this.f_19804_.m_135381_(BOUNCES, (Object)variant);
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        this.m_5496_((SoundEvent)ModSounds.PILLBUG_BOUNCE.get(), 0.8f, 1.0f);
        Entity entity = pResult.m_82443_();
        Entity owner = this.m_19749_();
        DamageSource damageSource = ModDamageTypes.causePillballDamage(entity.m_9236_().m_9598_(), owner);
        entity.m_6469_(damageSource, 5.0f);
        PillbugEntity pillbug = (PillbugEntity)((EntityType)ModEntities.PILLBUG.get()).m_20615_(this.m_9236_());
        if (pillbug != null) {
            pillbug.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            if (this.m_8077_()) {
                this.m_6593_(this.m_7770_());
                this.m_9236_().m_7967_((Entity)pillbug);
            } else {
                this.m_9236_().m_7967_((Entity)pillbug);
            }
        }
        this.m_146870_();
    }

    protected Item m_7881_() {
        return null;
    }

    protected void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        this.setBounces(this.bounces++);
        this.m_5496_((SoundEvent)ModSounds.PILLBUG_BOUNCE.get(), 0.8f, 1.0f);
        Vec3 deltaMovement = this.m_20184_();
        Vec3 vec3 = deltaMovement.m_82492_(deltaMovement.f_82479_ / 5.0, 0.0, deltaMovement.f_82481_ / 5.0);
        Direction direction = hit.m_82434_();
        double booster = 0.5000000029802323;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            this.m_20334_(vec3.f_82479_, vec3.f_82480_ < 0.0 ? -vec3.f_82480_ * booster : 0.0, vec3.f_82481_);
        }
        if (direction == Direction.WEST || direction == Direction.EAST) {
            this.m_20334_(vec3.f_82479_ < 0.65 ? -vec3.f_82479_ * booster * (double)Mth.m_14031_((float)1.5707964f) : 0.0, vec3.f_82480_, vec3.f_82481_);
        }
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            this.m_20334_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_ < 0.65 ? -vec3.f_82481_ * booster * (double)Mth.m_14031_((float)2.3561945f) : 0.0);
        }
        if (this.getBounces() >= 4) {
            PillbugEntity pillbug = (PillbugEntity)((EntityType)ModEntities.PILLBUG.get()).m_20615_(this.m_9236_());
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)3);
                pillbug.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                if (this.m_8077_()) {
                    this.m_6593_(this.m_7770_());
                    this.m_9236_().m_7967_((Entity)pillbug);
                } else {
                    this.m_9236_().m_7967_((Entity)pillbug);
                }
                this.m_146870_();
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        PillbugEntity pillbug = (PillbugEntity)((EntityType)ModEntities.PILLBUG.get()).m_20615_(this.m_9236_());
        if (!this.m_9236_().m_5776_() && this.m_20069_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            pillbug.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            if (this.m_8077_()) {
                this.m_6593_(this.m_7770_());
                this.m_9236_().m_7967_((Entity)pillbug);
            } else {
                this.m_9236_().m_7967_((Entity)pillbug);
            }
            this.m_146870_();
        }
    }
}

