/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished;

import com.mrcrayfish.framework.api.FrameworkAPI;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IPlayerEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.block.DoorMatBlock;
import com.mrcrayfish.furniture.refurbished.block.FryingPanBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.CuttingBoardBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.FryingPanBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.GrillBlockEntity;
import com.mrcrayfish.furniture.refurbished.computer.Computer;
import com.mrcrayfish.furniture.refurbished.computer.IService;
import com.mrcrayfish.furniture.refurbished.computer.app.CoinMiner;
import com.mrcrayfish.furniture.refurbished.computer.app.HomeControl;
import com.mrcrayfish.furniture.refurbished.computer.app.Marketplace;
import com.mrcrayfish.furniture.refurbished.computer.app.PaddleBall;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModBlocks;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.electricity.LinkManager;
import com.mrcrayfish.furniture.refurbished.entity.Seat;
import com.mrcrayfish.furniture.refurbished.item.PackageItem;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageToolAnimation;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.server.MinecraftServer;

public class Bootstrap {
    public static void init() {
        Network.init();
        Bootstrap.registerDispenserBehaviours();
        Bootstrap.registerCauldronBehaviours();
        Bootstrap.registerFrameworkEvents();
        FrameworkAPI.registerSyncedDataKey(Seat.LOCK_YAW);
        Computer computer = Computer.get();
        computer.installProgram(Utils.resource("paddle_ball"), PaddleBall::new);
        computer.installProgram(Utils.resource("home_control"), HomeControl::new);
        computer.installProgram(Utils.resource("marketplace"), Marketplace::new);
        computer.installProgram(Utils.resource("coin_miner"), CoinMiner::new);
        computer.installService(PaddleBall.SERVICE);
    }

    private static void registerFrameworkEvents() {
        TickEvents.START_SERVER.register((IFrameworkEvent)((ITickEvent.StartServer)server -> {
            DeliveryService.get(server).ifPresent(DeliveryService::serverTick);
            Computer.get().getServices().forEach(IService::tick);
        }));
        TickEvents.END_PLAYER.register((IFrameworkEvent)((ITickEvent.EndPlayer)player -> {
            MinecraftServer server = player.method_5682();
            if (server != null) {
                LinkManager.get(server).ifPresent(manager -> manager.onPlayerTick(player));
            }
        }));
        PlayerEvents.LOGGED_OUT.register((IFrameworkEvent)((IPlayerEvent.LoggedOut)player -> {
            MinecraftServer server = player.method_5682();
            if (server != null) {
                DeliveryService.get(server).ifPresent(service -> service.playerLoggedOut(player));
                LinkManager.get(server).ifPresent(manager -> manager.onPlayerLoggedOut(player));
            }
        }));
    }

    private static void registerDispenserBehaviours() {
        class_2315.method_10009(() -> ModItems.SPATULA.get(), (source, stack) -> {
            FryingPanBlockEntity fryingPan;
            GrillBlockEntity grill;
            class_2350 direction = (class_2350)source.method_10120().method_11654((class_2769)class_2315.field_10918);
            class_2338 pos = source.method_10122().method_10093(direction).method_10074();
            class_2586 patt4516$temp = source.method_10207().method_8321(pos);
            if (patt4516$temp instanceof GrillBlockEntity && (grill = (GrillBlockEntity)patt4516$temp).flipItems()) {
                FryingPanBlock.playSpatulaScoopSound((class_1937)source.method_10207(), pos.method_10084(), 0.0);
                Network.getPlay().sendToTrackingBlockEntity(() -> grill, (IMessage)new MessageToolAnimation(MessageToolAnimation.Tool.SPATULA, source.method_10122(), direction));
                return stack;
            }
            pos = source.method_10122().method_10093(direction);
            class_2586 patt5078$temp = source.method_10207().method_8321(pos);
            if (patt5078$temp instanceof FryingPanBlockEntity && (fryingPan = (FryingPanBlockEntity)patt5078$temp).isFlippingNeeded()) {
                fryingPan.flipItem();
                FryingPanBlock.playSpatulaScoopSound((class_1937)source.method_10207(), pos, 0.1875);
                Network.getPlay().sendToTrackingBlockEntity(() -> fryingPan, (IMessage)new MessageToolAnimation(MessageToolAnimation.Tool.SPATULA, source.method_10122(), direction));
                return stack;
            }
            return stack;
        });
        class_2315.method_10009(() -> ModItems.KNIFE.get(), (source, stack) -> {
            CuttingBoardBlockEntity cuttingBoard;
            class_2350 direction = (class_2350)source.method_10120().method_11654((class_2769)class_2315.field_10918);
            class_2338 pos = source.method_10122().method_10093(direction);
            class_2586 patt5948$temp = source.method_10207().method_8321(pos);
            if (patt5948$temp instanceof CuttingBoardBlockEntity && (cuttingBoard = (CuttingBoardBlockEntity)patt5948$temp).sliceItem((class_1937)source.method_10207(), false)) {
                if (stack.method_7970(1, source.method_10207().field_9229, null)) {
                    stack.method_7939(0);
                }
                Network.getPlay().sendToTrackingBlockEntity(() -> cuttingBoard, (IMessage)new MessageToolAnimation(MessageToolAnimation.Tool.KNIFE, source.method_10122(), direction));
            }
            return stack;
        });
        class_2315.method_10009(() -> ModItems.PACKAGE.get(), (source, stack) -> {
            class_2350 direction = (class_2350)source.method_10120().method_11654((class_2769)class_2315.field_10918);
            class_243 pos = source.method_10122().method_10093(direction).method_46558();
            PackageItem.getPackagedItems(stack).forEach(s -> class_1264.method_5449((class_1937)source.method_10207(), (double)pos.field_1352, (double)pos.field_1351, (double)pos.field_1350, (class_1799)s));
            return class_1799.field_8037;
        });
    }

    private static void registerCauldronBehaviours() {
        class_5620.field_27776.put(((DoorMatBlock)ModBlocks.DOOR_MAT.get()).method_8389(), (state, level, pos, player, hand, stack) -> {
            class_2487 tag;
            class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
            if (block == ModBlocks.DOOR_MAT.get() && (tag = class_1747.method_38072((class_1799)stack)) != null) {
                if (!level.method_8608()) {
                    class_1799 copy = stack.method_46651(1);
                    class_1747.method_38073((class_1799)copy, (class_2591)((class_2591)ModBlockEntities.DOOR_MAT.get()), (class_2487)new class_2487());
                    stack.method_7934(1);
                    if (stack.method_7960()) {
                        player.method_6122(hand, copy);
                    } else if (player.method_7270(copy)) {
                        player.field_7498.method_34252();
                    } else {
                        player.method_7328(copy, false);
                    }
                    class_5556.method_31650((class_2680)state, (class_1937)level, (class_2338)pos);
                }
                return class_1269.method_29236((boolean)level.method_8608());
            }
            return class_1269.field_5811;
        });
    }
}

