/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.audio;

import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioWorldSound;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.lang.ref.WeakReference;
import java.util.Map;
import net.minecraft.class_1113;
import net.minecraft.class_243;
import net.minecraft.class_310;

public class AudioManager {
    private static AudioManager instance;
    private final Map<ILevelAudio, WeakReference<AudioWorldSound>> playingSounds = new Object2ObjectOpenCustomHashMap((Hash.Strategy)new ILevelAudio.Strategy());

    public static AudioManager get() {
        if (instance == null) {
            instance = new AudioManager();
        }
        return instance;
    }

    private AudioManager() {
    }

    public void update() {
        this.playingSounds.entrySet().removeIf(entry -> {
            WeakReference soundRef = (WeakReference)entry.getValue();
            AudioWorldSound sound = (AudioWorldSound)((Object)((Object)soundRef.get()));
            return sound == null || sound.method_4793();
        });
    }

    private boolean isPlaying(ILevelAudio audio) {
        WeakReference<AudioWorldSound> soundRef = this.playingSounds.get(audio);
        if (soundRef != null) {
            AudioWorldSound sound = (AudioWorldSound)((Object)soundRef.get());
            return sound != null && !sound.method_4793();
        }
        return false;
    }

    public void playLevelAudio(ILevelAudio audio) {
        if (audio.getSound() == null) {
            return;
        }
        if (!audio.canPlayAudio()) {
            return;
        }
        if (this.isPlaying(audio)) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && mc.field_1687 != null) {
            class_243 pos = audio.getAudioPosition();
            class_243 eye = mc.field_1724.method_33571();
            if (eye.method_1025(pos) > audio.getAudioRadiusSqr()) {
                return;
            }
            AudioWorldSound sound = new AudioWorldSound(audio);
            mc.method_1483().method_4873((class_1113)sound);
            this.playingSounds.put(audio, new WeakReference<AudioWorldSound>(sound));
        }
    }

    public void resetSounds() {
        this.playingSounds.forEach((audio, soundRef) -> {
            AudioWorldSound sound = (AudioWorldSound)((Object)((Object)soundRef.get()));
            if (sound != null) {
                sound.cancel();
            }
        });
        this.playingSounds.clear();
    }

    public void updateSound(ILevelAudio audio, AudioWorldSound sound) {
        if (this.playingSounds.containsKey(audio)) {
            this.playingSounds.put(audio, new WeakReference<AudioWorldSound>(sound));
        }
    }
}

