/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.client.ClientComputer;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.computer.Program;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerButton;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageComputerOpenProgram;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public class Window {
    public static final int TITLE_BAR_HEIGHT = 9;
    private final DisplayableProgram<?> displayable;
    private final ClientComputer computer;
    private final ComputerButton closeButton;
    private final int windowWidth;
    private final int windowHeight;
    private int windowStart;
    private int windowTop;
    private int contentStart;
    private int contentTop;

    public Window(DisplayableProgram<?> displayable, ClientComputer computer) {
        this.displayable = displayable;
        this.computer = computer;
        this.windowWidth = 1 + displayable.getWidth() + 1;
        this.windowHeight = 11 + displayable.getHeight() + 1;
        this.closeButton = new ComputerButton(9, 9, (class_2561)class_2561.method_43470((String)"x"), btn -> {
            Network.getPlay().sendToServer((IMessage)new MessageComputerOpenProgram(null));
            computer.setProgram(null);
        });
        this.closeButton.setTextOffset(-1);
        this.closeButton.setTextColour(displayable.getWindowTitleBarColour());
        this.closeButton.setTextHighlightColour(-1);
        this.closeButton.setOutlineColour(displayable.getWindowTitleLabelColour());
        this.closeButton.setOutlineHighlightColour(displayable.getWindowTitleLabelColour());
        this.closeButton.setBackgroundColour(displayable.getWindowTitleLabelColour());
    }

    public void update(int displayStart, int displayTop, int displayWidth, int displayHeight) {
        this.windowStart = displayStart + (displayWidth - this.windowWidth) / 2;
        this.windowTop = displayTop + (displayHeight - this.windowHeight) / 2;
        this.contentStart = this.windowStart + 1;
        this.contentTop = this.windowTop + 1 + 9 + 1;
        this.displayable.update(this.contentStart, this.contentTop);
        this.closeButton.method_48229(this.windowStart + this.windowWidth - this.closeButton.method_25368() - 1, this.windowTop + 1);
    }

    public void tick() {
        this.displayable.tick();
    }

    public void render(class_4587 poseStack, class_327 font, int mouseX, int mouseY, float partialTick) {
        int windowEnd = this.windowStart + this.windowWidth;
        int windowBottom = this.windowTop + this.windowHeight;
        int titleBarStart = this.windowStart + 1;
        int titleBarTop = this.windowTop + 1;
        int titleBarEnd = this.windowStart + this.windowWidth - 1;
        int titleBarBottom = this.windowTop + 1 + 9;
        int contentEnd = this.windowStart + this.windowWidth - 1;
        int contentBottom = this.windowTop + this.windowHeight - 1;
        class_332.method_25294((class_4587)poseStack, (int)(this.windowStart + 1), (int)this.windowTop, (int)(windowEnd - 1), (int)windowBottom, (int)this.displayable.getWindowOutlineColour());
        class_332.method_25294((class_4587)poseStack, (int)this.windowStart, (int)(this.windowTop + 1), (int)windowEnd, (int)(windowBottom - 1), (int)this.displayable.getWindowOutlineColour());
        class_332.method_25294((class_4587)poseStack, (int)titleBarStart, (int)titleBarTop, (int)titleBarEnd, (int)titleBarBottom, (int)this.displayable.getWindowTitleBarColour());
        class_332.method_25294((class_4587)poseStack, (int)this.contentStart, (int)this.contentTop, (int)contentEnd, (int)contentBottom, (int)this.displayable.getWindowBackgroundColour());
        ScreenHelper.drawString(poseStack, ((Program)this.displayable.getProgram()).getTitle(), titleBarStart + 5, titleBarTop + 1, this.displayable.getWindowTitleLabelColour(), false);
        class_332.method_44379((int)this.contentStart, (int)this.contentTop, (int)contentEnd, (int)contentBottom);
        this.displayable.render(poseStack, mouseX, mouseY, partialTick);
        class_332.method_44380();
    }

    public void onClose() {
        this.displayable.onClose();
    }

    public DisplayableProgram<?> getDisplayable() {
        return this.displayable;
    }

    public class_4185 getCloseButton() {
        return this.closeButton;
    }
}

