/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.image;

import com.mrcrayfish.furniture.refurbished.blockentity.IPaintable;
import com.mrcrayfish.furniture.refurbished.image.PaletteImage;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5253;

public class TextureCache {
    private static final long EXPIRE_TIME = 10000L;
    private static TextureCache instance;
    private final Map<class_2960, Entry> entries = new HashMap<class_2960, Entry>();

    public static TextureCache get() {
        if (instance == null) {
            instance = new TextureCache();
        }
        return instance;
    }

    private TextureCache() {
    }

    public void tick() {
        this.entries.entrySet().removeIf(e -> {
            Entry entry = (Entry)e.getValue();
            if (entry.isExpired()) {
                class_310.method_1551().method_1531().method_4615(entry.getId());
                return true;
            }
            return false;
        });
    }

    @Nullable
    public class_2960 getOrCacheImage(IPaintable paintable) {
        PaletteImage image = paintable.getImage();
        if (image != null) {
            Entry entry = this.entries.get(image.getId());
            if (entry == null) {
                entry = new Entry(image);
                this.entries.put(image.getId(), entry);
            }
            entry.ping();
            return image.getId();
        }
        return null;
    }

    private static class_1011 convertToNativeImage(PaletteImage image) {
        class_1011 nativeImage = new class_1011(image.width, image.height, false);
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                int colour = PaletteImage.COLOURS[image.get(x, y)];
                colour = TextureCache.convertARGBToABGR(colour);
                nativeImage.method_4305(x, y, colour);
            }
        }
        return nativeImage;
    }

    private static int convertARGBToABGR(int value) {
        int alpha = class_5253.class_5254.method_27762((int)value);
        int red = class_5253.class_5254.method_27765((int)value);
        int green = class_5253.class_5254.method_27766((int)value);
        int blue = class_5253.class_5254.method_27767((int)value);
        return class_5253.class_8045.method_48344((int)alpha, (int)blue, (int)green, (int)red);
    }

    private static class Entry {
        private final class_2960 id;
        private long lastDrawTime;

        public Entry(PaletteImage image) {
            this.id = image.getId();
            class_1043 texture = new class_1043(TextureCache.convertToNativeImage(image));
            class_310.method_1551().method_1531().method_4616(image.getId(), (class_1044)texture);
            this.lastDrawTime = class_156.method_658();
        }

        public class_2960 getId() {
            return this.id;
        }

        public void ping() {
            this.lastDrawTime = class_156.method_658();
        }

        public boolean isExpired() {
            return class_156.method_658() - this.lastDrawTime > 10000L;
        }
    }
}

