/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.inventory;

import com.mrcrayfish.furniture.refurbished.blockentity.IWorkbench;
import com.mrcrayfish.furniture.refurbished.client.ClientWorkbench;
import com.mrcrayfish.furniture.refurbished.core.ModMenuTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.IElectricityMenu;
import com.mrcrayfish.furniture.refurbished.inventory.SimpleContainerMenu;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import net.minecraft.class_3956;

public class WorkbenchMenu
extends SimpleContainerMenu
implements IElectricityMenu {
    private final IWorkbench workbench;
    private final class_1937 level;
    private final class_3914 access;
    private final class_3913 data;
    private final class_3915 selectedRecipe;
    private final class_3915 searchNeighbours;
    private final List<WorkbenchContructingRecipe> recipes;
    private final Map<class_2960, Boolean> recipeToCraftable = new HashMap<class_2960, Boolean>();
    private final class_1735 resultSlot;
    private Map<Integer, Integer> counts = new Int2IntOpenHashMap();
    private long lastSoundTime;
    @Nullable
    private Runnable updateCallback;

    public WorkbenchMenu(int windowId, class_1661 playerInventory, class_2540 data) {
        this(windowId, playerInventory, new ClientWorkbench((class_1263)new class_1277(13)), (class_3913)new class_3919(1));
        this.selectedRecipe.method_17404(data.method_10816());
        this.searchNeighbours.method_17404(data.method_10816());
        this.data.method_17391(0, data.method_10816());
    }

    public WorkbenchMenu(int windowId, class_1661 playerInventory, IWorkbench workbench, class_3913 data) {
        super((class_3917)ModMenuTypes.WORKBENCH.get(), windowId, workbench.getWorkbenchContainer());
        WorkbenchMenu.method_17359((class_1263)workbench.getWorkbenchContainer(), (int)13);
        WorkbenchMenu.method_17361((class_3913)data, (int)1);
        workbench.getWorkbenchContainer().method_5435(playerInventory.field_7546);
        this.workbench = workbench;
        this.level = playerInventory.field_7546.method_37908();
        this.access = workbench.createLevelAccess();
        this.data = data;
        this.selectedRecipe = workbench.selectedRecipeDataSlot();
        this.searchNeighbours = workbench.searchNeighboursDataSlot();
        this.recipes = this.setupRecipes(this.level);
        this.addContainerSlots(8, 18, 2, 6, 0);
        this.resultSlot = this.method_7621(new WorkbenchResultSlot(this.container, 12, 188, 21));
        this.addPlayerInventorySlots(28, 147, playerInventory);
        this.method_17362(this.selectedRecipe);
        this.method_17362(this.searchNeighbours);
        this.method_17360(this.data);
    }

    public class_1937 getLevel() {
        return this.level;
    }

    public List<WorkbenchContructingRecipe> getRecipes() {
        return this.recipes;
    }

    private List<WorkbenchContructingRecipe> setupRecipes(class_1937 level) {
        ArrayList<WorkbenchContructingRecipe> recipes = new ArrayList<WorkbenchContructingRecipe>(level.method_8433().method_30027((class_3956)ModRecipeTypes.WORKBENCH_CONSTRUCTING.get()));
        recipes.sort(Comparator.comparing(WorkbenchContructingRecipe::getResultId));
        return recipes;
    }

    private void updateResultSlot() {
        if (!this.level.method_8608()) {
            int selectedRecipeIndex = this.selectedRecipe.method_17407();
            if (this.isPowered() && selectedRecipeIndex >= 0 && selectedRecipeIndex < this.recipes.size()) {
                WorkbenchContructingRecipe recipe = this.recipes.get(selectedRecipeIndex);
                if (this.workbench.canCraft(recipe)) {
                    class_1799 output;
                    class_1799 result = this.method_7611(12).method_7677();
                    if (!class_1799.method_7973((class_1799)result, (class_1799)(output = recipe.method_8110(this.level.method_30349())))) {
                        this.resultSlot.method_7673(output.method_7972());
                    }
                } else {
                    this.resultSlot.method_7673(class_1799.field_8037);
                }
            } else {
                this.resultSlot.method_7673(class_1799.field_8037);
            }
            super.method_7623();
        }
    }

    public void method_7623() {
        this.updateResultSlot();
        super.method_7623();
    }

    public boolean method_7604(class_1657 player, int button) {
        if (button >= 0 && button < this.recipes.size()) {
            this.selectedRecipe.method_17404(button);
            this.updateResultSlot();
            return true;
        }
        return false;
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1799 stack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        if (slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            stack = slotStack.method_7972();
            if (slotIndex == this.resultSlot.field_7874) {
                class_1792 item = slotStack.method_7909();
                item.method_7843(slotStack, player.method_37908(), player);
                if (!this.method_7616(slotStack, this.container.method_5439(), this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(slotStack, stack);
            } else if (slotIndex < this.container.method_5439() ? !this.method_7616(slotStack, this.container.method_5439(), this.field_7761.size(), true) : (slotIndex < this.container.method_5439() + 27 ? !this.method_7616(slotStack, this.container.method_5439() + 27, this.field_7761.size(), false) : !this.method_7616(slotStack, this.container.method_5439(), this.field_7761.size() - 9, false))) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            }
            slot.method_7668();
            if (slotStack.method_7947() == stack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, slotStack);
            this.method_7623();
        }
        return stack;
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot != this.resultSlot && super.method_7613(stack, slot);
    }

    @Override
    public boolean isPowered() {
        return this.data.method_17390(0) != 0;
    }

    @Nullable
    public WorkbenchContructingRecipe getSelectedRecipe() {
        int index = this.selectedRecipe.method_17407();
        return index != -1 ? this.recipes.get(index) : null;
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipe.method_17407();
    }

    public boolean shouldSearchNeighbours() {
        return this.searchNeighbours.method_17407() != 0;
    }

    public void toggleSearchNeighbours() {
        this.searchNeighbours.method_17404(this.shouldSearchNeighbours() ? 0 : 1);
        this.method_7623();
    }

    public void updateItemCounts(Map<Integer, Integer> counts) {
        this.counts = counts;
        this.recipeToCraftable.clear();
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    public boolean canCraft(WorkbenchContructingRecipe recipe) {
        return this.isPowered() && this.recipeToCraftable.computeIfAbsent(recipe.method_8114(), id -> {
            HashMap<Integer, Integer> found = new HashMap<Integer, Integer>();
            for (StackedIngredient material : recipe.getMaterials()) {
                if (this.hasMaterials(material, found)) continue;
                return false;
            }
            return true;
        }) != false;
    }

    public boolean hasMaterials(StackedIngredient material, Map<Integer, Integer> counted) {
        int remaining = material.count();
        for (class_1799 stack : material.ingredient().method_8105()) {
            int itemId = class_1792.method_7880((class_1792)stack.method_7909());
            int count = this.counts.getOrDefault(itemId, 0);
            if ((count -= counted.getOrDefault(itemId, 0).intValue()) <= 0) continue;
            if (count >= remaining) {
                counted.merge(itemId, remaining, Integer::sum);
                remaining = 0;
                break;
            }
            counted.merge(itemId, count, Integer::sum);
            remaining -= count;
        }
        return remaining <= 0;
    }

    public void setUpdateCallback(Runnable callback) {
        this.updateCallback = callback;
    }

    private void onCraft() {
        WorkbenchContructingRecipe recipe = this.getSelectedRecipe();
        if (recipe != null && this.workbench.canCraft(recipe)) {
            this.workbench.performCraft(recipe);
            this.updateResultSlot();
            this.access.method_17393((level, pos) -> {
                long time = level.method_8510();
                this.lastSoundTime = time;
                if (this.lastSoundTime != this.lastSoundTime) {
                    level.method_8396(null, pos, (class_3414)ModSounds.BLOCK_WORKBENCH_CRAFT.get(), class_3419.field_15245, 1.0f, 1.0f);
                }
            });
        }
    }

    private class WorkbenchResultSlot
    extends class_1735 {
        public WorkbenchResultSlot(class_1263 container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean method_7680(class_1799 stack) {
            return false;
        }

        public void method_7667(class_1657 player, class_1799 stack) {
            stack.method_7982(player.method_37908(), player, stack.method_7947());
            WorkbenchMenu.this.onCraft();
            super.method_7667(player, stack);
        }
    }
}

