/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lixissbioms.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.mcreator.lixissbioms.world.biome.BigForestBiome;
import net.mcreator.lixissbioms.world.biome.Biom1Biome;
import net.mcreator.lixissbioms.world.biome.Biom2Biome;
import net.mcreator.lixissbioms.world.biome.Biom3Biome;
import net.mcreator.lixissbioms.world.biome.Biom4Biome;
import net.mcreator.lixissbioms.world.biome.Biom5Biome;
import net.mcreator.lixissbioms.world.biome.OazisBiome;
import net.mcreator.lixissbioms.world.biome.TallGrassPlainsBiome;
import net.mcreator.lixissbioms.world.biome.VulcanBiome;
import net.mcreator.lixissbioms.world.biome.WeirdforestBiome;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class LixissBiomsModBiomes {
    public static final DeferredRegister<Biome> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"lixiss_bioms");
    public static final RegistryObject<Biome> MUSHROOM_FOREST = REGISTRY.register("mushroom_forest", Biom2Biome::createBiome);
    public static final RegistryObject<Biome> REDDESERT = REGISTRY.register("reddesert", Biom1Biome::createBiome);
    public static final RegistryObject<Biome> MOSS_FOREST = REGISTRY.register("moss_forest", Biom3Biome::createBiome);
    public static final RegistryObject<Biome> MOSS_FOREST_OVERWORLD = REGISTRY.register("moss_forest_overworld", Biom4Biome::createBiome);
    public static final RegistryObject<Biome> SWAMP_JUNGLE = REGISTRY.register("swamp_jungle", Biom5Biome::createBiome);
    public static final RegistryObject<Biome> OAZIS = REGISTRY.register("oazis", OazisBiome::createBiome);
    public static final RegistryObject<Biome> WEIRDFOREST = REGISTRY.register("weirdforest", WeirdforestBiome::createBiome);
    public static final RegistryObject<Biome> VULCAN = REGISTRY.register("vulcan", VulcanBiome::createBiome);
    public static final RegistryObject<Biome> BIG_FOREST = REGISTRY.register("big_forest", BigForestBiome::createBiome);
    public static final RegistryObject<Biome> TALL_GRASS_PLAINS = REGISTRY.register("tall_grass_plains", TallGrassPlainsBiome::createBiome);

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        Registry dimensionTypeRegistry = server.m_206579_().m_175515_(Registry.f_122818_);
        Registry biomeRegistry = server.m_206579_().m_175515_(Registry.f_122885_);
        WorldGenSettings worldGenSettings = server.m_129910_().m_5961_();
        for (Map.Entry entry : worldGenSettings.m_204655_().m_6579_()) {
            DimensionType dimensionType = (DimensionType)((LevelStem)entry.getValue()).m_204521_().m_203334_();
            if (dimensionType != dimensionTypeRegistry.m_123013_(BuiltinDimensionTypes.f_223538_)) continue;
            ChunkGenerator chunkGenerator = ((LevelStem)entry.getValue()).m_63990_();
            BiomeSource biomeSource = chunkGenerator.m_62218_();
            if (biomeSource instanceof MultiNoiseBiomeSource) {
                MultiNoiseBiomeSource noiseSource = (MultiNoiseBiomeSource)biomeSource;
                ArrayList<Pair> parameters = new ArrayList<Pair>(noiseSource.f_48435_.m_186850_());
                for (Climate.ParameterPoint parameterPoint : Biom2Biome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)MUSHROOM_FOREST.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : Biom1Biome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)REDDESERT.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : Biom4Biome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)MOSS_FOREST_OVERWORLD.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : Biom5Biome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SWAMP_JUNGLE.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : OazisBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)OAZIS.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : WeirdforestBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)WEIRDFOREST.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : VulcanBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)VULCAN.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : BigForestBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)BIG_FOREST.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : TallGrassPlainsBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)TALL_GRASS_PLAINS.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : Biom3Biome.UNDERGROUND_PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)MOSS_FOREST.getId()))));
                }
                chunkGenerator.f_62137_ = new MultiNoiseBiomeSource(new Climate.ParameterList(parameters), noiseSource.f_48438_);
                chunkGenerator.f_223020_ = Suppliers.memoize(() -> FeatureSorter.m_220603_(List.copyOf(chunkGenerator.f_62137_.m_207840_()), biome -> ((BiomeGenerationSettings)chunkGenerator.f_223021_.apply(biome)).m_47818_(), (boolean)true));
            }
            if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
            NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.f_64318_.m_203334_();
            SurfaceRules.RuleSource currentRuleSource = noiseGeneratorSettings.f_188871_();
            if (!(currentRuleSource instanceof SurfaceRules.SequenceRuleSource)) continue;
            SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
            ArrayList<SurfaceRules.RuleSource> surfaceRules = new ArrayList<SurfaceRules.RuleSource>(sequenceRuleSource.f_189697_());
            surfaceRules.add(1, LixissBiomsModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)MOSS_FOREST.getId()), Blocks.f_152544_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_49992_.m_49966_()));
            surfaceRules.add(1, LixissBiomsModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)MUSHROOM_FOREST.getId()), Blocks.f_50195_.m_49966_(), Blocks.f_50546_.m_49966_(), Blocks.f_49992_.m_49966_()));
            surfaceRules.add(1, LixissBiomsModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)REDDESERT.getId()), Blocks.f_49993_.m_49966_(), Blocks.f_49993_.m_49966_(), Blocks.f_49993_.m_49966_()));
            surfaceRules.add(1, LixissBiomsModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)MOSS_FOREST_OVERWORLD.getId()), Blocks.f_152544_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_49992_.m_49966_()));
            surfaceRules.add(1, LixissBiomsModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)SWAMP_JUNGLE.getId()), Blocks.f_50440_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_49992_.m_49966_()));
            surfaceRules.add(1, LixissBiomsModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)OAZIS.getId()), Blocks.f_49990_.m_49966_(), Blocks.f_49992_.m_49966_(), Blocks.f_49992_.m_49966_()));
            surfaceRules.add(1, LixissBiomsModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)WEIRDFOREST.getId()), Blocks.f_50440_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_49992_.m_49966_()));
            surfaceRules.add(1, LixissBiomsModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)VULCAN.getId()), Blocks.f_49991_.m_49966_(), Blocks.f_50080_.m_49966_(), Blocks.f_50723_.m_49966_()));
            surfaceRules.add(1, LixissBiomsModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)BIG_FOREST.getId()), Blocks.f_50440_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_49992_.m_49966_()));
            surfaceRules.add(1, LixissBiomsModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)TALL_GRASS_PLAINS.getId()), Blocks.f_50440_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_49992_.m_49966_()));
            NoiseGeneratorSettings moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.f_64439_(), noiseGeneratorSettings.f_64440_(), noiseGeneratorSettings.f_64441_(), noiseGeneratorSettings.f_209353_(), SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.f_224370_(), noiseGeneratorSettings.f_64444_(), noiseGeneratorSettings.f_64445_(), noiseGeneratorSettings.f_158533_(), noiseGeneratorSettings.m_209369_(), noiseGeneratorSettings.f_209354_());
            noiseGenerator.f_64318_ = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
        }
    }

    private static SurfaceRules.RuleSource preliminarySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)groundBlock)), SurfaceRules.m_189390_((BlockState)underwaterBlock)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)undergroundBlock))})));
    }

    private static SurfaceRules.RuleSource anySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)groundBlock)), SurfaceRules.m_189390_((BlockState)underwaterBlock)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)undergroundBlock))}));
    }
}

