/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.curios.heart;

import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.AttrAdder;
import com.xiaoyue.celestial_artifacts.content.core.token.BaseTickingToken;
import com.xiaoyue.celestial_artifacts.content.core.token.CAAttackToken;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import com.xiaoyue.celestial_artifacts.utils.CurioUtils;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class DemonHeart
extends BaseTickingToken
implements CAAttackToken {
    private static double damageBonusFactor() {
        return (Double)CAModConfig.COMMON.heart.demonHeartDamageBonus.get();
    }

    private static double damageReductionFactor() {
        return (Double)CAModConfig.COMMON.heart.demonHeartDamageReduction.get();
    }

    protected AttrAdder attr(Player player) {
        return AttrAdder.of("demon_heart", () -> Attributes.f_22285_, AttributeModifier.Operation.ADDITION, () -> CurioUtils.getCurseAmount(player));
    }

    @Override
    protected void removeImpl(Player player) {
        this.attr(player).removeImpl(player);
    }

    @Override
    protected void tickImpl(Player player) {
        this.attr(player).tickImpl(player);
        int curse = CurioUtils.getCurseAmount(player);
        if (curse >= 3 && player.m_6060_()) {
            player.m_20095_();
        }
        if (curse >= 5) {
            if (player.m_21023_(MobEffects.f_19613_)) {
                player.m_21195_(MobEffects.f_19613_);
            }
            if (player.m_21023_(MobEffects.f_19597_)) {
                player.m_21195_(MobEffects.f_19597_);
            }
        }
    }

    @Override
    public void addText(@Nullable Level level, List<Component> list) {
        list.add((Component)TextFacet.wrap(CALang.Heart.DEMON_HEART_1.get(new MutableComponent[0]).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.inner(CALang.Heart.DEMON_HEART_2.get(TextFacet.num(1)).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.inner(CALang.Heart.DEMON_HEART_3.get(TextFacet.perc(DemonHeart.damageBonusFactor())).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.inner(CALang.Heart.DEMON_HEART_4.get(TextFacet.perc(DemonHeart.damageReductionFactor())).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.wrap(CALang.Heart.DEMON_HEART_5.get(new MutableComponent[0]).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.wrap(CALang.Heart.DEMON_HEART_6.get(new MutableComponent[0]).m_130940_(ChatFormatting.GRAY)));
    }

    @Override
    public void onPlayerHurtTarget(Player player, AttackCache cache) {
        cache.addHurtModifier(DamageModifier.multTotal((float)((float)(1.0 + (double)CurioUtils.getCurseAmount(player) * DemonHeart.damageBonusFactor()))));
    }

    @Override
    public void onPlayerDamaged(Player player, AttackCache cache) {
        cache.addDealtModifier(DamageModifier.multTotal((float)((float)(1.0 - (double)CurioUtils.getCurseAmount(player) * DemonHeart.damageReductionFactor()))));
    }
}

