/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.curios.necklace;

import com.xiaoyue.celestial_artifacts.content.core.modular.MultiLineText;
import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.CAAttackToken;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import com.xiaoyue.celestial_core.data.CCDamageTypes;
import com.xiaoyue.celestial_core.utils.EntityUtils;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2library.init.events.GeneralEventHandler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LockOfAbyss
implements MultiLineText,
CAAttackToken {
    private double extraDamageFactor() {
        return (Double)CAModConfig.COMMON.necklace.lockOfAbyssExtraDamage.get();
    }

    private int duration() {
        return (Integer)CAModConfig.COMMON.necklace.lockOfAbyssDuration.get();
    }

    private int threshold() {
        return (Integer)CAModConfig.COMMON.necklace.lockOfAbyssThreshold.get();
    }

    @Override
    public void addText(@Nullable Level level, List<Component> list) {
        list.add((Component)TextFacet.wrap(CALang.Necklace.LOCK_OF_ABYSS_1.get(TextFacet.num(this.duration())).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.wrap(CALang.Necklace.LOCK_OF_ABYSS_2.get(new MutableComponent[0]).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.wrap(CALang.Necklace.LOCK_OF_ABYSS_3.get(TextFacet.num(this.threshold())).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.wrap(CALang.Necklace.LOCK_OF_ABYSS_4.get(TextFacet.perc(this.extraDamageFactor())).m_130940_(ChatFormatting.GRAY)));
    }

    @Override
    public void onPlayerDamageTargetFinal(Player player, AttackCache cache) {
        if (CAAttackToken.getSource(cache).m_269533_(DamageTypeTags.f_273918_)) {
            return;
        }
        LivingEntity entity = cache.getAttackTarget();
        MobEffectInstance ins = entity.m_21124_(MobEffects.f_19597_);
        if (ins != null) {
            int amplifier = ins.m_19564_();
            if (amplifier >= this.threshold() - 1) {
                entity.m_21195_(MobEffects.f_19597_);
                double dmg = (double)cache.getDamageDealt() * this.extraDamageFactor();
                GeneralEventHandler.schedule(() -> entity.m_6469_(CCDamageTypes.abyss((LivingEntity)player), (float)dmg));
            } else {
                EntityUtils.addEct((LivingEntity)entity, (MobEffect)MobEffects.f_19597_, (int)(this.duration() * 20), (int)(amplifier + 1));
            }
        } else {
            EntityUtils.addEct((LivingEntity)entity, (MobEffect)MobEffects.f_19597_, (int)(this.duration() * 20), (int)0);
        }
    }
}

