/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.curios.pendant;

import com.xiaoyue.celestial_artifacts.content.core.modular.MultiLineText;
import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.CAAttackToken;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import com.xiaoyue.celestial_core.utils.CCUtils;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ShadowPendant
implements MultiLineText,
CAAttackToken {
    private static double damageHealFactor() {
        return (Double)CAModConfig.COMMON.pendant.shadowPendantDamageHeal.get();
    }

    private static double damageBonusFactor() {
        return (Double)CAModConfig.COMMON.pendant.shadowPendantDamageBonus.get();
    }

    private static double damageReductionFactor() {
        return (Double)CAModConfig.COMMON.pendant.shadowPendantDamageReduction.get();
    }

    private static int light() {
        return (Integer)CAModConfig.COMMON.pendant.shadowPendantLightLevel.get();
    }

    @Override
    public void addText(@Nullable Level level, List<Component> list) {
        list.add((Component)TextFacet.wrap(CALang.Pendant.SHADOW_1.get(TextFacet.perc(ShadowPendant.damageHealFactor())).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.wrap(CALang.Pendant.SHADOW_2.get(new MutableComponent[0]).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.wrap(CALang.Pendant.SHADOW_3.get(TextFacet.num(ShadowPendant.light())).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.inner(CALang.Pendant.SHADOW_4.get(TextFacet.perc(ShadowPendant.damageBonusFactor())).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.inner(CALang.Pendant.SHADOW_5.get(TextFacet.perc(ShadowPendant.damageReductionFactor())).m_130940_(ChatFormatting.GRAY)));
    }

    @Override
    public void onPlayerHurtTarget(Player player, AttackCache cache) {
        int brightness = CCUtils.getLight((Level)player.m_9236_(), (BlockPos)player.m_20183_().m_7494_());
        if (brightness < ShadowPendant.light()) {
            int add = ShadowPendant.light() - brightness;
            cache.addHurtModifier(DamageModifier.multTotal((float)((float)(1.0 + (double)add * ShadowPendant.damageBonusFactor()))));
        }
    }

    @Override
    public void onPlayerDamageTargetFinal(Player player, AttackCache cache) {
        player.m_5634_((float)((double)cache.getDamageDealt() * ShadowPendant.damageHealFactor()));
    }

    @Override
    public void onPlayerDamaged(Player player, AttackCache cache) {
        ServerLevel sl;
        int brightness;
        Level level = player.m_9236_();
        if (level instanceof ServerLevel && (brightness = CCUtils.getLight((Level)(sl = (ServerLevel)level), (BlockPos)player.m_20183_().m_7494_())) < ShadowPendant.light()) {
            int add = ShadowPendant.light() - brightness;
            cache.addDealtModifier(DamageModifier.multTotal((float)((float)(1.0 - (double)add * ShadowPendant.damageReductionFactor()))));
        }
    }
}

