/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.curios.ring;

import com.xiaoyue.celestial_artifacts.content.core.modular.SingleLineText;
import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.TickFacet;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class RingOfLife
implements SingleLineText,
TickFacet {
    private static int intervalFactor() {
        return (Integer)CAModConfig.COMMON.ring.ringOfLifeEffectInterval.get();
    }

    @Override
    public MutableComponent getLine() {
        return CALang.Ring.RING_OF_LIFE.get(TextFacet.num(RingOfLife.intervalFactor()));
    }

    @Override
    public void tick(LivingEntity entity, ItemStack stack) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).m_9236_().m_5776_() && player.f_19797_ % (RingOfLife.intervalFactor() * 20) == 0) {
            BlockPos entityPos = new BlockPos(player.m_146903_(), player.m_146904_(), player.m_146907_());
            int range = 5;
            int limit = 0;
            ArrayList<BlockPos> list = new ArrayList<BlockPos>();
            for (BlockPos pos : BlockPos.m_121976_((int)(entityPos.m_123341_() - range), (int)(entityPos.m_123342_() - range), (int)(entityPos.m_123343_() - range), (int)(entityPos.m_123341_() + range), (int)(entityPos.m_123342_() + range), (int)(entityPos.m_123343_() + range))) {
                BlockState block = player.m_9236_().m_8055_(pos);
                Block block2 = block.m_60734_();
                if (!(block2 instanceof BonemealableBlock)) continue;
                BonemealableBlock bmb = (BonemealableBlock)block2;
                if (block.m_280296_() || !bmb.m_7370_((LevelReader)player.m_9236_(), pos, block, false)) continue;
                list.add(new BlockPos((Vec3i)pos));
            }
            if (!list.isEmpty()) {
                RandomSource random = player.m_217043_();
                while (!list.isEmpty() && limit < 3) {
                    BlockPos pos;
                    pos = (BlockPos)list.remove(random.m_188503_(list.size()));
                    BlockState state = player.m_9236_().m_8055_(pos);
                    if (!BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.f_42499_), (Level)player.m_9236_(), (BlockPos)pos, (Player)player) || state == player.m_9236_().m_8055_(pos)) continue;
                    ++limit;
                    player.m_9236_().m_46796_(2005, pos, 0);
                }
            }
        }
    }
}

