/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.data;

import dev.xkmc.l2library.compat.curios.CurioEntityBuilder;
import dev.xkmc.l2library.compat.curios.CurioSlotBuilder;
import dev.xkmc.l2library.compat.curios.SlotCondition;
import dev.xkmc.l2library.serial.config.RecordDataProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;

public class CASlotGen
extends RecordDataProvider {
    public CASlotGen(DataGenerator generator) {
        super(generator, "Celestial Artifact Slot Provider");
    }

    public void add(BiConsumer<String, Record> map) {
        for (Type e : Type.values()) {
            int order = 20 + e.ordinal();
            if (e == Type.CATASTROPHE) {
                order = -5;
            }
            map.accept("celestial_artifacts/curios/slots/" + e.id(), (Record)new CurioSlotBuilder(order, new ResourceLocation("celestial_artifacts", "slot/empty_" + e.id() + "_slot").toString(), e.slot, CurioSlotBuilder.Operation.SET));
        }
        map.accept("celestial_artifacts/curios/entities/player_vanilla", (Record)new CurioEntityBuilder(new ArrayList<ResourceLocation>(List.of(new ResourceLocation("player"))), new ArrayList<String>(List.of("back", "body", "bracelet", "charm", "head", "necklace", "ring")), SlotCondition.of((String[])new String[0])));
        map.accept("celestial_artifacts/curios/entities/player_celestial", (Record)new CurioEntityBuilder(new ArrayList<ResourceLocation>(List.of(new ResourceLocation("player"))), new ArrayList<String>(Stream.of(Type.values()).map(Type::id).toList()), SlotCondition.of((String[])new String[0])));
    }

    public static enum Type {
        SCROLL(1),
        PENDANT(1),
        HEART(1),
        CATASTROPHE(1),
        ETCHING(0);

        private final int slot;

        private Type(int slot) {
            this.slot = slot;
        }

        public String id() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

