/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.events;

import com.xiaoyue.celestial_artifacts.content.curios.charm.CursedTotem;
import com.xiaoyue.celestial_artifacts.content.curios.charm.GluttonyBadge;
import com.xiaoyue.celestial_artifacts.content.curios.charm.SacrificialObject;
import com.xiaoyue.celestial_artifacts.content.curios.curse.CatastropheScroll;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import com.xiaoyue.celestial_artifacts.data.CATagGen;
import com.xiaoyue.celestial_artifacts.register.CAItems;
import com.xiaoyue.celestial_artifacts.utils.CurioUtils;
import dev.xkmc.l2library.base.effects.EffectBuilder;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.EnderManAngerEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingUseTotemEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.event.CurioEquipEvent;

@Mod.EventBusSubscriber(modid="celestial_artifacts", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CAMiscCuriosHandler {
    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41763_() && stack.m_41776_() >= CatastropheScroll.getOriginTrigger()) {
            CatastropheScroll.Curses.ORIGIN.trigger(player);
        }
        for (ItemStack e : player.m_6168_()) {
            if (!e.m_41793_()) continue;
            CatastropheScroll.Curses.CHAOS.trigger(player);
            break;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEnderManAnger(EnderManAngerEvent event) {
        ServerPlayer sp;
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer && (sp = (ServerPlayer)player).m_142582_((Entity)event.getEntity())) {
            CatastropheScroll.Curses.END.trigger((Player)sp);
        }
    }

    @SubscribeEvent
    public static void onEquipEtching(CurioEquipEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)livingEntity;
            if (event.getStack().m_204117_(CATagGen.ETCHINGS)) {
                CatastropheScroll.Curses.TRUTH.trigger((Player)sp);
            }
        }
    }

    @SubscribeEvent
    public static void onArrowHit(ProjectileImpactEvent event) {
        Player player;
        AbstractArrow arrow;
        Entity entity;
        Projectile projectile = event.getProjectile();
        Entity entity2 = event.getEntity();
        if (projectile instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)projectile).m_19749_()) instanceof Player && CurioUtils.hasCurio(player = (Player)entity, (Item)CAItems.FLAME_ARROW_BAG.get())) {
            entity2.m_20254_(((Integer)CAModConfig.COMMON.back.flameArrowBagTime.get()).intValue());
        }
    }

    @SubscribeEvent
    public static void onAddedEffect(MobEffectEvent.Added event) {
        MobEffectInstance instance = event.getEffectInstance();
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (instance.m_19544_().m_19486_()) {
            CatastropheScroll.Curses.NIHILITY.trigger(player);
        }
        if (instance.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) {
            return;
        }
        if (!CatastropheScroll.Curses.NIHILITY.cursing(player)) {
            return;
        }
        double factor = CatastropheScroll.getNihilityCurse();
        new EffectBuilder(instance).setDuration((int)((double)instance.m_19557_() * (1.0 + factor)));
    }

    @SubscribeEvent
    public static void onFinishItemUse(LivingEntityUseItemEvent.Finish event) {
        Player player;
        ItemStack itemStack = event.getItem();
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && CurioUtils.hasCurio(player = (Player)entity, (Item)CAItems.GLUTTONY_BADGE.get()) && itemStack.m_41780_() == UseAnim.EAT) {
            player.m_7292_(GluttonyBadge.effAtk());
            player.m_7292_(GluttonyBadge.effReg());
        }
    }

    @SubscribeEvent
    public static void onStarItemUse(LivingEntityUseItemEvent.Tick event) {
        Player player;
        ItemStack itemStack = event.getItem();
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && CurioUtils.hasCurio(player = (Player)entity, (Item)CAItems.SPIRIT_BRACELET.get()) && CurioUtils.isRangeUseAnim(itemStack.m_41780_())) {
            event.setDuration(event.getDuration() - 1);
        }
    }

    @SubscribeEvent
    public static void onUseTotem(LivingUseTotemEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        if (entity instanceof Player && CurioUtils.hasCurio(player = (Player)entity, (Item)CAItems.CURSED_TOTEM.get()) && attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            livingEntity.m_7292_(CursedTotem.eff());
        }
    }

    @SubscribeEvent
    public static void onChangeLevel(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player entity = event.getEntity();
        if (CurioUtils.hasCurio(entity, (Item)CAItems.TRAVELER_SCROLL.get())) {
            entity.m_7292_(CAModConfig.COMMON.scroll.travelerScrollSpeedEffect());
            entity.m_7292_(CAModConfig.COMMON.scroll.travelerScrollRegenEffect());
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (CurioUtils.hasCurio(player, (Item)CAItems.SACRIFICIAL_OBJECT.get())) {
                SacrificialObject.onPlayerDeath(player);
            }
        }
    }

    public static void onEnchTable(@Nullable Slot slot, List<EnchantmentInstance> original) {
        Container container;
        if (slot != null && (container = slot.f_40218_) instanceof Inventory) {
            Inventory inv = (Inventory)container;
            Player player = inv.f_35978_;
            int lv = (Integer)CAModConfig.COMMON.pendant.chaoticPendantEnchantLevel.get();
            if (CurioUtils.hasCurio(player, (Item)CAItems.CHAOTIC_PENDANT.get())) {
                for (int i = 0; i < original.size(); ++i) {
                    EnchantmentInstance ins = original.get(i);
                    int ilv = Math.max(ins.f_44948_, Math.min(ins.f_44947_.m_6586_(), ins.f_44948_ + lv));
                    original.set(i, new EnchantmentInstance(ins.f_44947_, ilv));
                }
            }
        }
    }
}

