/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.register;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.xiaoyue.celestial_artifacts.CelestialArtifacts;
import com.xiaoyue.celestial_artifacts.content.core.attack.SimpleListener;
import com.xiaoyue.celestial_artifacts.content.core.effect.ConditionalEffectFacet;
import com.xiaoyue.celestial_artifacts.content.core.effect.EffectFacet;
import com.xiaoyue.celestial_artifacts.content.core.effect.HurtPlayerEffectFacet;
import com.xiaoyue.celestial_artifacts.content.core.effect.HurtTargetEffectFacet;
import com.xiaoyue.celestial_artifacts.content.core.feature.BreakSpeedFeature;
import com.xiaoyue.celestial_artifacts.content.core.feature.XpBonusFeature;
import com.xiaoyue.celestial_artifacts.content.core.modular.AttrFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.IFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.ModularCurio;
import com.xiaoyue.celestial_artifacts.content.core.modular.SlotFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.CAAttackToken;
import com.xiaoyue.celestial_artifacts.content.core.token.InvulToken;
import com.xiaoyue.celestial_artifacts.content.core.token.SetTokenFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.TokenFacet;
import com.xiaoyue.celestial_artifacts.content.curios.back.LeechScabbard;
import com.xiaoyue.celestial_artifacts.content.curios.back.TwistedScabbard;
import com.xiaoyue.celestial_artifacts.content.curios.body.ForestCloak;
import com.xiaoyue.celestial_artifacts.content.curios.bracelet.CharmingBracelet;
import com.xiaoyue.celestial_artifacts.content.curios.bracelet.HiddenBracelet;
import com.xiaoyue.celestial_artifacts.content.curios.bracelet.ScarletBracelet;
import com.xiaoyue.celestial_artifacts.content.curios.bracelet.SpiritBracelet;
import com.xiaoyue.celestial_artifacts.content.curios.charm.AbyssWillBadge;
import com.xiaoyue.celestial_artifacts.content.curios.charm.AngelHeart;
import com.xiaoyue.celestial_artifacts.content.curios.charm.AngelPearl;
import com.xiaoyue.celestial_artifacts.content.curios.charm.CorruptBadge;
import com.xiaoyue.celestial_artifacts.content.curios.charm.CursedProtector;
import com.xiaoyue.celestial_artifacts.content.curios.charm.CursedTalisman;
import com.xiaoyue.celestial_artifacts.content.curios.charm.CursedTotem;
import com.xiaoyue.celestial_artifacts.content.curios.charm.DemonCurse;
import com.xiaoyue.celestial_artifacts.content.curios.charm.GluttonyBadge;
import com.xiaoyue.celestial_artifacts.content.curios.charm.HolySword;
import com.xiaoyue.celestial_artifacts.content.curios.charm.HolyTalisman;
import com.xiaoyue.celestial_artifacts.content.curios.charm.KnightShelter;
import com.xiaoyue.celestial_artifacts.content.curios.charm.SacrificialObject;
import com.xiaoyue.celestial_artifacts.content.curios.charm.SolarMagnet;
import com.xiaoyue.celestial_artifacts.content.curios.charm.SoulBox;
import com.xiaoyue.celestial_artifacts.content.curios.charm.TwistedBrain;
import com.xiaoyue.celestial_artifacts.content.curios.charm.UndeadCharm;
import com.xiaoyue.celestial_artifacts.content.curios.charm.WarDeadBadge;
import com.xiaoyue.celestial_artifacts.content.curios.curse.CatastropheScroll;
import com.xiaoyue.celestial_artifacts.content.curios.head.AbyssCore;
import com.xiaoyue.celestial_artifacts.content.curios.head.AngelDesire;
import com.xiaoyue.celestial_artifacts.content.curios.head.EvilEye;
import com.xiaoyue.celestial_artifacts.content.curios.head.GuardianEye;
import com.xiaoyue.celestial_artifacts.content.curios.head.PrayerCrown;
import com.xiaoyue.celestial_artifacts.content.curios.head.SakuraHairpin;
import com.xiaoyue.celestial_artifacts.content.curios.head.SeaGodCrown;
import com.xiaoyue.celestial_artifacts.content.curios.head.SpiritCrown;
import com.xiaoyue.celestial_artifacts.content.curios.head.YellowDuck;
import com.xiaoyue.celestial_artifacts.content.curios.heart.DemonHeart;
import com.xiaoyue.celestial_artifacts.content.curios.heart.TwistedHeart;
import com.xiaoyue.celestial_artifacts.content.curios.necklace.EmeraldNecklace;
import com.xiaoyue.celestial_artifacts.content.curios.necklace.EnderProtector;
import com.xiaoyue.celestial_artifacts.content.curios.necklace.GallopNecklace;
import com.xiaoyue.celestial_artifacts.content.curios.necklace.HolyNecklace;
import com.xiaoyue.celestial_artifacts.content.curios.necklace.LockOfAbyss;
import com.xiaoyue.celestial_artifacts.content.curios.pendant.ShadowPendant;
import com.xiaoyue.celestial_artifacts.content.curios.ring.FlightRing;
import com.xiaoyue.celestial_artifacts.content.curios.ring.NetherFire;
import com.xiaoyue.celestial_artifacts.content.curios.ring.RingOfLife;
import com.xiaoyue.celestial_artifacts.content.curios.scroll.SeaGodScroll;
import com.xiaoyue.celestial_artifacts.content.curios.scroll.SkywalkerScroll;
import com.xiaoyue.celestial_artifacts.content.curios.scroll.TwistedScroll;
import com.xiaoyue.celestial_artifacts.content.curios.set.EmeraldSet;
import com.xiaoyue.celestial_artifacts.content.curios.set.SeaGodSet;
import com.xiaoyue.celestial_artifacts.content.curios.set.SpiritSet;
import com.xiaoyue.celestial_artifacts.content.items.item.BacktrackMirror;
import com.xiaoyue.celestial_artifacts.content.items.item.PurifiedPowder;
import com.xiaoyue.celestial_artifacts.content.items.item.RepentMirror;
import com.xiaoyue.celestial_artifacts.content.items.item.UnluckyPotato;
import com.xiaoyue.celestial_artifacts.content.items.tool.EarthAxe;
import com.xiaoyue.celestial_artifacts.content.items.tool.EarthHoe;
import com.xiaoyue.celestial_artifacts.content.items.tool.EarthPickaxe;
import com.xiaoyue.celestial_artifacts.content.items.tool.EarthShovel;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import com.xiaoyue.celestial_core.content.generic.CCTooltipItem;
import com.xiaoyue.celestial_core.register.CCAttributes;
import com.xiaoyue.celestial_core.register.CCEffects;
import com.xiaoyue.celestial_core.utils.EntityUtils;
import com.xiaoyue.celestial_core.utils.IRarityUtils;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeMod;

public class CAItems {
    public static final LinkedHashSet<String> ALL_CURIOS = new LinkedHashSet();
    public static final ItemEntry<CCTooltipItem> THE_END_DUST = CAItems.material("the_end_dust", p -> new CCTooltipItem(new Item.Properties().m_41497_(Rarity.EPIC), false, () -> CALang.Tooltip.END_DUST.get(CALang.Modular.curseItem(), TextFacet.perc((Double)CAModConfig.COMMON.materials.endDustDropChance.get()))));
    public static final ItemEntry<CCTooltipItem> NEBULA_CUBE = CAItems.material("nebula_cube", p -> new CCTooltipItem(new Item.Properties().m_41497_(Rarity.EPIC), false, () -> CALang.Tooltip.NEBULA_CUBE.get(new MutableComponent[0])));
    public static final ItemEntry<ModularCurio> GOLD_RING = CAItems.ring("gold_ring", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.of(EffectFacet.of(() -> MobEffects.f_19621_))));
    public static final ItemEntry<ModularCurio> AMETHYST_RING = CAItems.ring("amethyst_ring", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[2];
        iFacetArray[0] = EffectFacet.of(() -> MobEffects.f_19611_);
        iFacetArray[1] = AttrFacet.multBase(() -> Attributes.f_22281_, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.ring.amethystRingDamage).get());
        return ModularCurio.of(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> DIAMOND_RING = CAItems.ring("diamond_ring", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(Rarity.RARE).build(EffectFacet.of(() -> MobEffects.f_19600_))));
    public static final ItemEntry<ModularCurio> EMERALD_RING = CAItems.ring("emerald_ring", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(IRarityUtils.GREEN).build(AttrFacet.add(() -> Attributes.f_22286_, () -> 1.0), CAItems.emeraldSet())));
    public static final ItemEntry<ModularCurio> FLIGHT_RING = CAItems.ring("flight_ring", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(Rarity.UNCOMMON).build(new TokenFacet<FlightRing>("flight_ring", FlightRing::new))));
    public static final ItemEntry<ModularCurio> NETHERITE_RING = CAItems.ring("netherite_ring", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[2];
        iFacetArray[0] = EffectFacet.of(() -> MobEffects.f_19607_);
        iFacetArray[1] = SimpleListener.protect(() -> CALang.Condition.NETHER.get(new MutableComponent[0]), (p, a, c) -> p.m_9236_().m_46472_().equals((Object)Level.f_46429_), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.ring.netheriteRingProtection).get());
        return ModularCurio.builder().rarity(Rarity.RARE).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> RING_OF_LIFE = CAItems.ring("ring_of_life", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(IRarityUtils.GREEN).build(new RingOfLife())));
    public static final ItemEntry<ModularCurio> THUNDER_RING = CAItems.ring("thunder_ring", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(Rarity.RARE).build(SimpleListener.negateType(CALang.DamageTypes.LIGHTNING))));
    public static final ItemEntry<ModularCurio> NETHER_FIRE = CAItems.ring("nether_fire", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(Rarity.RARE).build(SimpleListener.negateType(CALang.DamageTypes.FIRE), new NetherFire())));
    public static final ItemEntry<ModularCurio> FREEZE_RING = CAItems.ring("freeze_ring", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(Rarity.RARE).build(SimpleListener.negateType(CALang.DamageTypes.FREEZE))));
    public static final ItemEntry<ModularCurio> WAR_DEAD_BADGE = CAItems.charm("war_dead_badge", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().requireCS().rarity(IRarityUtils.DARK_PURPLE).build(new TokenFacet<WarDeadBadge>("war_dead_badge", WarDeadBadge::new))));
    public static final ItemEntry<ModularCurio> UNDEAD_CHARM = CAItems.charm("undead_charm", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().requireCS().rarity(Rarity.RARE).build(new UndeadCharm())));
    public static final ItemEntry<ModularCurio> DESTROYER_BADGE = CAItems.charm("destroyer_badge", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[3];
        iFacetArray[0] = AttrFacet.multTotal(() -> Attributes.f_22281_, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.charm.destroyerBadgeAttack).get());
        iFacetArray[1] = AttrFacet.multTotal(() -> ((RegistryEntry)L2DamageTracker.REDUCTION).get(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.charm.destroyerBadgeDamagePenalty).get());
        iFacetArray[2] = SimpleListener.hurtBonus(() -> CALang.Condition.LOW_HEALTH.get(TextFacet.perc((Double)CAModConfig.COMMON.charm.destroyerBadgeThreshold.get())), (p, t, c) -> (double)p.m_21223_() <= (Double)CAModConfig.COMMON.charm.destroyerBadgeThreshold.get() * (double)p.m_21233_(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.charm.destroyerBadgeHurtBonus).get());
        return ModularCurio.builder().rarity(Rarity.EPIC).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> TWISTED_BRAIN = CAItems.charm("twisted_brain", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().requireCS().rarity(Rarity.EPIC).loot(1).build(new TwistedBrain())));
    public static final ItemEntry<ModularCurio> CORRUPT_BADGE = CAItems.charm("corrupt_badge", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().requireCS().rarity(IRarityUtils.DARK_PURPLE).build(new TokenFacet<CorruptBadge>("corrupt_badge", CorruptBadge::new))));
    public static final ItemEntry<ModularCurio> CURSED_TALISMAN = CAItems.charm("cursed_talisman", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().requireCS().rarity(IRarityUtils.DARK_PURPLE).build(new TokenFacet<CursedTalisman>("cursed_talisman", CursedTalisman::new))));
    public static final ItemEntry<ModularCurio> CURSED_PROTECTOR = CAItems.charm("cursed_protector", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[3];
        iFacetArray[0] = AttrFacet.add(() -> Attributes.f_22278_, () -> 1.0);
        iFacetArray[1] = SimpleListener.protect(() -> CALang.Condition.FRONT_DAMAGE.get(new MutableComponent[0]), (p, a, c) -> !EntityUtils.isLookingBehindTarget((LivingEntity)p, (Vec3)a.m_146892_()), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.charm.cursedProtectorFrontProtect).get());
        iFacetArray[2] = new CursedProtector();
        return ModularCurio.builder().requireCS().rarity(Rarity.EPIC).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> CURSED_TOTEM = CAItems.charm("cursed_totem", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().requireCS().rarity(IRarityUtils.DARK_PURPLE).build(CursedTotem.TOKEN)));
    public static final ItemEntry<ModularCurio> HOLY_TALISMAN = CAItems.charm("holy_talisman", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(Rarity.UNCOMMON).build(new HolyTalisman())));
    public static final ItemEntry<ModularCurio> HOLY_SWORD = CAItems.charm("holy_sword", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[2];
        iFacetArray[0] = AttrFacet.add(() -> ((RegistryEntry)L2DamageTracker.CRIT_RATE).get(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.charm.holySwordCritRate).get());
        iFacetArray[1] = new HolySword();
        return ModularCurio.builder().rarity(Rarity.UNCOMMON).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> ANGEL_HEART = CAItems.charm("angel_heart", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[2];
        iFacetArray[0] = new AngelHeart();
        iFacetArray[1] = SimpleListener.protect(() -> CALang.Condition.LOW_HEALTH.get(TextFacet.perc((Double)CAModConfig.COMMON.charm.angelHeartThreshold.get())), (p, a, c) -> (double)p.m_21223_() <= (Double)CAModConfig.COMMON.charm.angelHeartThreshold.get() * (double)p.m_21233_(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.charm.angelHeartProtection).get());
        return ModularCurio.builder().rarity(Rarity.UNCOMMON).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> ANGEL_PEARL = CAItems.charm("angel_pearl", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(Rarity.UNCOMMON).build(new TokenFacet<AngelPearl>("angel_pearl", AngelPearl::new))));
    public static final ItemEntry<ModularCurio> DEMON_CURSE = CAItems.charm("demon_curse", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(IRarityUtils.DARK_PURPLE).requireCS().build(new TokenFacet<DemonCurse>("demon_curse", DemonCurse::new))));
    public static final ItemEntry<ModularCurio> KNIGHT_SHELTER = CAItems.charm("knight_shelter", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[3];
        iFacetArray[0] = new KnightShelter();
        iFacetArray[1] = AttrFacet.add(() -> Attributes.f_22284_, () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.charm.knightShelterArmor).get());
        iFacetArray[2] = AttrFacet.add(() -> ((RegistryEntry)L2DamageTracker.ABSORB).get(), () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.charm.knightShelterDamageReduction).get());
        return ModularCurio.builder().rarity(Rarity.UNCOMMON).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> SOUL_BOX = CAItems.charm("soul_box", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().requireCS().rarity(Rarity.EPIC).build(new SoulBox())));
    public static final ItemEntry<ModularCurio> SOLAR_MAGNET = CAItems.charm("solar_magnet", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[2];
        iFacetArray[0] = new SolarMagnet();
        iFacetArray[1] = SimpleListener.hurtBonus(() -> CALang.Condition.DAY.get(new MutableComponent[0]), (p, t, c) -> p.m_9236_().m_46461_(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.charm.solarMagnetDamageBonus).get());
        return ModularCurio.builder().rarity(Rarity.RARE).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> GLUTTONY_BADGE = CAItems.charm("gluttony_badge", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[2];
        iFacetArray[0] = new GluttonyBadge();
        iFacetArray[1] = EffectFacet.of(() -> MobEffects.f_19612_, () -> 3, () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.charm.gluttonyBadgeHungerLevel).get());
        return ModularCurio.builder().rarity(Rarity.EPIC).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> MAGIC_HORSESHOE = CAItems.charm("magic_horseshoe", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[3];
        iFacetArray[0] = AttrFacet.multBase(() -> Attributes.f_22279_, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.charm.magicHorseshoeSpeedBonus).get());
        iFacetArray[1] = AttrFacet.add(() -> Attributes.f_22286_, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.charm.magicHorseshoeLuck).get());
        iFacetArray[2] = SimpleListener.protectType(CALang.DamageTypes.FALL, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.charm.magicHorseshoeFallReduction).get());
        return ModularCurio.builder().rarity(Rarity.EPIC).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> BEARING_STAMEN = CAItems.charm("bearing_stamen", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[3];
        iFacetArray[0] = AttrFacet.add(() -> Attributes.f_22276_, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.charm.bearingStamenMaxHealth).get());
        iFacetArray[1] = AttrFacet.add(() -> ((RegistryEntry)CCAttributes.REPLY_POWER).get(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.charm.bearingStamenRegen).get());
        iFacetArray[2] = EffectFacet.of(() -> MobEffects.f_19605_, () -> 2, () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.charm.bearingStamenLevel).get());
        return ModularCurio.builder().rarity(IRarityUtils.GREEN).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> ABYSS_WILL_BADGE = CAItems.charm("abyss_will_badge", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(IRarityUtils.DARK_AQUA).requireCS().build(AbyssWillBadge.TOKEN)));
    public static final ItemEntry<ModularCurio> SANDS_TALISMAN = CAItems.charm("sands_talisman", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[2];
        iFacetArray[0] = XpBonusFeature.simple(() -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.charm.sandsTalismanExpBonus).get());
        iFacetArray[1] = SimpleListener.hurtBonus(() -> CALang.Condition.HOT_REGION.get(new MutableComponent[0]), (p, t, c) -> (double)((Biome)p.m_9236_().m_204166_(p.m_20183_()).get()).m_47554_() >= 0.01, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.charm.sandsTalismanDamageBonus).get());
        return ModularCurio.builder().rarity(Rarity.UNCOMMON).loot(1).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> SACRIFICIAL_OBJECT = CAItems.charm("sacrificial_object", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[2];
        iFacetArray[0] = AttrFacet.multTotal(() -> ((RegistryEntry)L2DamageTracker.REDUCTION).get(), () -> -((Double)CAModConfig.COMMON.charm.sacrificialObjectReduction.get()).doubleValue());
        iFacetArray[1] = new SacrificialObject();
        return ModularCurio.builder().rarity(Rarity.EPIC).requireCS().loot(1).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> HEART_OF_REVENGE = CAItems.heart("heart_of_revenge", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IntSupplier dur = () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.heart.heartOfRevengeValidTime).get();
        IFacet[] iFacetArray = new IFacet[3];
        iFacetArray[0] = AttrFacet.add(() -> ((RegistryEntry)L2DamageTracker.BOW_STRENGTH).get(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.heart.heartOfRevengeBowStrength).get());
        iFacetArray[1] = HurtPlayerEffectFacet.of(EffectFacet.of(() -> MobEffects.f_19600_, dur, () -> 1), EffectFacet.of(() -> MobEffects.f_19606_, dur, () -> 0));
        iFacetArray[2] = SimpleListener.hurtBonus(() -> CALang.Condition.REVENGE.get(TextFacet.num(dur.getAsInt())), (p, t, c) -> p.m_21213_() >= p.f_19797_ - dur.getAsInt() * 20, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.heart.heartOfRevengeDamageBonus).get());
        return ModularCurio.builder().rarity(IRarityUtils.GOLD).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> TWISTED_HEART = CAItems.heart("twisted_heart", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().requireCS().rarity(IRarityUtils.DARK_PURPLE).immune().loot(1).build(new TokenFacet<TwistedHeart>("twisted_heart", TwistedHeart::new))));
    public static final ItemEntry<ModularCurio> GREEDY_HEART = CAItems.heart("greedy_heart", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[1];
        iFacetArray[0] = XpBonusFeature.simple(() -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.heart.greedyHeartXpBonus).get());
        return ModularCurio.builder().requireCS().rarity(Rarity.EPIC).fortune(1).loot(1).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> DEMON_HEART = CAItems.heart("demon_heart", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().requireCS().rarity(Rarity.EPIC).requireCS().build(new TokenFacet<DemonHeart>("demon_heart", DemonHeart::new))));
    public static final ItemEntry<ModularCurio> TRAVELER_SCROLL = CAItems.scroll("traveler_scroll", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        DoubleSupplier sup = () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.scroll.travellerScrollSpeedBonus).get();
        return ModularCurio.builder().rarity(Rarity.UNCOMMON).immune().build(AttrFacet.multBase(() -> Attributes.f_22279_, sup), AttrFacet.multBase(() -> Attributes.f_22280_, sup), AttrFacet.multBase((Supplier<Attribute>)ForgeMod.SWIM_SPEED, sup), TextFacet.line(() -> CALang.Scroll.TRAVELER.get(EffectFacet.getDesc(CAModConfig.COMMON.scroll.travelerScrollSpeedEffect()), EffectFacet.getDesc(CAModConfig.COMMON.scroll.travelerScrollRegenEffect()))));
    }));
    public static final ItemEntry<ModularCurio> SEA_GOD_SCROLL = CAItems.scroll("sea_god_scroll", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[3];
        iFacetArray[0] = new SeaGodScroll();
        iFacetArray[1] = ConditionalEffectFacet.of(false, Entity::m_20071_, () -> CALang.Condition.PLAYER_WET.get(new MutableComponent[0]), EffectFacet.of(() -> MobEffects.f_19600_, 2, 1), EffectFacet.of(() -> MobEffects.f_19606_, 2, 0));
        iFacetArray[2] = CAItems.seaGodSet();
        return ModularCurio.builder().rarity(Rarity.RARE).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> SKYWALKER_SCROLL = CAItems.scroll("skywalker_scroll", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(Rarity.UNCOMMON).build(SkywalkerScroll.TOKEN)));
    public static final ItemEntry<ModularCurio> TWISTED_SCROLL = CAItems.scroll("twisted_scroll", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().requireCS().rarity(IRarityUtils.DARK_PURPLE).loot(1).build(new TwistedScroll())));
    public static final ItemEntry<ModularCurio> EMERALD_BRACELET = CAItems.bracelet("emerald_bracelet", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IntSupplier luck = () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.bracelet.emeraldBraceletLuckReq).get();
        IFacet[] iFacetArray = new IFacet[3];
        iFacetArray[0] = AttrFacet.add(() -> ((RegistryEntry)L2DamageTracker.CRIT_RATE).get(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.bracelet.emeraldBraceletCritRate).get());
        iFacetArray[1] = HurtPlayerEffectFacet.of(e -> e.m_36336_() >= (float)luck.getAsInt(), () -> CALang.Condition.LUCK.get(TextFacet.num(luck.getAsInt())), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.bracelet.emeraldBraceletEffChance).get(), EffectFacet.of(() -> MobEffects.f_19617_, 5, 1));
        iFacetArray[2] = CAItems.emeraldSet();
        return ModularCurio.builder().rarity(IRarityUtils.GREEN).fortune(1).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> LIFE_BRACELET = CAItems.bracelet("life_bracelet", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[2];
        iFacetArray[0] = AttrFacet.add(() -> ((RegistryEntry)CCAttributes.REPLY_POWER).get(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.bracelet.lifeBraceletRegenBonus).get());
        iFacetArray[1] = EffectFacet.of(() -> MobEffects.f_19605_, () -> 4, () -> 0);
        return ModularCurio.builder().rarity(Rarity.RARE).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> PRECIOUS_BRACELET = CAItems.bracelet("precious_bracelet", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[3];
        iFacetArray[0] = AttrFacet.add((Supplier<Attribute>)ForgeMod.BLOCK_REACH, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.bracelet.preciousBraceletReach).get());
        iFacetArray[1] = SlotFacet.of("ring", 1);
        iFacetArray[2] = SimpleListener.protectType(CALang.DamageTypes.MAGIC, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.bracelet.preciousBraceletMagicReduction).get());
        return ModularCurio.builder().rarity(Rarity.EPIC).fortune(1).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> RED_RUBY_BRACELET = CAItems.bracelet("red_ruby_bracelet", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[2];
        iFacetArray[0] = SimpleListener.protectType(CALang.DamageTypes.FIRE, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.bracelet.redRubyBraceletFireReduction).get());
        iFacetArray[1] = HurtPlayerEffectFacet.ofType(e -> e.m_269533_(DamageTypeTags.f_268745_), () -> CALang.Condition.HURT_FIRE.get(new MutableComponent[0]), EffectFacet.of(() -> MobEffects.f_19600_, 3, 0));
        return ModularCurio.builder().rarity(IRarityUtils.RED).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> HIDDEN_BRACELET = CAItems.bracelet("hidden_bracelet", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().requireCS().rarity(IRarityUtils.DARK_PURPLE).build(new TokenFacet<HiddenBracelet>("hidden_bracelet", HiddenBracelet::new))));
    public static final ItemEntry<ModularCurio> SCARLET_BRACELET = CAItems.bracelet("scarlet_bracelet", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().requireCS().rarity(IRarityUtils.RED).build(new ScarletBracelet())));
    public static final ItemEntry<ModularCurio> CHARMING_BRACELET = CAItems.bracelet("charming_bracelet", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
        IFacet[] iFacetArray = new IFacet[2];
        iFacetArray[0] = AttrFacet.add(() -> Attributes.f_22284_, () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.bracelet.charmingBraceletArmor).get());
        iFacetArray[1] = new CharmingBracelet();
        return ModularCurio.builder().rarity(Rarity.RARE).build(iFacetArray);
    }));
    public static final ItemEntry<ModularCurio> SPIRIT_BRACELET = CAItems.bracelet("spirit_bracelet", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(IRarityUtils.GREEN).build(new SpiritBracelet(), CAItems.spiritSet())));
    public static final ItemEntry<ModularCurio> UNOWNED_PENDANT = CAItems.pendant("unowned_pendant", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(Rarity.RARE).build(new IFacet[0])));
    public static final ItemEntry<ModularCurio> CHAOTIC_PENDANT = CAItems.pendant("chaotic_pendant", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(Rarity.EPIC).requireCS().loot(1).build(TextFacet.line(() -> CALang.Pendant.CHAOTIC.get(TextFacet.num((Integer)CAModConfig.COMMON.pendant.chaoticPendantEnchantLevel.get()))))));
    public static final ItemEntry<ModularCurio> SHADOW_PENDANT = CAItems.pendant("shadow_pendant", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(IRarityUtils.DARK_PURPLE).requireCS().build(new ShadowPendant())));
    public static final ItemEntry<ModularCurio> FOREST_CLOAK;
    public static final ItemEntry<ModularCurio> STAR_NECKLACE;
    public static final ItemEntry<ModularCurio> CROSS_NECKLACE;
    public static final ItemEntry<ModularCurio> GALLOP_NECKLACE;
    public static final ItemEntry<ModularCurio> FANG_NECKLACE;
    public static final ItemEntry<ModularCurio> PRECIOUS_NECKLACE;
    public static final ItemEntry<ModularCurio> HOLY_NECKLACE;
    public static final ItemEntry<ModularCurio> HEIRLOOM_NECKLACE;
    public static final ItemEntry<ModularCurio> EMERALD_NECKLACE;
    public static final ItemEntry<ModularCurio> ENDER_PROTECTOR;
    public static final ItemEntry<ModularCurio> RED_HEART_NECKLACE;
    public static final ItemEntry<ModularCurio> LOCK_OF_ABYSS;
    public static final ItemEntry<ModularCurio> SPIRIT_NECKLACE;
    public static final ItemEntry<ModularCurio> SEA_GOD_CROWN;
    public static final ItemEntry<ModularCurio> PRAYER_CROWN;
    public static final ItemEntry<ModularCurio> ABYSS_CORE;
    public static final ItemEntry<ModularCurio> GUARDIAN_EYE;
    public static final ItemEntry<ModularCurio> EVIL_EYE;
    public static final ItemEntry<ModularCurio> SPIRIT_CROWN;
    public static final ItemEntry<ModularCurio> SAKURA_HAIRPIN;
    public static final ItemEntry<ModularCurio> YELLOW_DUCK;
    public static final ItemEntry<ModularCurio> ANGEL_DESIRE;
    public static final ItemEntry<ModularCurio> MAGIC_ARROW_BAG;
    public static final ItemEntry<ModularCurio> FLAME_ARROW_BAG;
    public static final ItemEntry<ModularCurio> SPIRIT_ARROW_BAG;
    public static final ItemEntry<ModularCurio> IRON_SCABBARD;
    public static final ItemEntry<ModularCurio> LEECH_SCABBARD;
    public static final ItemEntry<ModularCurio> TITAN_SCABBARD;
    public static final ItemEntry<ModularCurio> TWISTED_SCABBARD;
    public static final ItemEntry<ModularCurio> CATASTROPHE_SCROLL;
    public static final ItemEntry<ModularCurio> CHAOTIC_ETCHING;
    public static final ItemEntry<ModularCurio> ORIGIN_ETCHING;
    public static final ItemEntry<ModularCurio> LIFE_ETCHING;
    public static final ItemEntry<ModularCurio> TRUTH_ETCHING;
    public static final ItemEntry<ModularCurio> DESIRE_ETCHING;
    public static final ItemEntry<ModularCurio> NIHILITY_ETCHING;
    public static final ItemEntry<ModularCurio> END_ETCHING;
    public static final ItemEntry<EarthAxe> EARTH_AXE;
    public static final ItemEntry<EarthPickaxe> EARTH_PICKAXE;
    public static final ItemEntry<EarthShovel> EARTH_SHOVEL;
    public static final ItemEntry<EarthHoe> EARTH_HOE;
    public static final ItemEntry<RepentMirror> REPENT_MIRROR;
    public static final ItemEntry<BacktrackMirror> BACKTRACK_MIRROR;
    public static final ItemEntry<PurifiedPowder> PURIFIED_POWDER;
    public static final ItemEntry<UnluckyPotato> UNLUCKY_POTATO;
    private static final SetTokenFacet<SpiritSet> SPIRIT_SET;
    private static final SetTokenFacet<EmeraldSet> EMERALD_SET;
    private static final SetTokenFacet<SeaGodSet> SEA_GOD_SET;

    public static SetTokenFacet<SpiritSet> spiritSet() {
        return SPIRIT_SET;
    }

    public static SetTokenFacet<EmeraldSet> emeraldSet() {
        return EMERALD_SET;
    }

    public static SetTokenFacet<SeaGodSet> seaGodSet() {
        return SEA_GOD_SET;
    }

    public static ItemEntry<ModularCurio> ring(String id, NonNullSupplier<ModularCurio> factory) {
        return CAItems.curio("curios/ring/", id, factory).tag(new TagKey[]{CAItems.curio("ring")}).register();
    }

    public static ItemEntry<ModularCurio> charm(String id, NonNullSupplier<ModularCurio> factory) {
        return CAItems.curio("curios/charm/", id, factory).tag(new TagKey[]{CAItems.curio("charm")}).register();
    }

    public static ItemEntry<ModularCurio> scroll(String id, NonNullSupplier<ModularCurio> factory) {
        return CAItems.curio("curios/scroll/", id, factory).tag(new TagKey[]{CAItems.curio("scroll")}).register();
    }

    public static ItemEntry<ModularCurio> bracelet(String id, NonNullSupplier<ModularCurio> factory) {
        return CAItems.curio("curios/bracelet/", id, factory).tag(new TagKey[]{CAItems.curio("bracelet")}).register();
    }

    public static ItemEntry<ModularCurio> pendant(String id, NonNullSupplier<ModularCurio> factory) {
        return CAItems.curio("curios/pendant/", id, factory).tag(new TagKey[]{CAItems.curio("pendant")}).register();
    }

    public static ItemEntry<ModularCurio> necklace(String id, NonNullSupplier<ModularCurio> factory) {
        return CAItems.curio("curios/necklace/", id, factory).tag(new TagKey[]{CAItems.curio("necklace")}).register();
    }

    public static ItemEntry<ModularCurio> head(String id, NonNullSupplier<ModularCurio> factory) {
        return CAItems.curio("curios/head/", id, factory).tag(new TagKey[]{CAItems.curio("head")}).register();
    }

    public static ItemEntry<ModularCurio> heart(String id, NonNullSupplier<ModularCurio> factory) {
        return CAItems.curio("curios/heart/", id, factory).tag(new TagKey[]{CAItems.curio("heart")}).register();
    }

    public static ItemEntry<ModularCurio> body(String id, NonNullSupplier<ModularCurio> factory) {
        return CAItems.curio("curios/body/", id, factory).tag(new TagKey[]{CAItems.curio("body")}).register();
    }

    public static ItemEntry<ModularCurio> etching(String id, NonNullSupplier<ModularCurio> factory) {
        return CAItems.curio("curios/etching/", id, factory).tag(new TagKey[]{CAItems.curio("etching")}).register();
    }

    public static ItemEntry<ModularCurio> back(String id, NonNullSupplier<ModularCurio> factory) {
        return CAItems.curio("curios/back/", id, factory).tag(new TagKey[]{CAItems.curio("back")}).register();
    }

    public static ItemBuilder<ModularCurio, ?> curio(String path, String id, NonNullSupplier<ModularCurio> factory) {
        ALL_CURIOS.add(id);
        return CAItems.item(path, id, factory);
    }

    public static <T extends Item> ItemBuilder<T, ?> item(String path, String id, NonNullSupplier<T> factory) {
        return CelestialArtifacts.REGISTRATE.item(id, p -> (Item)factory.get()).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("item/" + path + ctx.getName())}));
    }

    public static <T extends Item> ItemBuilder<T, ?> tool(String path, String id, NonNullSupplier<T> factory) {
        return CelestialArtifacts.REGISTRATE.item(id, p -> (Item)factory.get()).model((ctx, pvd) -> pvd.handheld((NonNullSupplier)ctx, pvd.modLoc("item/" + path + ctx.getName())));
    }

    private static TagKey<Item> curio(String id) {
        return ItemTags.create((ResourceLocation)new ResourceLocation("curios", id));
    }

    public static <T extends Item> ItemEntry<T> material(String id, NonNullFunction<Item.Properties, T> factory) {
        return CelestialArtifacts.REGISTRATE.item(id, factory).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("item/materials/" + ctx.getName())})).register();
    }

    public static void register() {
    }

    static {
        STAR_NECKLACE = CAItems.necklace("star_necklace", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[2];
            iFacetArray[0] = SimpleListener.hurtBonus(() -> CALang.Condition.ATTACK_BEHIND.get(new MutableComponent[0]), (p, t, c) -> EntityUtils.isLookingBehindTarget((LivingEntity)t, (Vec3)p.m_146892_()), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.necklace.starNecklaceDamageBonus).get());
            iFacetArray[1] = ConditionalEffectFacet.of(false, e -> e.m_9236_().m_46462_(), () -> CALang.Condition.NIGHT.get(new MutableComponent[0]), EffectFacet.of(() -> MobEffects.f_19606_, 2, 0));
            return ModularCurio.builder().rarity(Rarity.RARE).build(iFacetArray);
        }));
        CROSS_NECKLACE = CAItems.necklace("cross_necklace", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[1];
            iFacetArray[0] = InvulToken.of(() -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.necklace.crossNecklaceInvulTick).get());
            return ModularCurio.builder().rarity(Rarity.UNCOMMON).build(iFacetArray);
        }));
        GALLOP_NECKLACE = CAItems.necklace("gallop_necklace", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[2];
            iFacetArray[0] = AttrFacet.multBase(() -> Attributes.f_22279_, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.necklace.gallopNecklaceSpeedBonus).get());
            iFacetArray[1] = new GallopNecklace();
            return ModularCurio.builder().rarity(Rarity.RARE).build(iFacetArray);
        }));
        FANG_NECKLACE = CAItems.necklace("fang_necklace", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[3];
            iFacetArray[0] = AttrFacet.multBase(() -> Attributes.f_22283_, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.necklace.fangNecklaceAttack).get());
            iFacetArray[1] = SimpleListener.hurtBonus(() -> CALang.Condition.TARGET_HAS_ARMOR.get(new MutableComponent[0]), (p, t, c) -> EntityUtils.hasArmor((LivingEntity)t), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.necklace.fangNecklaceDamageBonus).get());
            iFacetArray[2] = HurtTargetEffectFacet.of(() -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.necklace.fangNecklacePoisonChance).get(), () -> MobEffects.f_19614_, () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.necklace.fangNecklacePoisonDuration).get(), () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.necklace.fangNecklacePoisonLevel).get());
            return ModularCurio.builder().rarity(IRarityUtils.DARK_GREEN).build(iFacetArray);
        }));
        PRECIOUS_NECKLACE = CAItems.necklace("precious_necklace", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[2];
            iFacetArray[0] = AttrFacet.add(() -> ((RegistryEntry)L2DamageTracker.CRIT_DMG).get(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.necklace.preciousNecklaceCritDmg).get());
            iFacetArray[1] = SlotFacet.of("charm", 1);
            return ModularCurio.builder().rarity(Rarity.RARE).fortune(1).build(iFacetArray);
        }));
        HOLY_NECKLACE = CAItems.necklace("holy_necklace", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[3];
            iFacetArray[0] = AttrFacet.add(() -> Attributes.f_22276_, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.necklace.holyNecklaceMaxHealth).get());
            iFacetArray[1] = InvulToken.of(() -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.necklace.holyNecklaceInvulTick).get());
            iFacetArray[2] = new HolyNecklace();
            return ModularCurio.builder().rarity(Rarity.UNCOMMON).build(iFacetArray);
        }));
        HEIRLOOM_NECKLACE = CAItems.necklace("heirloom_necklace", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[3];
            iFacetArray[0] = AttrFacet.add(() -> Attributes.f_22284_, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.necklace.hierloomNecklaceArmor).get());
            iFacetArray[1] = AttrFacet.multBase(() -> Attributes.f_22279_, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.necklace.hierloomNecklaceSpeed).get());
            iFacetArray[2] = XpBonusFeature.simple(() -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.necklace.hierloomNecklaceExp).get());
            return ModularCurio.builder().rarity(Rarity.UNCOMMON).fortune(1).build(iFacetArray);
        }));
        EMERALD_NECKLACE = CAItems.necklace("emerald_necklace", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(IRarityUtils.GREEN).fortune(1).build(new EmeraldNecklace(), CAItems.emeraldSet())));
        ENDER_PROTECTOR = CAItems.necklace("ender_protector", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[2];
            iFacetArray[0] = AttrFacet.add(() -> Attributes.f_22285_, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.necklace.enderProtectorToughness).get());
            iFacetArray[1] = new EnderProtector();
            return ModularCurio.builder().rarity(Rarity.EPIC).requireCS().enderMask().build(iFacetArray);
        }));
        RED_HEART_NECKLACE = CAItems.necklace("red_heart_necklace", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[1];
            iFacetArray[0] = AttrFacet.multBase(() -> Attributes.f_22276_, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.necklace.redHeartNecklaceMaxHealth).get());
            return ModularCurio.of(iFacetArray);
        }));
        LOCK_OF_ABYSS = CAItems.necklace("lock_of_abyss", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().requireCS().rarity(IRarityUtils.DARK_AQUA).build(new LockOfAbyss())));
        SPIRIT_NECKLACE = CAItems.necklace("spirit_necklace", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[3];
            iFacetArray[0] = AttrFacet.add(() -> ((RegistryEntry)L2DamageTracker.BOW_STRENGTH).get(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.necklace.spiritNecklaceProjectile).get());
            iFacetArray[1] = HurtPlayerEffectFacet.of(EffectFacet.of(() -> MobEffects.f_19596_, 5, 0));
            iFacetArray[2] = CAItems.spiritSet();
            return ModularCurio.builder().rarity(IRarityUtils.DARK_GREEN).build(iFacetArray);
        }));
        FOREST_CLOAK = CAItems.body("forest_cloak", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(IRarityUtils.GREEN).build(new ForestCloak())));
        SEA_GOD_CROWN = CAItems.head("sea_god_crown", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[3];
            iFacetArray[0] = ConditionalEffectFacet.of(false, Entity::m_20071_, () -> CALang.Condition.PLAYER_WET.get(new MutableComponent[0]), EffectFacet.of(() -> MobEffects.f_19608_, 2, 3), EffectFacet.of(() -> MobEffects.f_19611_, 2, 0));
            iFacetArray[1] = new SeaGodCrown();
            iFacetArray[2] = CAItems.seaGodSet();
            return ModularCurio.builder().rarity(Rarity.RARE).build(iFacetArray);
        }));
        PRAYER_CROWN = CAItems.head("prayer_crown", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[3];
            iFacetArray[0] = InvulToken.of(() -> 10);
            iFacetArray[1] = SimpleListener.protect(() -> CALang.Condition.SNEAK.get(new MutableComponent[0]), (player, attacker, cache) -> player.m_6047_(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.head.prayerCrownProtection).get());
            iFacetArray[2] = new PrayerCrown();
            return ModularCurio.builder().rarity(Rarity.UNCOMMON).build(iFacetArray);
        }));
        ABYSS_CORE = CAItems.head("abyss_core", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().requireCS().rarity(IRarityUtils.DARK_AQUA).build(new AbyssCore())));
        GUARDIAN_EYE = CAItems.head("guardian_eye", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[3];
            iFacetArray[0] = AttrFacet.multBase((Supplier<Attribute>)ForgeMod.SWIM_SPEED, () -> 0.15);
            iFacetArray[1] = SimpleListener.protect(() -> CALang.Condition.PLAYER_WET.get(new MutableComponent[0]), (player, attacker, cache) -> player.m_20071_(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.head.guardianEyeProtection).get());
            iFacetArray[2] = new GuardianEye();
            return ModularCurio.builder().rarity(Rarity.RARE).build(iFacetArray);
        }));
        EVIL_EYE = CAItems.head("evil_eye", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(Rarity.EPIC).build(new EvilEye())));
        SPIRIT_CROWN = CAItems.head("spirit_crown", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(IRarityUtils.DARK_GREEN).build(new SpiritCrown(), CAItems.spiritSet())));
        SAKURA_HAIRPIN = CAItems.head("sakura_hairpin", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[3];
            iFacetArray[0] = AttrFacet.add(() -> Attributes.f_22276_, () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.head.sakuraHairpinMaxHealthAdd).get());
            iFacetArray[1] = AttrFacet.multBase(() -> Attributes.f_22284_, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.head.sakuraHairpinArmorBonus).get());
            iFacetArray[2] = new TokenFacet<SakuraHairpin>("sakura_hairpin", SakuraHairpin::new);
            return ModularCurio.builder().rarity(IRarityUtils.PINK).build(iFacetArray);
        }));
        YELLOW_DUCK = CAItems.head("yellow_duck", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().rarity(IRarityUtils.YELLOW).build(new YellowDuck())));
        ANGEL_DESIRE = CAItems.head("angel_desire", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[2];
            iFacetArray[0] = SimpleListener.hurtBonus(() -> CALang.Head.ANGEL_DESIRE_1.get(TextFacet.perc((Double)CAModConfig.COMMON.head.angelDesireDamageBonus.get())), (p, f, c) -> p.m_21255_(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.head.angelDesireDamageBonus).get());
            iFacetArray[1] = new AngelDesire();
            return ModularCurio.builder().rarity(IRarityUtils.YELLOW).build(iFacetArray);
        }));
        MAGIC_ARROW_BAG = CAItems.back("magic_arrow_bag", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[2];
            iFacetArray[0] = AttrFacet.add(() -> ((RegistryEntry)L2DamageTracker.BOW_STRENGTH).get(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.back.magicArrowBagBowStrength).get());
            iFacetArray[1] = AttrFacet.add(() -> ((RegistryEntry)CCAttributes.ARROW_KNOCK).get(), () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.back.magicArrowBagArrowKnock).get());
            return ModularCurio.of(iFacetArray);
        }));
        FLAME_ARROW_BAG = CAItems.back("flame_arrow_bag", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[3];
            iFacetArray[0] = AttrFacet.add(() -> ((RegistryEntry)L2DamageTracker.BOW_STRENGTH).get(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.back.flameArrowBagBowStrength).get());
            iFacetArray[1] = AttrFacet.add(() -> ((RegistryEntry)CCAttributes.ARROW_KNOCK).get(), () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.back.flameArrowBagArrowKnock).get());
            iFacetArray[2] = TextFacet.line(() -> CALang.Back.FLAME.get(TextFacet.num((Integer)CAModConfig.COMMON.back.flameArrowBagTime.get())));
            return ModularCurio.of(iFacetArray);
        }));
        SPIRIT_ARROW_BAG = CAItems.back("spirit_arrow_bag", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[4];
            iFacetArray[0] = AttrFacet.add(() -> ((RegistryEntry)L2DamageTracker.BOW_STRENGTH).get(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.back.spiritArrowBagBowStrength).get());
            iFacetArray[1] = AttrFacet.add(() -> ((RegistryEntry)CCAttributes.ARROW_SPEED).get(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.back.spiritArrowBagArrowSpeed).get());
            iFacetArray[2] = AttrFacet.add(() -> ((RegistryEntry)CCAttributes.ARROW_KNOCK).get(), () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.back.spiritArrowBagArrowKnock).get());
            iFacetArray[3] = CAItems.spiritSet();
            return ModularCurio.builder().rarity(IRarityUtils.GREEN).build(iFacetArray);
        }));
        IRON_SCABBARD = CAItems.back("iron_scabbard", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[1];
            iFacetArray[0] = EffectFacet.of(() -> ((RegistryEntry)CCEffects.BLADE_MODIFIER).get(), () -> 2, () -> 0, () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.back.ironScabbardBladeInterval).get());
            return ModularCurio.of(iFacetArray);
        }));
        LEECH_SCABBARD = CAItems.back("leech_scabbard", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[2];
            iFacetArray[0] = EffectFacet.of(() -> ((RegistryEntry)CCEffects.BLADE_MODIFIER).get(), () -> 3, () -> 0, () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.back.leechScabbardBladeInterval).get());
            iFacetArray[1] = new LeechScabbard();
            return ModularCurio.builder().rarity(Rarity.RARE).build(iFacetArray);
        }));
        TITAN_SCABBARD = CAItems.back("titan_scabbard", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[2];
            iFacetArray[0] = EffectFacet.of(() -> ((RegistryEntry)CCEffects.REPLY_POWER).get(), () -> 3, () -> 0, () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.back.titanScabbardBladeInterval).get());
            iFacetArray[1] = SimpleListener.hurtBonus(() -> CALang.Condition.TITAN.get(TextFacet.eff((MobEffect)CCEffects.REPLY_POWER.get())), (p, t, c) -> CAAttackToken.isMelee(c) && p.m_21023_((MobEffect)CCEffects.BLADE_MODIFIER.get()) && t.m_21233_() > p.m_21233_(), () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.back.titanScabbardDamageFactor).get());
            return ModularCurio.builder().rarity(Rarity.RARE).build(iFacetArray);
        }));
        TWISTED_SCABBARD = CAItems.back("twisted_scabbard", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[5];
            iFacetArray[0] = EffectFacet.of(() -> ((RegistryEntry)CCEffects.BLADE_MODIFIER).get(), () -> 3, () -> 0, () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.back.twistedScabbardBladeInterval).get());
            iFacetArray[1] = AttrFacet.multBase(() -> Attributes.f_22282_, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.back.twistedScabbardAtkKonck).get());
            iFacetArray[2] = AttrFacet.multBase(() -> Attributes.f_22283_, () -> ((ForgeConfigSpec.DoubleValue)CAModConfig.COMMON.back.twistedScabbardAtkSpeed).get());
            iFacetArray[3] = AttrFacet.multTotal(() -> ((RegistryEntry)CCAttributes.REPLY_POWER).get(), () -> -((Double)CAModConfig.COMMON.back.twistedScabbardHealRate.get()).doubleValue());
            iFacetArray[4] = TwistedScabbard.TOKEN;
            return ModularCurio.builder().requireCS().rarity(IRarityUtils.DARK_PURPLE).loot(1).build(iFacetArray);
        }));
        CATASTROPHE_SCROLL = CAItems.curio("curios/", "catastrophe_scroll", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> {
            IFacet[] iFacetArray = new IFacet[3];
            iFacetArray[0] = SlotFacet.of("etching", () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.curse.etchingSlotSize).get());
            iFacetArray[1] = SlotFacet.of("charm", () -> ((ForgeConfigSpec.IntValue)CAModConfig.COMMON.curse.charmSlotSize).get());
            iFacetArray[2] = CatastropheScroll.TOKEN;
            return ModularCurio.builder().curse().immune().rarity(IRarityUtils.DARK_PURPLE).hideAttr().build(iFacetArray);
        })).tag(new TagKey[]{CAItems.curio("catastrophe")}).register();
        CHAOTIC_ETCHING = CAItems.etching("chaotic_etching", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().immune().hideAttr().build(new IFacet[0])));
        ORIGIN_ETCHING = CAItems.etching("origin_etching", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().immune().hideAttr().build(BreakSpeedFeature.simple(() -> 1.0 + CatastropheScroll.getOriginBonus()))));
        LIFE_ETCHING = CAItems.etching("life_etching", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().immune().hideAttr().build(new IFacet[0])));
        TRUTH_ETCHING = CAItems.etching("truth_etching", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().immune().hideAttr().build(new IFacet[0])));
        DESIRE_ETCHING = CAItems.etching("desire_etching", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().immune().fortune(1).loot(1).hideAttr().build(new IFacet[0])));
        NIHILITY_ETCHING = CAItems.etching("nihility_etching", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().immune().hideAttr().build(new IFacet[0])));
        END_ETCHING = CAItems.etching("end_etching", (NonNullSupplier<ModularCurio>)((NonNullSupplier)() -> ModularCurio.builder().immune().hideAttr().build(new IFacet[0])));
        EARTH_AXE = CAItems.tool("tool/earth/", "earth_axe", EarthAxe::new).tag(new TagKey[]{ItemTags.f_271207_}).register();
        EARTH_PICKAXE = CAItems.tool("tool/earth/", "earth_pickaxe", EarthPickaxe::new).tag(new TagKey[]{ItemTags.f_271360_}).register();
        EARTH_SHOVEL = CAItems.tool("tool/earth/", "earth_shovel", EarthShovel::new).tag(new TagKey[]{ItemTags.f_271138_}).register();
        EARTH_HOE = CAItems.tool("tool/earth/", "earth_hoe", EarthHoe::new).tag(new TagKey[]{ItemTags.f_271298_}).register();
        REPENT_MIRROR = CAItems.item("items/", "repent_mirror", RepentMirror::new).register();
        BACKTRACK_MIRROR = CAItems.item("items/", "backtrack_mirror", BacktrackMirror::new).register();
        PURIFIED_POWDER = CAItems.item("items/", "purified_powder", PurifiedPowder::new).register();
        UNLUCKY_POTATO = CAItems.item("food/", "unlucky_potato", UnluckyPotato::new).register();
        SPIRIT_SET = new SetTokenFacet<SpiritSet>("spirit", List.of(SPIRIT_BRACELET, SPIRIT_CROWN, SPIRIT_NECKLACE, SPIRIT_ARROW_BAG), SpiritSet::new);
        EMERALD_SET = new SetTokenFacet<EmeraldSet>("emerald", List.of(EMERALD_RING, EMERALD_NECKLACE, EMERALD_BRACELET), EmeraldSet::new);
        SEA_GOD_SET = new SetTokenFacet<SeaGodSet>("sea_god", List.of(SEA_GOD_CROWN, SEA_GOD_SCROLL), SeaGodSet::new);
    }
}

