/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.content.loot;

import com.xiaoyue.celestial_core.register.CCLootModifier;
import com.xiaoyue.celestial_core.utils.EnchUtils;
import dev.xkmc.l2serial.serialization.SerialClass;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

@SerialClass
public class EquipEnchCondition
implements LootItemCondition {
    @SerialClass.SerialField
    public Item armor;
    @SerialClass.SerialField
    public boolean onFire;

    @Deprecated
    public EquipEnchCondition() {
    }

    public EquipEnchCondition(Item armor, boolean onFire) {
        this.armor = armor;
        this.onFire = onFire;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)CCLootModifier.EQUIP_ENCH.get();
    }

    public boolean test(LootContext ctx) {
        if (!ctx.m_78936_(LootContextParams.f_81455_)) {
            return false;
        }
        Entity entity = (Entity)ctx.m_165124_(LootContextParams.f_81455_);
        if (entity instanceof ArmorStand) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity liv = (LivingEntity)entity;
            for (ItemStack stack : liv.m_6168_()) {
                if (!stack.m_150930_(this.armor) || EnchUtils.getTotalEnch(stack) <= 0) continue;
                return !this.onFire || entity.m_6060_();
            }
        }
        return false;
    }
}

