/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.data;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class CCModConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static String COMMON_PATH;

    public static void init() {
        CCModConfig.register(ModConfig.Type.CLIENT, CLIENT_SPEC);
        COMMON_PATH = CCModConfig.register(ModConfig.Type.COMMON, COMMON_SPEC);
    }

    private static String register(ModConfig.Type type, IConfigSpec<?> spec) {
        ModContainer mod = ModLoadingContext.get().getActiveContainer();
        String path = "celestial_configs/" + mod.getModId() + "-" + type.extension() + ".toml";
        ModLoadingContext.get().registerConfig(type, spec, path);
        return path;
    }

    static {
        Pair client = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)client.getRight();
        CLIENT = (Client)client.getLeft();
        Pair common = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
        COMMON = (Common)common.getLeft();
    }

    public static class Client {
        Client(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class Common {
        public final ForgeConfigSpec.DoubleValue fireEssenceChance;
        public final ForgeConfigSpec.DoubleValue oceanEssenceChance;
        public final ForgeConfigSpec.DoubleValue deathEssenceChance;
        public final ForgeConfigSpec.IntValue deathEssenceMinHealth;
        public final ForgeConfigSpec.DoubleValue wardenScleriteChance;
        public final ForgeConfigSpec.DoubleValue shulkerScrapChance;
        public final ForgeConfigSpec.DoubleValue lightFragmentChance;
        public final ForgeConfigSpec.DoubleValue midnightFragmentChance;
        public final ForgeConfigSpec.DoubleValue sakuraFragmentChance;
        public final ForgeConfigSpec.DoubleValue virtualGoldNuggetChance;
        public final ForgeConfigSpec.IntValue pureNetherStarEffectCount;
        public final ForgeConfigSpec.DoubleValue guardianSpikeChance;
        public final ForgeConfigSpec.IntValue sakuraToolRecoveryTime;
        public final ForgeConfigSpec.DoubleValue virtualGoldToolPerAdd;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("materials");
            this.fireEssenceChance = builder.defineInRange("fireEssenceChance", 0.08, 0.0, 1.0);
            this.oceanEssenceChance = builder.defineInRange("oceanEssenceChance", 0.08, 0.0, 1.0);
            this.deathEssenceChance = builder.defineInRange("deathEssenceChance", 0.6, 0.0, 1.0);
            this.deathEssenceMinHealth = builder.defineInRange("deathEssenceMinHealth", 100, 0, 1000000);
            this.wardenScleriteChance = builder.defineInRange("wardenScleriteChance", 0.5, 0.0, 1.0);
            this.shulkerScrapChance = builder.defineInRange("shulkerScrapChance", 0.5, 0.0, 1.0);
            this.lightFragmentChance = builder.defineInRange("lightFragmentChance", 0.05, 0.0, 1.0);
            this.midnightFragmentChance = builder.defineInRange("midnightFragmentChance", 0.05, 0.0, 1.0);
            this.sakuraFragmentChance = builder.defineInRange("sakuraFragmentChance", 0.1, 0.0, 1.0);
            this.virtualGoldNuggetChance = builder.defineInRange("virtualGoldNuggetChance", 0.5, 0.0, 1.0);
            this.pureNetherStarEffectCount = builder.defineInRange("pureNetherStarEffectCount", 12, 0, 100);
            this.guardianSpikeChance = builder.defineInRange("guardianSpikeChance", 0.2, 0.0, 1.0);
            this.sakuraToolRecoveryTime = builder.defineInRange("sakuraToolRecoveryTime", 5, 0, 100);
            this.virtualGoldToolPerAdd = builder.defineInRange("virtualGoldToolPerAdd", 0.05, 0.01, 1.0);
            builder.pop();
        }
    }
}

