/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.utils;

import dev.xkmc.l2library.util.math.MathHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public class ItemUtils {
    public static void repairStack(ItemStack stack) {
        ItemUtils.repairStack(stack, 1);
    }

    public static void repairStack(ItemStack stack, int value) {
        stack.m_41721_(stack.m_41773_() - value);
    }

    public static AttributeModifier.Operation getOpFromId(int id) {
        return AttributeModifier.Operation.m_22236_((int)id);
    }

    public static AttributeModifier addMod(String name, double amount, AttributeModifier.Operation operation) {
        return new AttributeModifier(MathHelper.getUUIDFromString((String)name), name, amount, operation);
    }

    public static AttributeModifier addMod(String name, double amount, int operation) {
        return new AttributeModifier(MathHelper.getUUIDFromString((String)name), name, amount, ItemUtils.getOpFromId(operation));
    }

    public static Component addTranslatable(String info, @Nullable ChatFormatting color) {
        MutableComponent tip = Component.m_237115_((String)info);
        if (color != null) {
            return tip.m_130940_(color);
        }
        return tip;
    }

    public static Component addTranslatable(String info, @Nullable ChatFormatting color, Object ... objects) {
        MutableComponent tip = Component.m_237110_((String)info, (Object[])objects);
        if (color != null) {
            return tip.m_130940_(color);
        }
        return tip;
    }

    public static void addTranslatable(List<Component> list, String info, @Nullable ChatFormatting color) {
        list.add(ItemUtils.addTranslatable(info, color));
    }

    public static void addTranslatable(List<Component> list, String info, @Nullable ChatFormatting color, Object ... objects) {
        list.add(ItemUtils.addTranslatable(info, color, objects));
    }

    public static class ItemTag {
        public static boolean tagCheck(ItemStack stack) {
            return !stack.m_41619_() && stack.m_41783_() != null;
        }

        public static void removeTag(ItemStack stack, String tag) {
            if (ItemTag.tagCheck(stack)) {
                stack.m_41783_().m_128473_(tag);
            }
        }

        public static boolean getBoolean(ItemStack stack, String tag) {
            return ItemTag.tagCheck(stack) && stack.m_41783_().m_128471_(tag);
        }

        public static boolean isBoolean(ItemStack stack, String tag, boolean value) {
            return ItemTag.tagCheck(stack) && stack.m_41783_().m_128471_(tag) == value;
        }

        public static void setBoolean(ItemStack stack, String tag, boolean value) {
            stack.m_41784_().m_128379_(tag, value);
        }

        public static int getInt(ItemStack stack, String tag) {
            return ItemTag.tagCheck(stack) ? stack.m_41783_().m_128451_(tag) : 0;
        }

        public static int getInt(ItemStack stack, String tag, int def) {
            return ItemTag.tagCheck(stack) ? stack.m_41783_().m_128451_(tag) : def;
        }

        public static void setInt(ItemStack stack, String tag, int value) {
            stack.m_41784_().m_128405_(tag, value);
        }

        public static float getFloat(ItemStack stack, String tag) {
            return ItemTag.tagCheck(stack) ? stack.m_41783_().m_128457_(tag) : 0.0f;
        }

        public static float getFloat(ItemStack stack, String tag, float def) {
            return ItemTag.tagCheck(stack) ? stack.m_41783_().m_128457_(tag) : def;
        }

        public static void setFloat(ItemStack stack, String tag, float value) {
            stack.m_41784_().m_128350_(tag, value);
        }

        public static double getDouble(ItemStack stack, String tag) {
            return ItemTag.tagCheck(stack) ? stack.m_41783_().m_128459_(tag) : 0.0;
        }

        public static double getDouble(ItemStack stack, String tag, double def) {
            return ItemTag.tagCheck(stack) ? stack.m_41783_().m_128459_(tag) : def;
        }

        public static void setDouble(ItemStack stack, String tag, double value) {
            stack.m_41784_().m_128347_(tag, value);
        }

        public static String getString(ItemStack stack, String tag) {
            return stack.m_41784_().m_128461_(tag);
        }

        public static boolean hasStringTag(ItemStack stack, String tag, String value) {
            return stack.m_41784_().m_128461_(tag).equals(value);
        }

        public static void setString(ItemStack stack, String tag, String value) {
            stack.m_41784_().m_128359_(tag, value);
        }

        public static CompoundTag getCompound(ItemStack stack, String tag) {
            return stack.m_41784_().m_128469_(tag);
        }

        public static void setCompound(ItemStack stack, String tag, CompoundTag value) {
            stack.m_41784_().m_128365_(tag, (Tag)value);
        }

        public static ListTag getListTag(ItemStack stack, String tag, int type) {
            return stack.m_41784_().m_128437_(tag, type);
        }
    }
}

