/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.batmanmod.network;

import java.util.function.Supplier;
import net.mcreator.batmanmod.BatmanModMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BatmanModModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        BatmanModMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        BatmanModMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.BatKineticBuildup = message.data.BatKineticBuildup;
                    variables.GlideGuide = message.data.GlideGuide;
                    variables.DetectiveMode = message.data.DetectiveMode;
                    variables.HostilesDetected = message.data.HostilesDetected;
                    variables.HostilesAround = message.data.HostilesAround;
                    variables.overloadX = message.data.overloadX;
                    variables.overloadY = message.data.overloadY;
                    variables.overloadZ = message.data.overloadZ;
                    variables.Overloaded = message.data.Overloaded;
                    variables.EntityInSight = message.data.EntityInSight;
                    variables.SightEntityHealth = message.data.SightEntityHealth;
                    variables.SightEntityName = message.data.SightEntityName;
                    variables.SightEntityDistance = message.data.SightEntityDistance;
                    variables.SightEntityState = message.data.SightEntityState;
                    variables.PodX = message.data.PodX;
                    variables.PodY = message.data.PodY;
                    variables.PodZ = message.data.PodZ;
                    variables.PodRange = message.data.PodRange;
                    variables.ShockGloves_Activated = message.data.ShockGloves_Activated;
                    variables.GloveHitCount = message.data.GloveHitCount;
                    variables.ArmorDamage = message.data.ArmorDamage;
                    variables.Flashlight_On = message.data.Flashlight_On;
                    variables.PillAvailable = message.data.PillAvailable;
                    variables.ProtoBelt = message.data.ProtoBelt;
                    variables.ClassicBelt = message.data.ClassicBelt;
                    variables.ArmoredJacket = message.data.ArmoredJacket;
                    variables.VehichleDistance = message.data.VehichleDistance;
                    variables.VehichleinRange = message.data.VehichleinRange;
                    variables.Venom = message.data.Venom;
                    variables.StaffToggled = message.data.StaffToggled;
                    variables.flashed = message.data.flashed;
                    variables.falldistance = message.data.falldistance;
                    variables.EscrimaBuildup = message.data.EscrimaBuildup;
                    variables.blockbutton = message.data.blockbutton;
                    variables.xComputer = message.data.xComputer;
                    variables.yComputer = message.data.yComputer;
                    variables.zComputer = message.data.zComputer;
                    variables.FightingStyle = message.data.FightingStyle;
                    variables.CompHead = message.data.CompHead;
                    variables.CompChest = message.data.CompChest;
                    variables.CompLegs = message.data.CompLegs;
                    variables.CompBoots = message.data.CompBoots;
                    variables.VenomSize = message.data.VenomSize;
                    variables.owner = message.data.owner;
                    variables.wheeltype = message.data.wheeltype;
                    variables.wingtype = message.data.wingtype;
                    variables.homingmissiletimer = message.data.homingmissiletimer;
                    variables.DiedInTraining = message.data.DiedInTraining;
                    variables.TutorialText = message.data.TutorialText;
                    variables.hint1 = message.data.hint1;
                    variables.TutorialPt = message.data.TutorialPt;
                    variables.lazaruseffect = message.data.lazaruseffect;
                    variables.DRIVINGLOOP = message.data.DRIVINGLOOP;
                    variables.DrivingSounds = message.data.DrivingSounds;
                    variables.FIghtingStyleOn = message.data.FIghtingStyleOn;
                    variables.PatreonExclusives = message.data.PatreonExclusives;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double BatKineticBuildup = 0.0;
        public boolean GlideGuide = false;
        public boolean DetectiveMode = false;
        public String HostilesDetected = "\"\"";
        public boolean HostilesAround = false;
        public double overloadX = 0.0;
        public double overloadY = 0.0;
        public double overloadZ = 0.0;
        public boolean Overloaded = false;
        public boolean EntityInSight = false;
        public String SightEntityHealth = "\"\"";
        public String SightEntityName = "\"\"";
        public String SightEntityDistance = "\"\"";
        public String SightEntityState = "\"\"";
        public double PodX = 0.0;
        public double PodY = 0.0;
        public double PodZ = 0.0;
        public double PodRange = 0.0;
        public boolean ShockGloves_Activated = false;
        public double GloveHitCount = 0.0;
        public double ArmorDamage = 0.0;
        public boolean Flashlight_On = false;
        public boolean PillAvailable = true;
        public boolean ProtoBelt = false;
        public boolean ClassicBelt = false;
        public boolean ArmoredJacket = false;
        public String VehichleDistance = "\"\"";
        public boolean VehichleinRange = false;
        public boolean Venom = false;
        public boolean StaffToggled = false;
        public double flashed = 0.0;
        public double falldistance = 0.0;
        public double EscrimaBuildup = 0.0;
        public boolean blockbutton = false;
        public double xComputer = 0.0;
        public double yComputer = 0.0;
        public double zComputer = 0.0;
        public double FightingStyle = 0.0;
        public ItemStack CompHead = ItemStack.f_41583_;
        public ItemStack CompChest = ItemStack.f_41583_;
        public ItemStack CompLegs = ItemStack.f_41583_;
        public ItemStack CompBoots = ItemStack.f_41583_;
        public double VenomSize = 0.0;
        public String owner = "";
        public double wheeltype = 0.0;
        public double wingtype = 0.0;
        public double homingmissiletimer = 0.0;
        public boolean DiedInTraining = false;
        public String TutorialText = " ";
        public String hint1 = " ";
        public double TutorialPt = 0.0;
        public boolean lazaruseffect = false;
        public double DRIVINGLOOP = 0.0;
        public boolean DrivingSounds = true;
        public boolean FIghtingStyleOn = true;
        public boolean PatreonExclusives = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                BatmanModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("BatKineticBuildup", this.BatKineticBuildup);
            nbt.m_128379_("GlideGuide", this.GlideGuide);
            nbt.m_128379_("DetectiveMode", this.DetectiveMode);
            nbt.m_128359_("HostilesDetected", this.HostilesDetected);
            nbt.m_128379_("HostilesAround", this.HostilesAround);
            nbt.m_128347_("overloadX", this.overloadX);
            nbt.m_128347_("overloadY", this.overloadY);
            nbt.m_128347_("overloadZ", this.overloadZ);
            nbt.m_128379_("Overloaded", this.Overloaded);
            nbt.m_128379_("EntityInSight", this.EntityInSight);
            nbt.m_128359_("SightEntityHealth", this.SightEntityHealth);
            nbt.m_128359_("SightEntityName", this.SightEntityName);
            nbt.m_128359_("SightEntityDistance", this.SightEntityDistance);
            nbt.m_128359_("SightEntityState", this.SightEntityState);
            nbt.m_128347_("PodX", this.PodX);
            nbt.m_128347_("PodY", this.PodY);
            nbt.m_128347_("PodZ", this.PodZ);
            nbt.m_128347_("PodRange", this.PodRange);
            nbt.m_128379_("ShockGloves_Activated", this.ShockGloves_Activated);
            nbt.m_128347_("GloveHitCount", this.GloveHitCount);
            nbt.m_128347_("ArmorDamage", this.ArmorDamage);
            nbt.m_128379_("Flashlight_On", this.Flashlight_On);
            nbt.m_128379_("PillAvailable", this.PillAvailable);
            nbt.m_128379_("ProtoBelt", this.ProtoBelt);
            nbt.m_128379_("ClassicBelt", this.ClassicBelt);
            nbt.m_128379_("ArmoredJacket", this.ArmoredJacket);
            nbt.m_128359_("VehichleDistance", this.VehichleDistance);
            nbt.m_128379_("VehichleinRange", this.VehichleinRange);
            nbt.m_128379_("Venom", this.Venom);
            nbt.m_128379_("StaffToggled", this.StaffToggled);
            nbt.m_128347_("flashed", this.flashed);
            nbt.m_128347_("falldistance", this.falldistance);
            nbt.m_128347_("EscrimaBuildup", this.EscrimaBuildup);
            nbt.m_128379_("blockbutton", this.blockbutton);
            nbt.m_128347_("xComputer", this.xComputer);
            nbt.m_128347_("yComputer", this.yComputer);
            nbt.m_128347_("zComputer", this.zComputer);
            nbt.m_128347_("FightingStyle", this.FightingStyle);
            nbt.m_128365_("CompHead", (Tag)this.CompHead.m_41739_(new CompoundTag()));
            nbt.m_128365_("CompChest", (Tag)this.CompChest.m_41739_(new CompoundTag()));
            nbt.m_128365_("CompLegs", (Tag)this.CompLegs.m_41739_(new CompoundTag()));
            nbt.m_128365_("CompBoots", (Tag)this.CompBoots.m_41739_(new CompoundTag()));
            nbt.m_128347_("VenomSize", this.VenomSize);
            nbt.m_128359_("owner", this.owner);
            nbt.m_128347_("wheeltype", this.wheeltype);
            nbt.m_128347_("wingtype", this.wingtype);
            nbt.m_128347_("homingmissiletimer", this.homingmissiletimer);
            nbt.m_128379_("DiedInTraining", this.DiedInTraining);
            nbt.m_128359_("TutorialText", this.TutorialText);
            nbt.m_128359_("hint1", this.hint1);
            nbt.m_128347_("TutorialPt", this.TutorialPt);
            nbt.m_128379_("lazaruseffect", this.lazaruseffect);
            nbt.m_128347_("DRIVINGLOOP", this.DRIVINGLOOP);
            nbt.m_128379_("DrivingSounds", this.DrivingSounds);
            nbt.m_128379_("FIghtingStyleOn", this.FIghtingStyleOn);
            nbt.m_128379_("PatreonExclusives", this.PatreonExclusives);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.BatKineticBuildup = nbt.m_128459_("BatKineticBuildup");
            this.GlideGuide = nbt.m_128471_("GlideGuide");
            this.DetectiveMode = nbt.m_128471_("DetectiveMode");
            this.HostilesDetected = nbt.m_128461_("HostilesDetected");
            this.HostilesAround = nbt.m_128471_("HostilesAround");
            this.overloadX = nbt.m_128459_("overloadX");
            this.overloadY = nbt.m_128459_("overloadY");
            this.overloadZ = nbt.m_128459_("overloadZ");
            this.Overloaded = nbt.m_128471_("Overloaded");
            this.EntityInSight = nbt.m_128471_("EntityInSight");
            this.SightEntityHealth = nbt.m_128461_("SightEntityHealth");
            this.SightEntityName = nbt.m_128461_("SightEntityName");
            this.SightEntityDistance = nbt.m_128461_("SightEntityDistance");
            this.SightEntityState = nbt.m_128461_("SightEntityState");
            this.PodX = nbt.m_128459_("PodX");
            this.PodY = nbt.m_128459_("PodY");
            this.PodZ = nbt.m_128459_("PodZ");
            this.PodRange = nbt.m_128459_("PodRange");
            this.ShockGloves_Activated = nbt.m_128471_("ShockGloves_Activated");
            this.GloveHitCount = nbt.m_128459_("GloveHitCount");
            this.ArmorDamage = nbt.m_128459_("ArmorDamage");
            this.Flashlight_On = nbt.m_128471_("Flashlight_On");
            this.PillAvailable = nbt.m_128471_("PillAvailable");
            this.ProtoBelt = nbt.m_128471_("ProtoBelt");
            this.ClassicBelt = nbt.m_128471_("ClassicBelt");
            this.ArmoredJacket = nbt.m_128471_("ArmoredJacket");
            this.VehichleDistance = nbt.m_128461_("VehichleDistance");
            this.VehichleinRange = nbt.m_128471_("VehichleinRange");
            this.Venom = nbt.m_128471_("Venom");
            this.StaffToggled = nbt.m_128471_("StaffToggled");
            this.flashed = nbt.m_128459_("flashed");
            this.falldistance = nbt.m_128459_("falldistance");
            this.EscrimaBuildup = nbt.m_128459_("EscrimaBuildup");
            this.blockbutton = nbt.m_128471_("blockbutton");
            this.xComputer = nbt.m_128459_("xComputer");
            this.yComputer = nbt.m_128459_("yComputer");
            this.zComputer = nbt.m_128459_("zComputer");
            this.FightingStyle = nbt.m_128459_("FightingStyle");
            this.CompHead = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("CompHead"));
            this.CompChest = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("CompChest"));
            this.CompLegs = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("CompLegs"));
            this.CompBoots = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("CompBoots"));
            this.VenomSize = nbt.m_128459_("VenomSize");
            this.owner = nbt.m_128461_("owner");
            this.wheeltype = nbt.m_128459_("wheeltype");
            this.wingtype = nbt.m_128459_("wingtype");
            this.homingmissiletimer = nbt.m_128459_("homingmissiletimer");
            this.DiedInTraining = nbt.m_128471_("DiedInTraining");
            this.TutorialText = nbt.m_128461_("TutorialText");
            this.hint1 = nbt.m_128461_("hint1");
            this.TutorialPt = nbt.m_128459_("TutorialPt");
            this.lazaruseffect = nbt.m_128471_("lazaruseffect");
            this.DRIVINGLOOP = nbt.m_128459_("DRIVINGLOOP");
            this.DrivingSounds = nbt.m_128471_("DrivingSounds");
            this.FIghtingStyleOn = nbt.m_128471_("FIghtingStyleOn");
            this.PatreonExclusives = nbt.m_128471_("PatreonExclusives");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("batman_mod", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "batman_mod_mapvars";
        public String KB = "\"\"";
        public BlockState DropProtoBatsuit = Blocks.f_50016_.m_49966_();
        public BlockState DropFreezeBlast = Blocks.f_50016_.m_49966_();
        public BlockState DropRebreather = Blocks.f_50016_.m_49966_();
        public BlockState DropBatsuit = Blocks.f_50016_.m_49966_();
        public BlockState DropKryptonite = Blocks.f_50016_.m_49966_();
        public BlockState DropShockGlove = Blocks.f_50016_.m_49966_();
        public boolean RandomCrimeON = true;
        public double Xninja = 0.0;
        public double yNinja = 0.0;
        public double zNinja = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.KB = nbt.m_128461_("KB");
            this.DropProtoBatsuit = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)nbt.m_128469_("DropProtoBatsuit"));
            this.DropFreezeBlast = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)nbt.m_128469_("DropFreezeBlast"));
            this.DropRebreather = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)nbt.m_128469_("DropRebreather"));
            this.DropBatsuit = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)nbt.m_128469_("DropBatsuit"));
            this.DropKryptonite = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)nbt.m_128469_("DropKryptonite"));
            this.DropShockGlove = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)nbt.m_128469_("DropShockGlove"));
            this.RandomCrimeON = nbt.m_128471_("RandomCrimeON");
            this.Xninja = nbt.m_128459_("Xninja");
            this.yNinja = nbt.m_128459_("yNinja");
            this.zNinja = nbt.m_128459_("zNinja");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128359_("KB", this.KB);
            nbt.m_128365_("DropProtoBatsuit", (Tag)NbtUtils.m_129202_((BlockState)this.DropProtoBatsuit));
            nbt.m_128365_("DropFreezeBlast", (Tag)NbtUtils.m_129202_((BlockState)this.DropFreezeBlast));
            nbt.m_128365_("DropRebreather", (Tag)NbtUtils.m_129202_((BlockState)this.DropRebreather));
            nbt.m_128365_("DropBatsuit", (Tag)NbtUtils.m_129202_((BlockState)this.DropBatsuit));
            nbt.m_128365_("DropKryptonite", (Tag)NbtUtils.m_129202_((BlockState)this.DropKryptonite));
            nbt.m_128365_("DropShockGlove", (Tag)NbtUtils.m_129202_((BlockState)this.DropShockGlove));
            nbt.m_128379_("RandomCrimeON", this.RandomCrimeON);
            nbt.m_128347_("Xninja", this.Xninja);
            nbt.m_128347_("yNinja", this.yNinja);
            nbt.m_128347_("zNinja", this.zNinja);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                BatmanModMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "batman_mod_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                BatmanModMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.BatKineticBuildup = original.BatKineticBuildup;
            clone.ArmorDamage = original.ArmorDamage;
            clone.ProtoBelt = original.ProtoBelt;
            clone.ClassicBelt = original.ClassicBelt;
            clone.ArmoredJacket = original.ArmoredJacket;
            clone.xComputer = original.xComputer;
            clone.yComputer = original.yComputer;
            clone.zComputer = original.zComputer;
            clone.FightingStyle = original.FightingStyle;
            clone.CompHead = original.CompHead;
            clone.CompChest = original.CompChest;
            clone.CompLegs = original.CompLegs;
            clone.CompBoots = original.CompBoots;
            clone.wheeltype = original.wheeltype;
            clone.wingtype = original.wingtype;
            clone.DiedInTraining = original.DiedInTraining;
            clone.lazaruseffect = original.lazaruseffect;
            clone.DrivingSounds = original.DrivingSounds;
            clone.FIghtingStyleOn = original.FIghtingStyleOn;
            clone.PatreonExclusives = original.PatreonExclusives;
            if (!event.isWasDeath()) {
                clone.GlideGuide = original.GlideGuide;
                clone.DetectiveMode = original.DetectiveMode;
                clone.HostilesDetected = original.HostilesDetected;
                clone.HostilesAround = original.HostilesAround;
                clone.overloadX = original.overloadX;
                clone.overloadY = original.overloadY;
                clone.overloadZ = original.overloadZ;
                clone.Overloaded = original.Overloaded;
                clone.EntityInSight = original.EntityInSight;
                clone.SightEntityHealth = original.SightEntityHealth;
                clone.SightEntityName = original.SightEntityName;
                clone.SightEntityDistance = original.SightEntityDistance;
                clone.SightEntityState = original.SightEntityState;
                clone.PodX = original.PodX;
                clone.PodY = original.PodY;
                clone.PodZ = original.PodZ;
                clone.PodRange = original.PodRange;
                clone.ShockGloves_Activated = original.ShockGloves_Activated;
                clone.GloveHitCount = original.GloveHitCount;
                clone.Flashlight_On = original.Flashlight_On;
                clone.PillAvailable = original.PillAvailable;
                clone.VehichleDistance = original.VehichleDistance;
                clone.VehichleinRange = original.VehichleinRange;
                clone.Venom = original.Venom;
                clone.StaffToggled = original.StaffToggled;
                clone.flashed = original.flashed;
                clone.falldistance = original.falldistance;
                clone.EscrimaBuildup = original.EscrimaBuildup;
                clone.blockbutton = original.blockbutton;
                clone.VenomSize = original.VenomSize;
                clone.owner = original.owner;
                clone.homingmissiletimer = original.homingmissiletimer;
                clone.TutorialText = original.TutorialText;
                clone.hint1 = original.hint1;
                clone.TutorialPt = original.TutorialPt;
                clone.DRIVINGLOOP = original.DRIVINGLOOP;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    BatmanModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    BatmanModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                BatmanModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

