/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.batmanmod.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.batmanmod.BatmanModMod;
import net.mcreator.batmanmod.procedures.BeltBatbombProcedure;
import net.mcreator.batmanmod.procedures.BeltCrypSeqProcedure;
import net.mcreator.batmanmod.procedures.BeltDartShotProcedure;
import net.mcreator.batmanmod.procedures.BeltEscrimaProcedure;
import net.mcreator.batmanmod.procedures.BeltGrappleRobinProcedure;
import net.mcreator.batmanmod.procedures.BeltWingDingProcedure;
import net.mcreator.batmanmod.world.inventory.NightwingEquipmentMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class NightwingEquipmentButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public NightwingEquipmentButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public NightwingEquipmentButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(NightwingEquipmentButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(NightwingEquipmentButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            NightwingEquipmentButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = NightwingEquipmentMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BeltGrappleRobinProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            BeltCrypSeqProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            BeltDartShotProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            BeltEscrimaProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            BeltBatbombProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            BeltWingDingProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BatmanModMod.addNetworkMessage(NightwingEquipmentButtonMessage.class, NightwingEquipmentButtonMessage::buffer, NightwingEquipmentButtonMessage::new, NightwingEquipmentButtonMessage::handler);
    }
}

