/*
 * Decompiled with CFR 0.152.
 */
package de.rinonline.korinrpg.Helper.NBT;

import de.rinonline.korinrpg.ConfigurationMoD2;
import de.rinonline.korinrpg.EnchRegistry;
import de.rinonline.korinrpg.Helper.Network.SuperPacketDispatcher;
import de.rinonline.korinrpg.Helper.Network.SyncNewPlayerPropsMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class RINPlayer2
implements IExtendedEntityProperties {
    public static final String RINS_PROP_NAME = "RINSprinting";
    private final EntityPlayer player;
    private int timer;
    private int log;
    private int renderstage = 0;
    private float rendertime = 0.0f;
    private double sprintime;
    private double retime;
    private double MaxSprintingtime = 0.0;
    private double Overchargetime = 0.0;
    private double StaminaRegen = 0.0;
    private int BarType = 41;
    private int yOffset = 0;
    private int xOffset = 0;
    private boolean isOvercharged;

    public double getStaminaRegen() {
        return this.StaminaRegen;
    }

    public double getOverchargetime() {
        return this.Overchargetime;
    }

    public RINPlayer2(EntityPlayer player) {
        this.player = player;
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(RINS_PROP_NAME, (IExtendedEntityProperties)new RINPlayer2(player));
    }

    public static final RINPlayer2 get(EntityPlayer player) {
        return (RINPlayer2)player.getExtendedProperties(RINS_PROP_NAME);
    }

    public void copy(RINPlayer2 props) {
        this.setSprintime(props.getSprintime());
        this.setOvercharged(props.isOvercharged());
        this.setRetime(props.getRetime());
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74780_a("sprintime", this.sprintime);
        properties.func_74780_a("retime", this.retime);
        properties.func_74757_a("isOvercharged", this.isOvercharged);
        properties.func_74780_a("Overchargetime", this.Overchargetime);
        properties.func_74780_a("MaxSprintingtime", this.MaxSprintingtime);
        properties.func_74780_a("StaminaRegen", this.StaminaRegen);
        properties.func_74768_a("BarType", this.BarType);
        properties.func_74768_a("xOffset", this.xOffset);
        properties.func_74768_a("yOffset", this.yOffset);
        compound.func_74782_a(RINS_PROP_NAME, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(RINS_PROP_NAME);
        this.sprintime = properties.func_74769_h("sprintime");
        this.retime = properties.func_74769_h("retime");
        this.isOvercharged = properties.func_74767_n("isOvercharged");
        this.Overchargetime = properties.func_74769_h("Overchargetime");
        this.MaxSprintingtime = properties.func_74769_h("MaxSprintingtime");
        this.StaminaRegen = properties.func_74769_h("StaminaRegen");
        this.BarType = properties.func_74762_e("BarType");
        this.xOffset = properties.func_74762_e("xOffset");
        this.yOffset = properties.func_74762_e("yOffset");
    }

    public void init(Entity entity, World world) {
        this.sprinttime(0);
        this.setOvercharged(false);
    }

    private void sprinttime(int i) {
    }

    public void onUpdate() {
        if (!this.player.field_71075_bZ.field_75098_d && this.updateTimer()) {
            if (!this.player.field_70170_p.field_72995_K) {
                if (this.log == 1) {
                    this.log = 2;
                }
                if (!this.isOvercharged()) {
                    this.MaxSprintingtime = ConfigurationMoD2.MaxSprintime;
                    this.Overchargetime = ConfigurationMoD2.OverchargeSprintime;
                    this.StaminaRegen = ConfigurationMoD2.rechargeSprintime;
                    if (this.player.func_71124_b(1) != null && this.player.func_71124_b(1).func_77948_v()) {
                        this.MaxSprintingtime += (double)EnchantmentHelper.func_77506_a((int)EnchRegistry.MaxStamina.field_77352_x, (ItemStack)this.player.func_71124_b(1)) * ConfigurationMoD2.EnchantmentMaxStamina;
                        this.Overchargetime -= (double)EnchantmentHelper.func_77506_a((int)EnchRegistry.Overloadreduction.field_77352_x, (ItemStack)this.player.func_71124_b(1)) * ConfigurationMoD2.EnchantmentOverloadreduction;
                        this.StaminaRegen += (double)EnchantmentHelper.func_77506_a((int)EnchRegistry.StaminaRegen.field_77352_x, (ItemStack)this.player.func_71124_b(1)) * ConfigurationMoD2.EnchantmentStaminaRegen;
                    }
                    if (ConfigurationMoD2.EnablePotionEffects) {
                        int u;
                        String[] arrOfStr;
                        String str = ConfigurationMoD2.PotionEffectregenerationspeedID;
                        for (String a : arrOfStr = str.split(",")) {
                            u = Integer.parseInt(a);
                            if (!this.player.func_82165_m(u)) continue;
                            this.StaminaRegen += this.StaminaRegen * ConfigurationMoD2.PotionEffectregenerationspeed;
                        }
                        str = ConfigurationMoD2.PotionEffectreduceregenID;
                        for (String a : arrOfStr = str.split(",")) {
                            u = Integer.parseInt(a);
                            if (!this.player.func_82165_m(u)) continue;
                            this.StaminaRegen -= this.StaminaRegen * ConfigurationMoD2.PotionEffectreduceregen;
                        }
                        str = ConfigurationMoD2.PotionEffectreducemaxtimeID;
                        for (String a : arrOfStr = str.split(",")) {
                            u = Integer.parseInt(a);
                            if (!this.player.func_82165_m(u)) continue;
                            this.MaxSprintingtime -= this.MaxSprintingtime * ConfigurationMoD2.PotionEffectreducemaxtime;
                        }
                        str = ConfigurationMoD2.PotionEffectexpandmaxtimeID;
                        for (String a : arrOfStr = str.split(",")) {
                            u = Integer.parseInt(a);
                            if (!this.player.func_82165_m(u)) continue;
                            this.MaxSprintingtime += this.MaxSprintingtime * ConfigurationMoD2.PotionEffectexpandmaxtime;
                        }
                    }
                    if (this.player.func_70051_ag()) {
                        if (this.sprintime >= this.MaxSprintingtime) {
                            this.sprintime = this.MaxSprintingtime;
                            this.player.func_70031_b(false);
                            this.isOvercharged = true;
                            this.retime = this.Overchargetime;
                        } else {
                            this.sprintime += 0.1;
                        }
                    } else {
                        this.recharge();
                    }
                } else {
                    if (this.retime == 0.0) {
                        this.isOvercharged = false;
                        this.retime = 0.0;
                        this.sprintime = 0.0;
                    } else {
                        this.player.func_70031_b(false);
                    }
                    this.recharge();
                }
                SuperPacketDispatcher.sendTo(new SyncNewPlayerPropsMessage(this.player), (EntityPlayerMP)this.player);
            } else {
                if (this.isOvercharged()) {
                    KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151463_i(), (boolean)false);
                }
                if (this.player.func_70051_ag() || this.sprintime != 0.0) {
                    if (this.rendertime <= (float)(ConfigurationMoD2.transparency / 100.0)) {
                        this.rendertime += 0.1f;
                    }
                } else if (this.retime == 0.0 && this.sprintime == 0.0 && this.rendertime >= 0.0f) {
                    this.rendertime -= 0.05f;
                }
            }
        }
    }

    public boolean isOvercharged() {
        return this.isOvercharged;
    }

    private void recharge() {
        this.retime -= 0.1;
        this.sprintime -= 0.1;
        if (this.sprintime < 0.0) {
            this.sprintime = 0.0;
        }
        if (this.retime < 0.0) {
            this.retime = 0.0;
        }
        SuperPacketDispatcher.sendTo(new SyncNewPlayerPropsMessage(this.player), (EntityPlayerMP)this.player);
    }

    private boolean updateTimer() {
        ++this.timer;
        if (this.timer >= 2) {
            this.timer = 0;
            return true;
        }
        return false;
    }

    public double getSprintime() {
        return this.sprintime;
    }

    public void setSprintime(double sprintime) {
        this.sprintime = sprintime;
    }

    public double getRetime() {
        return this.retime;
    }

    public void setRetime(double retime) {
        this.retime = retime;
    }

    public void setOvercharged(boolean isOvercharged) {
        this.isOvercharged = isOvercharged;
    }

    public float getRendertime() {
        return this.rendertime;
    }

    public void onAttack() {
        if (this.player.func_70051_ag()) {
            this.log = 1;
        }
    }

    public double getMaxSprintingtime() {
        return this.MaxSprintingtime;
    }

    public void subtracttamina(int amount) {
        this.sprintime += (double)(amount / 10);
        if (this.sprintime >= this.MaxSprintingtime) {
            this.sprintime = this.MaxSprintingtime;
            this.player.func_70031_b(false);
            this.retime = this.Overchargetime;
            this.isOvercharged = true;
            SuperPacketDispatcher.sendTo(new SyncNewPlayerPropsMessage(this.player), (EntityPlayerMP)this.player);
        }
    }

    public void refillStamina() {
        this.sprintime = 0.0;
        this.retime = 0.0;
        this.Overchargetime = 0.0;
        this.isOvercharged = false;
        SuperPacketDispatcher.sendTo(new SyncNewPlayerPropsMessage(this.player), (EntityPlayerMP)this.player);
    }

    public int getBarType() {
        return this.BarType;
    }

    public void setBarType(int barType) {
        this.BarType = barType < 0 || barType > 7 ? 41 : barType;
        SuperPacketDispatcher.sendTo(new SyncNewPlayerPropsMessage(this.player), (EntityPlayerMP)this.player);
    }

    public int getyOffset() {
        return this.yOffset;
    }

    public void setyOffset(int yOffset) {
        this.yOffset = yOffset;
        SuperPacketDispatcher.sendTo(new SyncNewPlayerPropsMessage(this.player), (EntityPlayerMP)this.player);
    }

    public int getxOffset() {
        return this.xOffset;
    }

    public void setxOffset(int xOffset) {
        this.xOffset = xOffset;
    }
}

