/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EffectRegistry;
import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class CursedFlameArrow
extends AbstractArrow {
    private int particleTimer = 0;
    private static final int MAX_PARTICLE_DURATION = 100;

    public CursedFlameArrow(EntityType<? extends CursedFlameArrow> entityType, Level level) {
        super(entityType, level);
    }

    public CursedFlameArrow(Level level, LivingEntity shooter) {
        super((EntityType)EntityRegistry.CURSED_FLAME_ARROW.get(), shooter, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_36703_) {
            ++this.particleTimer;
        }
        if (this.particleTimer < 100 && this.m_9236_().m_5776_()) {
            Vec3 motion = this.m_20184_();
            for (int i = 0; i < 5; ++i) {
                double xOffset = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double yOffset = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double zOffset = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_() + motion.f_82479_ * (double)i * 0.1, this.m_20186_() + motion.f_82480_ * (double)i * 0.1, this.m_20189_() + motion.f_82481_ * (double)i * 0.1, xOffset, yOffset, zOffset);
            }
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity;
        super.m_5790_(result);
        if (!this.m_9236_().m_5776_() && (entity = result.m_82443_()) instanceof LivingEntity) {
            LivingEntity hitEntity = (LivingEntity)entity;
            hitEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.CURSED_FLAME.get(), 200, 0));
            this.createCursedSoulFireParticles(hitEntity.m_20182_());
        }
    }

    protected void m_8060_(BlockHitResult result) {
        Level level;
        super.m_8060_(result);
        if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 position = result.m_82450_();
            BlockPos hitPos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, position.f_82479_, position.f_82480_, position.f_82481_, 30, 0.5, 0.5, 0.5, 0.01);
            serverLevel.m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, SoundEvents.f_12404_, this.m_5720_(), 1.0f, 1.0f);
            this.particleTimer = 100;
        }
    }

    private void createCursedSoulFireParticles(Vec3 position) {
        for (int i = 0; i < 30; ++i) {
            double xOffset = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double yOffset = this.f_19796_.m_188500_() * 0.5;
            double zOffset = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, position.f_82479_ + xOffset, position.f_82480_ + yOffset, position.f_82481_ + zOffset, 0.0, 0.1, 0.0);
        }
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

