/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;

public class IcicleJavelin
extends AbstractArrow {
    private boolean hasFrozen = false;

    public IcicleJavelin(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public IcicleJavelin(Level level, LivingEntity shooter) {
        super((EntityType)EntityRegistry.ICICLE_JAVELIN.get(), shooter, level);
        this.m_36781_(5.0);
        this.m_36767_((byte)3);
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                DamageSource damageSource = this.m_9236_().m_269111_().m_269075_(player);
                target.m_6469_(damageSource, 8.0f);
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 4));
            }
        }
        this.freezeAreaAround(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.createIceExplosion();
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12483_, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.m_146870_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.f_36703_ && !this.hasFrozen) {
            this.freezeAreaAround(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.hasFrozen = true;
            this.m_146870_();
        }
        if (this.m_9236_().m_5776_()) {
            this.createTrailParticles();
        }
    }

    private void freezeAreaAround(double x, double y, double z) {
        BlockPos impactPos = new BlockPos((int)x, (int)y, (int)z);
        if (this.m_9236_().m_8055_(impactPos).m_60795_() || this.m_9236_().m_8055_(impactPos).m_247087_()) {
            this.m_9236_().m_46597_(impactPos, Blocks.f_50354_.m_49966_());
        } else {
            BlockPos adjacentPos = this.findAdjacentBlock(impactPos);
            if (adjacentPos != null) {
                this.m_9236_().m_46597_(adjacentPos, Blocks.f_50354_.m_49966_());
            }
        }
    }

    private BlockPos findAdjacentBlock(BlockPos impactPos) {
        BlockPos[] adjacentPositions;
        for (BlockPos pos : adjacentPositions = new BlockPos[]{impactPos.m_7494_(), impactPos.m_7495_(), impactPos.m_122012_(), impactPos.m_122019_(), impactPos.m_122029_(), impactPos.m_122024_()}) {
            if (!this.m_9236_().m_8055_(pos).m_60795_() && !this.m_9236_().m_8055_(pos).m_247087_()) continue;
            return pos;
        }
        return null;
    }

    private void createIceExplosion() {
        for (int i = 0; i < 20; ++i) {
            double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            double offsetY = this.f_19796_.m_188500_() * 0.5;
            double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    private void createTrailParticles() {
        for (int i = 0; i < 5; ++i) {
            double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.2;
            double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.2;
            double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.2;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }
}

