/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.forge.loot;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BowLootInjectorPlatformImpl {
    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation id = event.getName();
        if (BowLootInjectorPlatformImpl.isEasyLootTable(id)) {
            event.getTable().addPool(BowLootInjectorPlatformImpl.createCommonBowPool());
        } else if (BowLootInjectorPlatformImpl.isMediumLootTable(id)) {
            event.getTable().addPool(BowLootInjectorPlatformImpl.createUncommonBowPool());
        } else if (BowLootInjectorPlatformImpl.isHardLootTable(id)) {
            event.getTable().addPool(BowLootInjectorPlatformImpl.createRareBowPool());
        } else if (BowLootInjectorPlatformImpl.isEndGameLootTable(id)) {
            event.getTable().addPool(BowLootInjectorPlatformImpl.createEpicBowPool());
        }
    }

    private static boolean isEasyLootTable(ResourceLocation id) {
        return id.equals((Object)BuiltInLootTables.f_78742_) || id.equals((Object)BuiltInLootTables.f_78759_);
    }

    private static boolean isMediumLootTable(ResourceLocation id) {
        return id.equals((Object)BuiltInLootTables.f_78686_) || id.equals((Object)BuiltInLootTables.f_78696_);
    }

    private static boolean isHardLootTable(ResourceLocation id) {
        return id.equals((Object)BuiltInLootTables.f_78763_) || id.equals((Object)BuiltInLootTables.f_78760_);
    }

    private static boolean isEndGameLootTable(ResourceLocation id) {
        return id.equals((Object)BuiltInLootTables.f_78741_) || id.equals((Object)BuiltInLootTables.f_78697_);
    }

    private static LootPool createCommonBowPool() {
        return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("too_many_bows", "chests/common_bows"))).m_79082_();
    }

    private static LootPool createUncommonBowPool() {
        return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("too_many_bows", "chests/uncommon_bows"))).m_79082_();
    }

    private static LootPool createRareBowPool() {
        return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("too_many_bows", "chests/rare_bows"))).m_79082_();
    }

    private static LootPool createEpicBowPool() {
        return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("too_many_bows", "chests/epic_bows"))).m_79082_();
    }
}

