/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ArcaneBow
extends BowItem {
    public ArcaneBow(Item.Properties properties) {
        super(properties);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeCharged) {
        if (entity instanceof Player) {
            boolean hasFlame;
            Player player = (Player)entity;
            int charge = this.m_8105_(stack) - timeCharged;
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12348_, SoundSource.PLAYERS, 1.0f, 1.0f);
            boolean hasInfinity = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
            int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
            int punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack);
            boolean bl = hasFlame = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0;
            if (charge >= 20 && (hasInfinity || this.consumeArrows(player, 3))) {
                this.fireExtraArrows(level, player, hasInfinity, powerLevel, punchLevel, hasFlame);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
            }
        }
    }

    private boolean consumeArrows(Player player, int count) {
        if (player.m_150110_().f_35937_) {
            return true;
        }
        int arrowsRemoved = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41720_() != Items.f_42412_) continue;
            int removeAmount = Math.min(stack.m_41613_(), count - arrowsRemoved);
            stack.m_41774_(removeAmount);
            if ((arrowsRemoved += removeAmount) < count) continue;
            return true;
        }
        return false;
    }

    private void fireExtraArrows(Level level, Player player, final boolean hasInfinity, int powerLevel, int punchLevel, boolean hasFlame) {
        float basePitch = player.m_146909_();
        float baseYaw = player.m_146908_();
        for (int i = -1; i <= 1; ++i) {
            AbstractArrow extraArrow = new AbstractArrow(EntityType.f_20548_, (LivingEntity)player, level){

                protected ItemStack m_7941_() {
                    return hasInfinity ? ItemStack.f_41583_ : new ItemStack((ItemLike)Items.f_42412_);
                }
            };
            extraArrow.m_37251_((Entity)player, basePitch, baseYaw + (float)i * 5.0f, 0.0f, 4.0f, 1.0f);
            if (powerLevel > 0) {
                extraArrow.m_36781_(extraArrow.m_36789_() + (double)powerLevel * 0.5 + 4.0);
            } else {
                extraArrow.m_36781_(extraArrow.m_36789_() + 4.0);
            }
            if (punchLevel > 0) {
                extraArrow.m_36735_(punchLevel);
            }
            if (hasFlame) {
                extraArrow.m_20254_(100);
            }
            if (hasInfinity) {
                extraArrow.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            }
            level.m_7967_((Entity)extraArrow);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int timeLeft) {
        super.m_5929_(level, entity, stack, timeLeft);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int charge = this.m_8105_(stack) - timeLeft;
            if (charge == 10) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12349_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.many_bows.arcane_bow.tooltip").m_130940_(ChatFormatting.LIGHT_PURPLE));
        tooltip.add((Component)Component.m_237115_((String)"item.many_bows.arcane_bow.tooltip.ability").m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237115_((String)"item.many_bows.arcane_bow.tooltip.legend").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
    }
}

